@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property logicAppResourceId The resource id of the playbook resource.
 * @property tenantId The tenant id of the playbook resource.
 */
public data class PlaybookActionPropertiesResponse(
    public val logicAppResourceId: String,
    public val tenantId: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.outputs.PlaybookActionPropertiesResponse):
            PlaybookActionPropertiesResponse = PlaybookActionPropertiesResponse(
            logicAppResourceId = javaType.logicAppResourceId(),
            tenantId = javaType.tenantId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
