@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 * Required permissions for the connector resource provider that define in ResourceProviders.
 * For more information about the permissions see <see href="https://docs.microsoft.com/en-us/azure/role-based-access-control/role-definitions#actions-format">here</see>.
 * @property action Gets or sets a value indicating whether the permission is custom actions (POST).
 * @property delete Gets or sets a value indicating whether the permission is delete action (DELETE).
 * @property read Gets or sets a value indicating whether the permission is read action (GET).
 * @property write Gets or sets a value indicating whether the permission is write action (PUT or PATCH).
 */
public data class ResourceProviderRequiredPermissionsResponse(
    public val action: Boolean? = null,
    public val delete: Boolean? = null,
    public val read: Boolean? = null,
    public val write: Boolean? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.outputs.ResourceProviderRequiredPermissionsResponse):
            ResourceProviderRequiredPermissionsResponse = ResourceProviderRequiredPermissionsResponse(
            action = javaType.action().map({ args0 -> args0 }).orElse(null),
            delete = javaType.delete().map({ args0 -> args0 }).orElse(null),
            read = javaType.read().map({ args0 -> args0 }).orElse(null),
            write = javaType.write().map({ args0 -> args0 }).orElse(null),
        )
    }
}
