@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.securityinsights.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Detail about the webhook object.
 * @property rotateWebhookSecret A flag to instruct the backend service to rotate webhook secret.
 * @property webhookId Unique identifier for the webhook.
 * @property webhookSecretUpdateTime Time when the webhook secret was updated.
 * @property webhookUrl URL that gets invoked by the webhook.
 */
public data class WebhookResponse(
    public val rotateWebhookSecret: Boolean? = null,
    public val webhookId: String? = null,
    public val webhookSecretUpdateTime: String? = null,
    public val webhookUrl: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.securityinsights.outputs.WebhookResponse):
            WebhookResponse = WebhookResponse(
            rotateWebhookSecret = javaType.rotateWebhookSecret().map({ args0 -> args0 }).orElse(null),
            webhookId = javaType.webhookId().map({ args0 -> args0 }).orElse(null),
            webhookSecretUpdateTime = javaType.webhookSecretUpdateTime().map({ args0 -> args0 }).orElse(null),
            webhookUrl = javaType.webhookUrl().map({ args0 -> args0 }).orElse(null),
        )
    }
}
