@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.serialconsole.kotlin

import com.pulumi.azurenative.serialconsole.SerialconsoleFunctions.getSerialPortPlain
import com.pulumi.azurenative.serialconsole.kotlin.inputs.GetSerialPortPlainArgs
import com.pulumi.azurenative.serialconsole.kotlin.inputs.GetSerialPortPlainArgsBuilder
import com.pulumi.azurenative.serialconsole.kotlin.outputs.GetSerialPortResult
import com.pulumi.azurenative.serialconsole.kotlin.outputs.GetSerialPortResult.Companion.toKotlin
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

public object SerialconsoleFunctions {
    /**
     * Gets the configured settings for a serial port
     * Azure REST API version: 2018-05-01.
     * @param argument null
     * @return Represents the serial port of the parent resource.
     */
    public suspend fun getSerialPort(argument: GetSerialPortPlainArgs): GetSerialPortResult =
        toKotlin(getSerialPortPlain(argument.toJava()).await())

    /**
     * @see [getSerialPort].
     * @param parentResource The resource name, or subordinate path, for the parent of the serial port. For example: the name of the virtual machine.
     * @param parentResourceType The resource type of the parent resource.  For example: 'virtualMachines' or 'virtualMachineScaleSets'
     * @param resourceGroupName The name of the resource group.
     * @param resourceProviderNamespace The namespace of the resource provider.
     * @param serialPort The name of the serial port to connect to.
     * @return Represents the serial port of the parent resource.
     */
    public suspend fun getSerialPort(
        parentResource: String,
        parentResourceType: String,
        resourceGroupName: String,
        resourceProviderNamespace: String,
        serialPort: String,
    ): GetSerialPortResult {
        val argument = GetSerialPortPlainArgs(
            parentResource = parentResource,
            parentResourceType = parentResourceType,
            resourceGroupName = resourceGroupName,
            resourceProviderNamespace = resourceProviderNamespace,
            serialPort = serialPort,
        )
        return toKotlin(getSerialPortPlain(argument.toJava()).await())
    }

    /**
     * @see [getSerialPort].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;serialconsole&#46;kotlin&#46;inputs&#46;GetSerialPortPlainArgs].
     * @return Represents the serial port of the parent resource.
     */
    public suspend fun getSerialPort(argument: suspend GetSerialPortPlainArgsBuilder.() -> Unit):
        GetSerialPortResult {
        val builder = GetSerialPortPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return toKotlin(getSerialPortPlain(builtArgument.toJava()).await())
    }
}
