@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicebus.kotlin

import com.pulumi.azurenative.servicebus.DisasterRecoveryConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Single item in List or Get Alias(Disaster Recovery configuration) operation
 * Azure REST API version: 2022-01-01-preview. Prior API version in Azure Native 1.x: 2017-04-01.
 * Other available API versions: 2022-10-01-preview.
 * ## Example Usage
 * ### SBAliasCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var disasterRecoveryConfig = new AzureNative.ServiceBus.DisasterRecoveryConfig("disasterRecoveryConfig", new()
 *     {
 *         Alias = "sdk-Namespace-8860",
 *         AlternateName = "alternameforAlias-Namespace-8860",
 *         NamespaceName = "sdk-Namespace-8860",
 *         PartnerNamespace = "sdk-Namespace-37",
 *         ResourceGroupName = "ardsouzatestRG",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/servicebus/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := servicebus.NewDisasterRecoveryConfig(ctx, "disasterRecoveryConfig", &servicebus.DisasterRecoveryConfigArgs{
 * 			Alias:             pulumi.String("sdk-Namespace-8860"),
 * 			AlternateName:     pulumi.String("alternameforAlias-Namespace-8860"),
 * 			NamespaceName:     pulumi.String("sdk-Namespace-8860"),
 * 			PartnerNamespace:  pulumi.String("sdk-Namespace-37"),
 * 			ResourceGroupName: pulumi.String("ardsouzatestRG"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.servicebus.DisasterRecoveryConfig;
 * import com.pulumi.azurenative.servicebus.DisasterRecoveryConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var disasterRecoveryConfig = new DisasterRecoveryConfig("disasterRecoveryConfig", DisasterRecoveryConfigArgs.builder()
 *             .alias("sdk-Namespace-8860")
 *             .alternateName("alternameforAlias-Namespace-8860")
 *             .namespaceName("sdk-Namespace-8860")
 *             .partnerNamespace("sdk-Namespace-37")
 *             .resourceGroupName("ardsouzatestRG")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:servicebus:DisasterRecoveryConfig sdk-Namespace-8860 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/disasterRecoveryConfigs/{alias}
 * ```
 * @property alias The Disaster Recovery configuration name
 * @property alternateName Primary/Secondary eventhub namespace name, which is part of GEO DR pairing
 * @property namespaceName The namespace name
 * @property partnerNamespace ARM Id of the Primary/Secondary eventhub namespace name, which is part of GEO DR pairing
 * @property resourceGroupName Name of the Resource group within the Azure subscription.
 */
public data class DisasterRecoveryConfigArgs(
    public val alias: Output<String>? = null,
    public val alternateName: Output<String>? = null,
    public val namespaceName: Output<String>? = null,
    public val partnerNamespace: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.servicebus.DisasterRecoveryConfigArgs> {
    override fun toJava(): com.pulumi.azurenative.servicebus.DisasterRecoveryConfigArgs =
        com.pulumi.azurenative.servicebus.DisasterRecoveryConfigArgs.builder()
            .alias(alias?.applyValue({ args0 -> args0 }))
            .alternateName(alternateName?.applyValue({ args0 -> args0 }))
            .namespaceName(namespaceName?.applyValue({ args0 -> args0 }))
            .partnerNamespace(partnerNamespace?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DisasterRecoveryConfigArgs].
 */
@PulumiTagMarker
public class DisasterRecoveryConfigArgsBuilder internal constructor() {
    private var alias: Output<String>? = null

    private var alternateName: Output<String>? = null

    private var namespaceName: Output<String>? = null

    private var partnerNamespace: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value The Disaster Recovery configuration name
     */
    @JvmName("uulfbiurqhbliqip")
    public suspend fun alias(`value`: Output<String>) {
        this.alias = value
    }

    /**
     * @param value Primary/Secondary eventhub namespace name, which is part of GEO DR pairing
     */
    @JvmName("newugfuyllkcucpc")
    public suspend fun alternateName(`value`: Output<String>) {
        this.alternateName = value
    }

    /**
     * @param value The namespace name
     */
    @JvmName("wbfrdjodjwefdmyu")
    public suspend fun namespaceName(`value`: Output<String>) {
        this.namespaceName = value
    }

    /**
     * @param value ARM Id of the Primary/Secondary eventhub namespace name, which is part of GEO DR pairing
     */
    @JvmName("ehrgfklclqhxpnoc")
    public suspend fun partnerNamespace(`value`: Output<String>) {
        this.partnerNamespace = value
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("hawjvrrxguofltgv")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The Disaster Recovery configuration name
     */
    @JvmName("owawssraxscdgsct")
    public suspend fun alias(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alias = mapped
    }

    /**
     * @param value Primary/Secondary eventhub namespace name, which is part of GEO DR pairing
     */
    @JvmName("aqdproctswklhfic")
    public suspend fun alternateName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alternateName = mapped
    }

    /**
     * @param value The namespace name
     */
    @JvmName("ccnhkefirsijpmvx")
    public suspend fun namespaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespaceName = mapped
    }

    /**
     * @param value ARM Id of the Primary/Secondary eventhub namespace name, which is part of GEO DR pairing
     */
    @JvmName("akasfdofonjtbnmi")
    public suspend fun partnerNamespace(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partnerNamespace = mapped
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("ylcaalnyyififsbe")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): DisasterRecoveryConfigArgs = DisasterRecoveryConfigArgs(
        alias = alias,
        alternateName = alternateName,
        namespaceName = namespaceName,
        partnerNamespace = partnerNamespace,
        resourceGroupName = resourceGroupName,
    )
}
