@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicebus.kotlin

import com.pulumi.azurenative.servicebus.kotlin.outputs.EncryptionResponse
import com.pulumi.azurenative.servicebus.kotlin.outputs.IdentityResponse
import com.pulumi.azurenative.servicebus.kotlin.outputs.PrivateEndpointConnectionResponse
import com.pulumi.azurenative.servicebus.kotlin.outputs.SBSkuResponse
import com.pulumi.azurenative.servicebus.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.servicebus.kotlin.outputs.EncryptionResponse.Companion.toKotlin as encryptionResponseToKotlin
import com.pulumi.azurenative.servicebus.kotlin.outputs.IdentityResponse.Companion.toKotlin as identityResponseToKotlin
import com.pulumi.azurenative.servicebus.kotlin.outputs.PrivateEndpointConnectionResponse.Companion.toKotlin as privateEndpointConnectionResponseToKotlin
import com.pulumi.azurenative.servicebus.kotlin.outputs.SBSkuResponse.Companion.toKotlin as sBSkuResponseToKotlin
import com.pulumi.azurenative.servicebus.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Namespace].
 */
@PulumiTagMarker
public class NamespaceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: NamespaceArgs = NamespaceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend NamespaceArgsBuilder.() -> Unit) {
        val builder = NamespaceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Namespace {
        val builtJavaResource = com.pulumi.azurenative.servicebus.Namespace(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Namespace(builtJavaResource)
    }
}

/**
 * Description of a namespace resource.
 * Azure REST API version: 2022-01-01-preview. Prior API version in Azure Native 1.x: 2017-04-01.
 * Other available API versions: 2015-08-01, 2022-10-01-preview.
 * ## Example Usage
 * ### NameSpaceCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @namespace = new AzureNative.ServiceBus.Namespace("namespace", new()
 *     {
 *         Location = "South Central US",
 *         NamespaceName = "sdk-Namespace2924",
 *         ResourceGroupName = "ArunMonocle",
 *         Sku = new AzureNative.ServiceBus.Inputs.SBSkuArgs
 *         {
 *             Name = AzureNative.ServiceBus.SkuName.Standard,
 *             Tier = AzureNative.ServiceBus.SkuTier.Standard,
 *         },
 *         Tags =
 *         {
 *             { "tag1", "value1" },
 *             { "tag2", "value2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/servicebus/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := servicebus.NewNamespace(ctx, "namespace", &servicebus.NamespaceArgs{
 * 			Location:          pulumi.String("South Central US"),
 * 			NamespaceName:     pulumi.String("sdk-Namespace2924"),
 * 			ResourceGroupName: pulumi.String("ArunMonocle"),
 * 			Sku: &servicebus.SBSkuArgs{
 * 				Name: pulumi.String(servicebus.SkuNameStandard),
 * 				Tier: pulumi.String(servicebus.SkuTierStandard),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"tag1": pulumi.String("value1"),
 * 				"tag2": pulumi.String("value2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.servicebus.Namespace;
 * import com.pulumi.azurenative.servicebus.NamespaceArgs;
 * import com.pulumi.azurenative.servicebus.inputs.SBSkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var namespace = new Namespace("namespace", NamespaceArgs.builder()
 *             .location("South Central US")
 *             .namespaceName("sdk-Namespace2924")
 *             .resourceGroupName("ArunMonocle")
 *             .sku(SBSkuArgs.builder()
 *                 .name("Standard")
 *                 .tier("Standard")
 *                 .build())
 *             .tags(Map.ofEntries(
 *                 Map.entry("tag1", "value1"),
 *                 Map.entry("tag2", "value2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:servicebus:Namespace sdk-Namespace-2924 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}
 * ```
 */
public class Namespace internal constructor(
    override val javaResource: com.pulumi.azurenative.servicebus.Namespace,
) : KotlinCustomResource(javaResource, NamespaceMapper) {
    /**
     * Alternate name for namespace
     */
    public val alternateName: Output<String>?
        get() = javaResource.alternateName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The time the namespace was created
     */
    public val createdAt: Output<String>
        get() = javaResource.createdAt().applyValue({ args0 -> args0 })

    /**
     * This property disables SAS authentication for the Service Bus namespace.
     */
    public val disableLocalAuth: Output<Boolean>?
        get() = javaResource.disableLocalAuth().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Properties of BYOK Encryption description
     */
    public val encryption: Output<EncryptionResponse>?
        get() = javaResource.encryption().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    encryptionResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Properties of BYOK Identity description
     */
    public val identity: Output<IdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    identityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The Geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Identifier for Azure Insights metrics
     */
    public val metricId: Output<String>
        get() = javaResource.metricId().applyValue({ args0 -> args0 })

    /**
     * The minimum TLS version for the cluster to support, e.g. '1.2'
     */
    public val minimumTlsVersion: Output<String>?
        get() = javaResource.minimumTlsVersion().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Resource name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * List of private endpoint connections.
     */
    public val privateEndpointConnections: Output<List<PrivateEndpointConnectionResponse>>?
        get() = javaResource.privateEndpointConnections().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        privateEndpointConnectionResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Provisioning state of the namespace.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * This determines if traffic is allowed over public network. By default it is enabled.
     */
    public val publicNetworkAccess: Output<String>?
        get() = javaResource.publicNetworkAccess().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Endpoint you can use to perform Service Bus operations.
     */
    public val serviceBusEndpoint: Output<String>
        get() = javaResource.serviceBusEndpoint().applyValue({ args0 -> args0 })

    /**
     * Properties of SKU
     */
    public val sku: Output<SBSkuResponse>?
        get() = javaResource.sku().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    sBSkuResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Status of the namespace.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The system meta data relating to this resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The time the namespace was updated.
     */
    public val updatedAt: Output<String>
        get() = javaResource.updatedAt().applyValue({ args0 -> args0 })

    /**
     * Enabling this property creates a Premium Service Bus Namespace in regions supported availability zones.
     */
    public val zoneRedundant: Output<Boolean>?
        get() = javaResource.zoneRedundant().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })
}

public object NamespaceMapper : ResourceMapper<Namespace> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.servicebus.Namespace::class == javaResource::class

    override fun map(javaResource: Resource): Namespace = Namespace(
        javaResource as
            com.pulumi.azurenative.servicebus.Namespace,
    )
}

/**
 * @see [Namespace].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Namespace].
 */
public suspend fun namespace(name: String, block: suspend NamespaceResourceBuilder.() -> Unit):
    Namespace {
    val builder = NamespaceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Namespace].
 * @param name The _unique_ name of the resulting resource.
 */
public fun namespace(name: String): Namespace {
    val builder = NamespaceResourceBuilder()
    builder.name(name)
    return builder.build()
}
