@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicebus.kotlin

import com.pulumi.azurenative.servicebus.kotlin.outputs.NWRuleSetIpRulesResponse
import com.pulumi.azurenative.servicebus.kotlin.outputs.NWRuleSetVirtualNetworkRulesResponse
import com.pulumi.azurenative.servicebus.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import com.pulumi.azurenative.servicebus.kotlin.outputs.NWRuleSetIpRulesResponse.Companion.toKotlin as nWRuleSetIpRulesResponseToKotlin
import com.pulumi.azurenative.servicebus.kotlin.outputs.NWRuleSetVirtualNetworkRulesResponse.Companion.toKotlin as nWRuleSetVirtualNetworkRulesResponseToKotlin
import com.pulumi.azurenative.servicebus.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [NamespaceNetworkRuleSet].
 */
@PulumiTagMarker
public class NamespaceNetworkRuleSetResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: NamespaceNetworkRuleSetArgs = NamespaceNetworkRuleSetArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend NamespaceNetworkRuleSetArgsBuilder.() -> Unit) {
        val builder = NamespaceNetworkRuleSetArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): NamespaceNetworkRuleSet {
        val builtJavaResource =
            com.pulumi.azurenative.servicebus.NamespaceNetworkRuleSet(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return NamespaceNetworkRuleSet(builtJavaResource)
    }
}

/**
 * Description of NetworkRuleSet resource.
 * Azure REST API version: 2022-01-01-preview. Prior API version in Azure Native 1.x: 2017-04-01.
 * Other available API versions: 2022-10-01-preview.
 * ## Example Usage
 * ### NameSpaceNetworkRuleSetCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var namespaceNetworkRuleSet = new AzureNative.ServiceBus.NamespaceNetworkRuleSet("namespaceNetworkRuleSet", new()
 *     {
 *         DefaultAction = AzureNative.ServiceBus.DefaultAction.Deny,
 *         IpRules = new[]
 *         {
 *             new AzureNative.ServiceBus.Inputs.NWRuleSetIpRulesArgs
 *             {
 *                 Action = AzureNative.ServiceBus.NetworkRuleIPAction.Allow,
 *                 IpMask = "1.1.1.1",
 *             },
 *             new AzureNative.ServiceBus.Inputs.NWRuleSetIpRulesArgs
 *             {
 *                 Action = AzureNative.ServiceBus.NetworkRuleIPAction.Allow,
 *                 IpMask = "1.1.1.2",
 *             },
 *             new AzureNative.ServiceBus.Inputs.NWRuleSetIpRulesArgs
 *             {
 *                 Action = AzureNative.ServiceBus.NetworkRuleIPAction.Allow,
 *                 IpMask = "1.1.1.3",
 *             },
 *             new AzureNative.ServiceBus.Inputs.NWRuleSetIpRulesArgs
 *             {
 *                 Action = AzureNative.ServiceBus.NetworkRuleIPAction.Allow,
 *                 IpMask = "1.1.1.4",
 *             },
 *             new AzureNative.ServiceBus.Inputs.NWRuleSetIpRulesArgs
 *             {
 *                 Action = AzureNative.ServiceBus.NetworkRuleIPAction.Allow,
 *                 IpMask = "1.1.1.5",
 *             },
 *         },
 *         NamespaceName = "sdk-Namespace-6019",
 *         ResourceGroupName = "ResourceGroup",
 *         VirtualNetworkRules = new[]
 *         {
 *             new AzureNative.ServiceBus.Inputs.NWRuleSetVirtualNetworkRulesArgs
 *             {
 *                 IgnoreMissingVnetServiceEndpoint = true,
 *                 Subnet = new AzureNative.ServiceBus.Inputs.SubnetArgs
 *                 {
 *                     Id = "/subscriptions/854d368f-1828-428f-8f3c-f2affa9b2f7d/resourcegroups/alitest/providers/Microsoft.Network/virtualNetworks/myvn/subnets/subnet2",
 *                 },
 *             },
 *             new AzureNative.ServiceBus.Inputs.NWRuleSetVirtualNetworkRulesArgs
 *             {
 *                 IgnoreMissingVnetServiceEndpoint = false,
 *                 Subnet = new AzureNative.ServiceBus.Inputs.SubnetArgs
 *                 {
 *                     Id = "/subscriptions/854d368f-1828-428f-8f3c-f2affa9b2f7d/resourcegroups/alitest/providers/Microsoft.Network/virtualNetworks/myvn/subnets/subnet3",
 *                 },
 *             },
 *             new AzureNative.ServiceBus.Inputs.NWRuleSetVirtualNetworkRulesArgs
 *             {
 *                 IgnoreMissingVnetServiceEndpoint = false,
 *                 Subnet = new AzureNative.ServiceBus.Inputs.SubnetArgs
 *                 {
 *                     Id = "/subscriptions/854d368f-1828-428f-8f3c-f2affa9b2f7d/resourcegroups/alitest/providers/Microsoft.Network/virtualNetworks/myvn/subnets/subnet6",
 *                 },
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/servicebus/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := servicebus.NewNamespaceNetworkRuleSet(ctx, "namespaceNetworkRuleSet", &servicebus.NamespaceNetworkRuleSetArgs{
 * 			DefaultAction: pulumi.String(servicebus.DefaultActionDeny),
 * 			IpRules: servicebus.NWRuleSetIpRulesArray{
 * 				&servicebus.NWRuleSetIpRulesArgs{
 * 					Action: pulumi.String(servicebus.NetworkRuleIPActionAllow),
 * 					IpMask: pulumi.String("1.1.1.1"),
 * 				},
 * 				&servicebus.NWRuleSetIpRulesArgs{
 * 					Action: pulumi.String(servicebus.NetworkRuleIPActionAllow),
 * 					IpMask: pulumi.String("1.1.1.2"),
 * 				},
 * 				&servicebus.NWRuleSetIpRulesArgs{
 * 					Action: pulumi.String(servicebus.NetworkRuleIPActionAllow),
 * 					IpMask: pulumi.String("1.1.1.3"),
 * 				},
 * 				&servicebus.NWRuleSetIpRulesArgs{
 * 					Action: pulumi.String(servicebus.NetworkRuleIPActionAllow),
 * 					IpMask: pulumi.String("1.1.1.4"),
 * 				},
 * 				&servicebus.NWRuleSetIpRulesArgs{
 * 					Action: pulumi.String(servicebus.NetworkRuleIPActionAllow),
 * 					IpMask: pulumi.String("1.1.1.5"),
 * 				},
 * 			},
 * 			NamespaceName:     pulumi.String("sdk-Namespace-6019"),
 * 			ResourceGroupName: pulumi.String("ResourceGroup"),
 * 			VirtualNetworkRules: servicebus.NWRuleSetVirtualNetworkRulesArray{
 * 				&servicebus.NWRuleSetVirtualNetworkRulesArgs{
 * 					IgnoreMissingVnetServiceEndpoint: pulumi.Bool(true),
 * 					Subnet: &servicebus.SubnetArgs{
 * 						Id: pulumi.String("/subscriptions/854d368f-1828-428f-8f3c-f2affa9b2f7d/resourcegroups/alitest/providers/Microsoft.Network/virtualNetworks/myvn/subnets/subnet2"),
 * 					},
 * 				},
 * 				&servicebus.NWRuleSetVirtualNetworkRulesArgs{
 * 					IgnoreMissingVnetServiceEndpoint: pulumi.Bool(false),
 * 					Subnet: &servicebus.SubnetArgs{
 * 						Id: pulumi.String("/subscriptions/854d368f-1828-428f-8f3c-f2affa9b2f7d/resourcegroups/alitest/providers/Microsoft.Network/virtualNetworks/myvn/subnets/subnet3"),
 * 					},
 * 				},
 * 				&servicebus.NWRuleSetVirtualNetworkRulesArgs{
 * 					IgnoreMissingVnetServiceEndpoint: pulumi.Bool(false),
 * 					Subnet: &servicebus.SubnetArgs{
 * 						Id: pulumi.String("/subscriptions/854d368f-1828-428f-8f3c-f2affa9b2f7d/resourcegroups/alitest/providers/Microsoft.Network/virtualNetworks/myvn/subnets/subnet6"),
 * 					},
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.servicebus.NamespaceNetworkRuleSet;
 * import com.pulumi.azurenative.servicebus.NamespaceNetworkRuleSetArgs;
 * import com.pulumi.azurenative.servicebus.inputs.NWRuleSetIpRulesArgs;
 * import com.pulumi.azurenative.servicebus.inputs.NWRuleSetVirtualNetworkRulesArgs;
 * import com.pulumi.azurenative.servicebus.inputs.SubnetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var namespaceNetworkRuleSet = new NamespaceNetworkRuleSet("namespaceNetworkRuleSet", NamespaceNetworkRuleSetArgs.builder()
 *             .defaultAction("Deny")
 *             .ipRules(
 *                 NWRuleSetIpRulesArgs.builder()
 *                     .action("Allow")
 *                     .ipMask("1.1.1.1")
 *                     .build(),
 *                 NWRuleSetIpRulesArgs.builder()
 *                     .action("Allow")
 *                     .ipMask("1.1.1.2")
 *                     .build(),
 *                 NWRuleSetIpRulesArgs.builder()
 *                     .action("Allow")
 *                     .ipMask("1.1.1.3")
 *                     .build(),
 *                 NWRuleSetIpRulesArgs.builder()
 *                     .action("Allow")
 *                     .ipMask("1.1.1.4")
 *                     .build(),
 *                 NWRuleSetIpRulesArgs.builder()
 *                     .action("Allow")
 *                     .ipMask("1.1.1.5")
 *                     .build())
 *             .namespaceName("sdk-Namespace-6019")
 *             .resourceGroupName("ResourceGroup")
 *             .virtualNetworkRules(
 *                 NWRuleSetVirtualNetworkRulesArgs.builder()
 *                     .ignoreMissingVnetServiceEndpoint(true)
 *                     .subnet(SubnetArgs.builder()
 *                         .id("/subscriptions/854d368f-1828-428f-8f3c-f2affa9b2f7d/resourcegroups/alitest/providers/Microsoft.Network/virtualNetworks/myvn/subnets/subnet2")
 *                         .build())
 *                     .build(),
 *                 NWRuleSetVirtualNetworkRulesArgs.builder()
 *                     .ignoreMissingVnetServiceEndpoint(false)
 *                     .subnet(SubnetArgs.builder()
 *                         .id("/subscriptions/854d368f-1828-428f-8f3c-f2affa9b2f7d/resourcegroups/alitest/providers/Microsoft.Network/virtualNetworks/myvn/subnets/subnet3")
 *                         .build())
 *                     .build(),
 *                 NWRuleSetVirtualNetworkRulesArgs.builder()
 *                     .ignoreMissingVnetServiceEndpoint(false)
 *                     .subnet(SubnetArgs.builder()
 *                         .id("/subscriptions/854d368f-1828-428f-8f3c-f2affa9b2f7d/resourcegroups/alitest/providers/Microsoft.Network/virtualNetworks/myvn/subnets/subnet6")
 *                         .build())
 *                     .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:servicebus:NamespaceNetworkRuleSet default /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/networkRuleSets/default
 * ```
 */
public class NamespaceNetworkRuleSet internal constructor(
    override val javaResource: com.pulumi.azurenative.servicebus.NamespaceNetworkRuleSet,
) : KotlinCustomResource(javaResource, NamespaceNetworkRuleSetMapper) {
    /**
     * Default Action for Network Rule Set
     */
    public val defaultAction: Output<String>?
        get() = javaResource.defaultAction().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * List of IpRules
     */
    public val ipRules: Output<List<NWRuleSetIpRulesResponse>>?
        get() = javaResource.ipRules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> nWRuleSetIpRulesResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * This determines if traffic is allowed over public network. By default it is enabled.
     */
    public val publicNetworkAccess: Output<String>?
        get() = javaResource.publicNetworkAccess().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The system meta data relating to this resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Value that indicates whether Trusted Service Access is Enabled or not.
     */
    public val trustedServiceAccessEnabled: Output<Boolean>?
        get() = javaResource.trustedServiceAccessEnabled().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.EventHub/Namespaces" or "Microsoft.EventHub/Namespaces/EventHubs"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * List VirtualNetwork Rules
     */
    public val virtualNetworkRules: Output<List<NWRuleSetVirtualNetworkRulesResponse>>?
        get() = javaResource.virtualNetworkRules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        nWRuleSetVirtualNetworkRulesResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })
}

public object NamespaceNetworkRuleSetMapper : ResourceMapper<NamespaceNetworkRuleSet> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.servicebus.NamespaceNetworkRuleSet::class == javaResource::class

    override fun map(javaResource: Resource): NamespaceNetworkRuleSet =
        NamespaceNetworkRuleSet(
            javaResource as
                com.pulumi.azurenative.servicebus.NamespaceNetworkRuleSet,
        )
}

/**
 * @see [NamespaceNetworkRuleSet].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [NamespaceNetworkRuleSet].
 */
public suspend fun namespaceNetworkRuleSet(
    name: String,
    block: suspend NamespaceNetworkRuleSetResourceBuilder.() -> Unit,
): NamespaceNetworkRuleSet {
    val builder = NamespaceNetworkRuleSetResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [NamespaceNetworkRuleSet].
 * @param name The _unique_ name of the resulting resource.
 */
public fun namespaceNetworkRuleSet(name: String): NamespaceNetworkRuleSet {
    val builder = NamespaceNetworkRuleSetResourceBuilder()
    builder.name(name)
    return builder.build()
}
