@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicebus.kotlin

import com.pulumi.azurenative.servicebus.QueueArgs.builder
import com.pulumi.azurenative.servicebus.kotlin.enums.EntityStatus
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Description of queue Resource.
 * Azure REST API version: 2022-01-01-preview. Prior API version in Azure Native 1.x: 2017-04-01.
 * Other available API versions: 2015-08-01, 2022-10-01-preview.
 * ## Example Usage
 * ### QueueCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var queue = new AzureNative.ServiceBus.Queue("queue", new()
 *     {
 *         EnablePartitioning = true,
 *         NamespaceName = "sdk-Namespace-3174",
 *         QueueName = "sdk-Queues-5647",
 *         ResourceGroupName = "ArunMonocle",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/servicebus/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := servicebus.NewQueue(ctx, "queue", &servicebus.QueueArgs{
 * 			EnablePartitioning: pulumi.Bool(true),
 * 			NamespaceName:      pulumi.String("sdk-Namespace-3174"),
 * 			QueueName:          pulumi.String("sdk-Queues-5647"),
 * 			ResourceGroupName:  pulumi.String("ArunMonocle"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.servicebus.Queue;
 * import com.pulumi.azurenative.servicebus.QueueArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var queue = new Queue("queue", QueueArgs.builder()
 *             .enablePartitioning(true)
 *             .namespaceName("sdk-Namespace-3174")
 *             .queueName("sdk-Queues-5647")
 *             .resourceGroupName("ArunMonocle")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:servicebus:Queue sdk-Queues-5647 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/queues/{queueName}
 * ```
 * @property autoDeleteOnIdle ISO 8061 timeSpan idle interval after which the queue is automatically deleted. The minimum duration is 5 minutes.
 * @property deadLetteringOnMessageExpiration A value that indicates whether this queue has dead letter support when a message expires.
 * @property defaultMessageTimeToLive ISO 8601 default message timespan to live value. This is the duration after which the message expires, starting from when the message is sent to Service Bus. This is the default value used when TimeToLive is not set on a message itself.
 * @property duplicateDetectionHistoryTimeWindow ISO 8601 timeSpan structure that defines the duration of the duplicate detection history. The default value is 10 minutes.
 * @property enableBatchedOperations Value that indicates whether server-side batched operations are enabled.
 * @property enableExpress A value that indicates whether Express Entities are enabled. An express queue holds a message in memory temporarily before writing it to persistent storage.
 * @property enablePartitioning A value that indicates whether the queue is to be partitioned across multiple message brokers.
 * @property forwardDeadLetteredMessagesTo Queue/Topic name to forward the Dead Letter message
 * @property forwardTo Queue/Topic name to forward the messages
 * @property lockDuration ISO 8601 timespan duration of a peek-lock; that is, the amount of time that the message is locked for other receivers. The maximum value for LockDuration is 5 minutes; the default value is 1 minute.
 * @property maxDeliveryCount The maximum delivery count. A message is automatically deadlettered after this number of deliveries. default value is 10.
 * @property maxMessageSizeInKilobytes Maximum size (in KB) of the message payload that can be accepted by the queue. This property is only used in Premium today and default is 1024.
 * @property maxSizeInMegabytes The maximum size of the queue in megabytes, which is the size of memory allocated for the queue. Default is 1024.
 * @property namespaceName The namespace name
 * @property queueName The queue name.
 * @property requiresDuplicateDetection A value indicating if this queue requires duplicate detection.
 * @property requiresSession A value that indicates whether the queue supports the concept of sessions.
 * @property resourceGroupName Name of the Resource group within the Azure subscription.
 * @property status Enumerates the possible values for the status of a messaging entity.
 */
public data class QueueArgs(
    public val autoDeleteOnIdle: Output<String>? = null,
    public val deadLetteringOnMessageExpiration: Output<Boolean>? = null,
    public val defaultMessageTimeToLive: Output<String>? = null,
    public val duplicateDetectionHistoryTimeWindow: Output<String>? = null,
    public val enableBatchedOperations: Output<Boolean>? = null,
    public val enableExpress: Output<Boolean>? = null,
    public val enablePartitioning: Output<Boolean>? = null,
    public val forwardDeadLetteredMessagesTo: Output<String>? = null,
    public val forwardTo: Output<String>? = null,
    public val lockDuration: Output<String>? = null,
    public val maxDeliveryCount: Output<Int>? = null,
    public val maxMessageSizeInKilobytes: Output<Double>? = null,
    public val maxSizeInMegabytes: Output<Int>? = null,
    public val namespaceName: Output<String>? = null,
    public val queueName: Output<String>? = null,
    public val requiresDuplicateDetection: Output<Boolean>? = null,
    public val requiresSession: Output<Boolean>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val status: Output<EntityStatus>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.servicebus.QueueArgs> {
    override fun toJava(): com.pulumi.azurenative.servicebus.QueueArgs =
        com.pulumi.azurenative.servicebus.QueueArgs.builder()
            .autoDeleteOnIdle(autoDeleteOnIdle?.applyValue({ args0 -> args0 }))
            .deadLetteringOnMessageExpiration(deadLetteringOnMessageExpiration?.applyValue({ args0 -> args0 }))
            .defaultMessageTimeToLive(defaultMessageTimeToLive?.applyValue({ args0 -> args0 }))
            .duplicateDetectionHistoryTimeWindow(
                duplicateDetectionHistoryTimeWindow?.applyValue({ args0 ->
                    args0
                }),
            )
            .enableBatchedOperations(enableBatchedOperations?.applyValue({ args0 -> args0 }))
            .enableExpress(enableExpress?.applyValue({ args0 -> args0 }))
            .enablePartitioning(enablePartitioning?.applyValue({ args0 -> args0 }))
            .forwardDeadLetteredMessagesTo(forwardDeadLetteredMessagesTo?.applyValue({ args0 -> args0 }))
            .forwardTo(forwardTo?.applyValue({ args0 -> args0 }))
            .lockDuration(lockDuration?.applyValue({ args0 -> args0 }))
            .maxDeliveryCount(maxDeliveryCount?.applyValue({ args0 -> args0 }))
            .maxMessageSizeInKilobytes(maxMessageSizeInKilobytes?.applyValue({ args0 -> args0 }))
            .maxSizeInMegabytes(maxSizeInMegabytes?.applyValue({ args0 -> args0 }))
            .namespaceName(namespaceName?.applyValue({ args0 -> args0 }))
            .queueName(queueName?.applyValue({ args0 -> args0 }))
            .requiresDuplicateDetection(requiresDuplicateDetection?.applyValue({ args0 -> args0 }))
            .requiresSession(requiresSession?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [QueueArgs].
 */
@PulumiTagMarker
public class QueueArgsBuilder internal constructor() {
    private var autoDeleteOnIdle: Output<String>? = null

    private var deadLetteringOnMessageExpiration: Output<Boolean>? = null

    private var defaultMessageTimeToLive: Output<String>? = null

    private var duplicateDetectionHistoryTimeWindow: Output<String>? = null

    private var enableBatchedOperations: Output<Boolean>? = null

    private var enableExpress: Output<Boolean>? = null

    private var enablePartitioning: Output<Boolean>? = null

    private var forwardDeadLetteredMessagesTo: Output<String>? = null

    private var forwardTo: Output<String>? = null

    private var lockDuration: Output<String>? = null

    private var maxDeliveryCount: Output<Int>? = null

    private var maxMessageSizeInKilobytes: Output<Double>? = null

    private var maxSizeInMegabytes: Output<Int>? = null

    private var namespaceName: Output<String>? = null

    private var queueName: Output<String>? = null

    private var requiresDuplicateDetection: Output<Boolean>? = null

    private var requiresSession: Output<Boolean>? = null

    private var resourceGroupName: Output<String>? = null

    private var status: Output<EntityStatus>? = null

    /**
     * @param value ISO 8061 timeSpan idle interval after which the queue is automatically deleted. The minimum duration is 5 minutes.
     */
    @JvmName("lejtyrmwlhtaumrh")
    public suspend fun autoDeleteOnIdle(`value`: Output<String>) {
        this.autoDeleteOnIdle = value
    }

    /**
     * @param value A value that indicates whether this queue has dead letter support when a message expires.
     */
    @JvmName("vimksaanmvkyormv")
    public suspend fun deadLetteringOnMessageExpiration(`value`: Output<Boolean>) {
        this.deadLetteringOnMessageExpiration = value
    }

    /**
     * @param value ISO 8601 default message timespan to live value. This is the duration after which the message expires, starting from when the message is sent to Service Bus. This is the default value used when TimeToLive is not set on a message itself.
     */
    @JvmName("ixvxevexilonipjy")
    public suspend fun defaultMessageTimeToLive(`value`: Output<String>) {
        this.defaultMessageTimeToLive = value
    }

    /**
     * @param value ISO 8601 timeSpan structure that defines the duration of the duplicate detection history. The default value is 10 minutes.
     */
    @JvmName("hakqndbtchkpxecy")
    public suspend fun duplicateDetectionHistoryTimeWindow(`value`: Output<String>) {
        this.duplicateDetectionHistoryTimeWindow = value
    }

    /**
     * @param value Value that indicates whether server-side batched operations are enabled.
     */
    @JvmName("ugpnauwdxdnkusta")
    public suspend fun enableBatchedOperations(`value`: Output<Boolean>) {
        this.enableBatchedOperations = value
    }

    /**
     * @param value A value that indicates whether Express Entities are enabled. An express queue holds a message in memory temporarily before writing it to persistent storage.
     */
    @JvmName("uohusmgorheuwfbf")
    public suspend fun enableExpress(`value`: Output<Boolean>) {
        this.enableExpress = value
    }

    /**
     * @param value A value that indicates whether the queue is to be partitioned across multiple message brokers.
     */
    @JvmName("lcpjhhjypwmsfcwq")
    public suspend fun enablePartitioning(`value`: Output<Boolean>) {
        this.enablePartitioning = value
    }

    /**
     * @param value Queue/Topic name to forward the Dead Letter message
     */
    @JvmName("oreuwmxyfcpqemhv")
    public suspend fun forwardDeadLetteredMessagesTo(`value`: Output<String>) {
        this.forwardDeadLetteredMessagesTo = value
    }

    /**
     * @param value Queue/Topic name to forward the messages
     */
    @JvmName("jophobscpssdqcmk")
    public suspend fun forwardTo(`value`: Output<String>) {
        this.forwardTo = value
    }

    /**
     * @param value ISO 8601 timespan duration of a peek-lock; that is, the amount of time that the message is locked for other receivers. The maximum value for LockDuration is 5 minutes; the default value is 1 minute.
     */
    @JvmName("begiqttftjulhdac")
    public suspend fun lockDuration(`value`: Output<String>) {
        this.lockDuration = value
    }

    /**
     * @param value The maximum delivery count. A message is automatically deadlettered after this number of deliveries. default value is 10.
     */
    @JvmName("fgklokuewrhygjqg")
    public suspend fun maxDeliveryCount(`value`: Output<Int>) {
        this.maxDeliveryCount = value
    }

    /**
     * @param value Maximum size (in KB) of the message payload that can be accepted by the queue. This property is only used in Premium today and default is 1024.
     */
    @JvmName("twcpwtishpybkrld")
    public suspend fun maxMessageSizeInKilobytes(`value`: Output<Double>) {
        this.maxMessageSizeInKilobytes = value
    }

    /**
     * @param value The maximum size of the queue in megabytes, which is the size of memory allocated for the queue. Default is 1024.
     */
    @JvmName("otehtqdvrkindcah")
    public suspend fun maxSizeInMegabytes(`value`: Output<Int>) {
        this.maxSizeInMegabytes = value
    }

    /**
     * @param value The namespace name
     */
    @JvmName("olyiruwmwrlwgyjb")
    public suspend fun namespaceName(`value`: Output<String>) {
        this.namespaceName = value
    }

    /**
     * @param value The queue name.
     */
    @JvmName("lwwyekctqfkudtjb")
    public suspend fun queueName(`value`: Output<String>) {
        this.queueName = value
    }

    /**
     * @param value A value indicating if this queue requires duplicate detection.
     */
    @JvmName("qgjocheqmavjilll")
    public suspend fun requiresDuplicateDetection(`value`: Output<Boolean>) {
        this.requiresDuplicateDetection = value
    }

    /**
     * @param value A value that indicates whether the queue supports the concept of sessions.
     */
    @JvmName("gkgpbcbkhyctctcp")
    public suspend fun requiresSession(`value`: Output<Boolean>) {
        this.requiresSession = value
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("npryensyeqrtgvme")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Enumerates the possible values for the status of a messaging entity.
     */
    @JvmName("grrbgwgikvdjjgys")
    public suspend fun status(`value`: Output<EntityStatus>) {
        this.status = value
    }

    /**
     * @param value ISO 8061 timeSpan idle interval after which the queue is automatically deleted. The minimum duration is 5 minutes.
     */
    @JvmName("qrhwyejlhjjtgfqv")
    public suspend fun autoDeleteOnIdle(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoDeleteOnIdle = mapped
    }

    /**
     * @param value A value that indicates whether this queue has dead letter support when a message expires.
     */
    @JvmName("clpbxgruooypfstl")
    public suspend fun deadLetteringOnMessageExpiration(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deadLetteringOnMessageExpiration = mapped
    }

    /**
     * @param value ISO 8601 default message timespan to live value. This is the duration after which the message expires, starting from when the message is sent to Service Bus. This is the default value used when TimeToLive is not set on a message itself.
     */
    @JvmName("tqggjlyamrylruwk")
    public suspend fun defaultMessageTimeToLive(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultMessageTimeToLive = mapped
    }

    /**
     * @param value ISO 8601 timeSpan structure that defines the duration of the duplicate detection history. The default value is 10 minutes.
     */
    @JvmName("dmpkwqjcdnkjmjyg")
    public suspend fun duplicateDetectionHistoryTimeWindow(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.duplicateDetectionHistoryTimeWindow = mapped
    }

    /**
     * @param value Value that indicates whether server-side batched operations are enabled.
     */
    @JvmName("kovpmixptbpuymey")
    public suspend fun enableBatchedOperations(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableBatchedOperations = mapped
    }

    /**
     * @param value A value that indicates whether Express Entities are enabled. An express queue holds a message in memory temporarily before writing it to persistent storage.
     */
    @JvmName("mfkjyxnfyoomtlpg")
    public suspend fun enableExpress(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableExpress = mapped
    }

    /**
     * @param value A value that indicates whether the queue is to be partitioned across multiple message brokers.
     */
    @JvmName("gdqnmgihbohcnevx")
    public suspend fun enablePartitioning(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enablePartitioning = mapped
    }

    /**
     * @param value Queue/Topic name to forward the Dead Letter message
     */
    @JvmName("iwcuktknqrcxahdn")
    public suspend fun forwardDeadLetteredMessagesTo(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forwardDeadLetteredMessagesTo = mapped
    }

    /**
     * @param value Queue/Topic name to forward the messages
     */
    @JvmName("enriyxyadhcgvtfc")
    public suspend fun forwardTo(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forwardTo = mapped
    }

    /**
     * @param value ISO 8601 timespan duration of a peek-lock; that is, the amount of time that the message is locked for other receivers. The maximum value for LockDuration is 5 minutes; the default value is 1 minute.
     */
    @JvmName("vkeorsxqqrnxtsrj")
    public suspend fun lockDuration(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lockDuration = mapped
    }

    /**
     * @param value The maximum delivery count. A message is automatically deadlettered after this number of deliveries. default value is 10.
     */
    @JvmName("wrtrjxfoplccjsrh")
    public suspend fun maxDeliveryCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxDeliveryCount = mapped
    }

    /**
     * @param value Maximum size (in KB) of the message payload that can be accepted by the queue. This property is only used in Premium today and default is 1024.
     */
    @JvmName("pypwadqwhnabypvt")
    public suspend fun maxMessageSizeInKilobytes(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxMessageSizeInKilobytes = mapped
    }

    /**
     * @param value The maximum size of the queue in megabytes, which is the size of memory allocated for the queue. Default is 1024.
     */
    @JvmName("phihgebqjdlkabbq")
    public suspend fun maxSizeInMegabytes(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxSizeInMegabytes = mapped
    }

    /**
     * @param value The namespace name
     */
    @JvmName("ennihicrcatfspts")
    public suspend fun namespaceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespaceName = mapped
    }

    /**
     * @param value The queue name.
     */
    @JvmName("vdtitogprxftmqro")
    public suspend fun queueName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queueName = mapped
    }

    /**
     * @param value A value indicating if this queue requires duplicate detection.
     */
    @JvmName("mghdnnxvfjhfudih")
    public suspend fun requiresDuplicateDetection(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requiresDuplicateDetection = mapped
    }

    /**
     * @param value A value that indicates whether the queue supports the concept of sessions.
     */
    @JvmName("axbcvgpkxkhxyiej")
    public suspend fun requiresSession(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requiresSession = mapped
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("jslmcqtwoeqvfxjm")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Enumerates the possible values for the status of a messaging entity.
     */
    @JvmName("qdlhmihenucvmaor")
    public suspend fun status(`value`: EntityStatus?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    internal fun build(): QueueArgs = QueueArgs(
        autoDeleteOnIdle = autoDeleteOnIdle,
        deadLetteringOnMessageExpiration = deadLetteringOnMessageExpiration,
        defaultMessageTimeToLive = defaultMessageTimeToLive,
        duplicateDetectionHistoryTimeWindow = duplicateDetectionHistoryTimeWindow,
        enableBatchedOperations = enableBatchedOperations,
        enableExpress = enableExpress,
        enablePartitioning = enablePartitioning,
        forwardDeadLetteredMessagesTo = forwardDeadLetteredMessagesTo,
        forwardTo = forwardTo,
        lockDuration = lockDuration,
        maxDeliveryCount = maxDeliveryCount,
        maxMessageSizeInKilobytes = maxMessageSizeInKilobytes,
        maxSizeInMegabytes = maxSizeInMegabytes,
        namespaceName = namespaceName,
        queueName = queueName,
        requiresDuplicateDetection = requiresDuplicateDetection,
        requiresSession = requiresSession,
        resourceGroupName = resourceGroupName,
        status = status,
    )
}
