@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicebus.kotlin

import com.pulumi.azurenative.servicebus.kotlin.outputs.ActionResponse
import com.pulumi.azurenative.servicebus.kotlin.outputs.CorrelationFilterResponse
import com.pulumi.azurenative.servicebus.kotlin.outputs.SqlFilterResponse
import com.pulumi.azurenative.servicebus.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.servicebus.kotlin.outputs.ActionResponse.Companion.toKotlin as actionResponseToKotlin
import com.pulumi.azurenative.servicebus.kotlin.outputs.CorrelationFilterResponse.Companion.toKotlin as correlationFilterResponseToKotlin
import com.pulumi.azurenative.servicebus.kotlin.outputs.SqlFilterResponse.Companion.toKotlin as sqlFilterResponseToKotlin
import com.pulumi.azurenative.servicebus.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Rule].
 */
@PulumiTagMarker
public class RuleResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RuleArgs = RuleArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RuleArgsBuilder.() -> Unit) {
        val builder = RuleArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Rule {
        val builtJavaResource = com.pulumi.azurenative.servicebus.Rule(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Rule(builtJavaResource)
    }
}

/**
 * Description of Rule Resource.
 * Azure REST API version: 2022-01-01-preview. Prior API version in Azure Native 1.x: 2017-04-01.
 * Other available API versions: 2022-10-01-preview.
 * ## Example Usage
 * ### RulesCreateCorrelationFilter
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var rule = new AzureNative.ServiceBus.Rule("rule", new()
 *     {
 *         CorrelationFilter = new AzureNative.ServiceBus.Inputs.CorrelationFilterArgs
 *         {
 *             Properties =
 *             {
 *                 { "topicHint", "Crop" },
 *             },
 *         },
 *         FilterType = AzureNative.ServiceBus.FilterType.CorrelationFilter,
 *         NamespaceName = "sdk-Namespace-1319",
 *         ResourceGroupName = "resourceGroupName",
 *         RuleName = "sdk-Rules-6571",
 *         SubscriptionName = "sdk-Subscriptions-8691",
 *         TopicName = "sdk-Topics-2081",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/servicebus/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := servicebus.NewRule(ctx, "rule", &servicebus.RuleArgs{
 * 			CorrelationFilter: &servicebus.CorrelationFilterArgs{
 * 				Properties: pulumi.StringMap{
 * 					"topicHint": pulumi.String("Crop"),
 * 				},
 * 			},
 * 			FilterType:        pulumi.String(servicebus.FilterTypeCorrelationFilter),
 * 			NamespaceName:     pulumi.String("sdk-Namespace-1319"),
 * 			ResourceGroupName: pulumi.String("resourceGroupName"),
 * 			RuleName:          pulumi.String("sdk-Rules-6571"),
 * 			SubscriptionName:  pulumi.String("sdk-Subscriptions-8691"),
 * 			TopicName:         pulumi.String("sdk-Topics-2081"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.servicebus.Rule;
 * import com.pulumi.azurenative.servicebus.RuleArgs;
 * import com.pulumi.azurenative.servicebus.inputs.CorrelationFilterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var rule = new Rule("rule", RuleArgs.builder()
 *             .correlationFilter(CorrelationFilterArgs.builder()
 *                 .properties(Map.of("topicHint", "Crop"))
 *                 .build())
 *             .filterType("CorrelationFilter")
 *             .namespaceName("sdk-Namespace-1319")
 *             .resourceGroupName("resourceGroupName")
 *             .ruleName("sdk-Rules-6571")
 *             .subscriptionName("sdk-Subscriptions-8691")
 *             .topicName("sdk-Topics-2081")
 *             .build());
 *     }
 * }
 * ```
 * ### RulesCreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var rule = new AzureNative.ServiceBus.Rule("rule", new()
 *     {
 *         NamespaceName = "sdk-Namespace-1319",
 *         ResourceGroupName = "resourceGroupName",
 *         RuleName = "sdk-Rules-6571",
 *         SubscriptionName = "sdk-Subscriptions-8691",
 *         TopicName = "sdk-Topics-2081",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/servicebus/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := servicebus.NewRule(ctx, "rule", &servicebus.RuleArgs{
 * 			NamespaceName:     pulumi.String("sdk-Namespace-1319"),
 * 			ResourceGroupName: pulumi.String("resourceGroupName"),
 * 			RuleName:          pulumi.String("sdk-Rules-6571"),
 * 			SubscriptionName:  pulumi.String("sdk-Subscriptions-8691"),
 * 			TopicName:         pulumi.String("sdk-Topics-2081"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.servicebus.Rule;
 * import com.pulumi.azurenative.servicebus.RuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var rule = new Rule("rule", RuleArgs.builder()
 *             .namespaceName("sdk-Namespace-1319")
 *             .resourceGroupName("resourceGroupName")
 *             .ruleName("sdk-Rules-6571")
 *             .subscriptionName("sdk-Subscriptions-8691")
 *             .topicName("sdk-Topics-2081")
 *             .build());
 *     }
 * }
 * ```
 * ### RulesCreateSqlFilter
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var rule = new AzureNative.ServiceBus.Rule("rule", new()
 *     {
 *         FilterType = AzureNative.ServiceBus.FilterType.SqlFilter,
 *         NamespaceName = "sdk-Namespace-1319",
 *         ResourceGroupName = "resourceGroupName",
 *         RuleName = "sdk-Rules-6571",
 *         SqlFilter = new AzureNative.ServiceBus.Inputs.SqlFilterArgs
 *         {
 *             SqlExpression = "myproperty=test",
 *         },
 *         SubscriptionName = "sdk-Subscriptions-8691",
 *         TopicName = "sdk-Topics-2081",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/servicebus/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := servicebus.NewRule(ctx, "rule", &servicebus.RuleArgs{
 * 			FilterType:        pulumi.String(servicebus.FilterTypeSqlFilter),
 * 			NamespaceName:     pulumi.String("sdk-Namespace-1319"),
 * 			ResourceGroupName: pulumi.String("resourceGroupName"),
 * 			RuleName:          pulumi.String("sdk-Rules-6571"),
 * 			SqlFilter: &servicebus.SqlFilterArgs{
 * 				SqlExpression: pulumi.String("myproperty=test"),
 * 			},
 * 			SubscriptionName: pulumi.String("sdk-Subscriptions-8691"),
 * 			TopicName:        pulumi.String("sdk-Topics-2081"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.servicebus.Rule;
 * import com.pulumi.azurenative.servicebus.RuleArgs;
 * import com.pulumi.azurenative.servicebus.inputs.SqlFilterArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var rule = new Rule("rule", RuleArgs.builder()
 *             .filterType("SqlFilter")
 *             .namespaceName("sdk-Namespace-1319")
 *             .resourceGroupName("resourceGroupName")
 *             .ruleName("sdk-Rules-6571")
 *             .sqlFilter(SqlFilterArgs.builder()
 *                 .sqlExpression("myproperty=test")
 *                 .build())
 *             .subscriptionName("sdk-Subscriptions-8691")
 *             .topicName("sdk-Topics-2081")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:servicebus:Rule sdk-Rules-6571 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceBus/namespaces/{namespaceName}/topics/{topicName}/subscriptions/{subscriptionName}/rules/{ruleName}
 * ```
 */
public class Rule internal constructor(
    override val javaResource: com.pulumi.azurenative.servicebus.Rule,
) : KotlinCustomResource(javaResource, RuleMapper) {
    /**
     * Represents the filter actions which are allowed for the transformation of a message that have been matched by a filter expression.
     */
    public val action: Output<ActionResponse>?
        get() = javaResource.action().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    actionResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Properties of correlationFilter
     */
    public val correlationFilter: Output<CorrelationFilterResponse>?
        get() = javaResource.correlationFilter().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> correlationFilterResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Filter type that is evaluated against a BrokeredMessage.
     */
    public val filterType: Output<String>?
        get() = javaResource.filterType().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Properties of sqlFilter
     */
    public val sqlFilter: Output<SqlFilterResponse>?
        get() = javaResource.sqlFilter().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    sqlFilterResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The system meta data relating to this resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.EventHub/Namespaces" or "Microsoft.EventHub/Namespaces/EventHubs"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object RuleMapper : ResourceMapper<Rule> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.servicebus.Rule::class == javaResource::class

    override fun map(javaResource: Resource): Rule = Rule(
        javaResource as
            com.pulumi.azurenative.servicebus.Rule,
    )
}

/**
 * @see [Rule].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Rule].
 */
public suspend fun rule(name: String, block: suspend RuleResourceBuilder.() -> Unit): Rule {
    val builder = RuleResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Rule].
 * @param name The _unique_ name of the resulting resource.
 */
public fun rule(name: String): Rule {
    val builder = RuleResourceBuilder()
    builder.name(name)
    return builder.build()
}
