@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicebus.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Enumerates the possible values for the status of a messaging entity.
 */
public enum class EntityStatus(
    public val javaValue: com.pulumi.azurenative.servicebus.enums.EntityStatus,
) : ConvertibleToJava<com.pulumi.azurenative.servicebus.enums.EntityStatus> {
    Active(com.pulumi.azurenative.servicebus.enums.EntityStatus.Active),
    Disabled(com.pulumi.azurenative.servicebus.enums.EntityStatus.Disabled),
    Restoring(com.pulumi.azurenative.servicebus.enums.EntityStatus.Restoring),
    SendDisabled(com.pulumi.azurenative.servicebus.enums.EntityStatus.SendDisabled),
    ReceiveDisabled(com.pulumi.azurenative.servicebus.enums.EntityStatus.ReceiveDisabled),
    Creating(com.pulumi.azurenative.servicebus.enums.EntityStatus.Creating),
    Deleting(com.pulumi.azurenative.servicebus.enums.EntityStatus.Deleting),
    Renaming(com.pulumi.azurenative.servicebus.enums.EntityStatus.Renaming),
    Unknown(com.pulumi.azurenative.servicebus.enums.EntityStatus.Unknown),
    ;

    override fun toJava(): com.pulumi.azurenative.servicebus.enums.EntityStatus = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.servicebus.enums.EntityStatus):
            EntityStatus = EntityStatus.values().first { it.javaValue == javaType }
    }
}
