@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicebus.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * This determines if traffic is allowed over public network. By default it is enabled.
 */
public enum class PublicNetworkAccess(
    public val javaValue: com.pulumi.azurenative.servicebus.enums.PublicNetworkAccess,
) : ConvertibleToJava<com.pulumi.azurenative.servicebus.enums.PublicNetworkAccess> {
    Enabled(com.pulumi.azurenative.servicebus.enums.PublicNetworkAccess.Enabled),
    Disabled(com.pulumi.azurenative.servicebus.enums.PublicNetworkAccess.Disabled),
    SecuredByPerimeter(com.pulumi.azurenative.servicebus.enums.PublicNetworkAccess.SecuredByPerimeter),
    ;

    override fun toJava(): com.pulumi.azurenative.servicebus.enums.PublicNetworkAccess = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.servicebus.enums.PublicNetworkAccess):
            PublicNetworkAccess = PublicNetworkAccess.values().first { it.javaValue == javaType }
    }
}
