@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicebus.kotlin.inputs

import com.pulumi.azurenative.servicebus.inputs.CorrelationFilterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Represents the correlation filter expression.
 * @property contentType Content type of the message.
 * @property correlationId Identifier of the correlation.
 * @property label Application specific label.
 * @property messageId Identifier of the message.
 * @property properties dictionary object for custom filters
 * @property replyTo Address of the queue to reply to.
 * @property replyToSessionId Session identifier to reply to.
 * @property requiresPreprocessing Value that indicates whether the rule action requires preprocessing.
 * @property sessionId Session identifier.
 * @property to Address to send to.
 */
public data class CorrelationFilterArgs(
    public val contentType: Output<String>? = null,
    public val correlationId: Output<String>? = null,
    public val label: Output<String>? = null,
    public val messageId: Output<String>? = null,
    public val properties: Output<Map<String, String>>? = null,
    public val replyTo: Output<String>? = null,
    public val replyToSessionId: Output<String>? = null,
    public val requiresPreprocessing: Output<Boolean>? = null,
    public val sessionId: Output<String>? = null,
    public val to: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.servicebus.inputs.CorrelationFilterArgs> {
    override fun toJava(): com.pulumi.azurenative.servicebus.inputs.CorrelationFilterArgs =
        com.pulumi.azurenative.servicebus.inputs.CorrelationFilterArgs.builder()
            .contentType(contentType?.applyValue({ args0 -> args0 }))
            .correlationId(correlationId?.applyValue({ args0 -> args0 }))
            .label(label?.applyValue({ args0 -> args0 }))
            .messageId(messageId?.applyValue({ args0 -> args0 }))
            .properties(
                properties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .replyTo(replyTo?.applyValue({ args0 -> args0 }))
            .replyToSessionId(replyToSessionId?.applyValue({ args0 -> args0 }))
            .requiresPreprocessing(requiresPreprocessing?.applyValue({ args0 -> args0 }))
            .sessionId(sessionId?.applyValue({ args0 -> args0 }))
            .to(to?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CorrelationFilterArgs].
 */
@PulumiTagMarker
public class CorrelationFilterArgsBuilder internal constructor() {
    private var contentType: Output<String>? = null

    private var correlationId: Output<String>? = null

    private var label: Output<String>? = null

    private var messageId: Output<String>? = null

    private var properties: Output<Map<String, String>>? = null

    private var replyTo: Output<String>? = null

    private var replyToSessionId: Output<String>? = null

    private var requiresPreprocessing: Output<Boolean>? = null

    private var sessionId: Output<String>? = null

    private var to: Output<String>? = null

    /**
     * @param value Content type of the message.
     */
    @JvmName("iuautogqgmqltmar")
    public suspend fun contentType(`value`: Output<String>) {
        this.contentType = value
    }

    /**
     * @param value Identifier of the correlation.
     */
    @JvmName("ckbjeripondvumxi")
    public suspend fun correlationId(`value`: Output<String>) {
        this.correlationId = value
    }

    /**
     * @param value Application specific label.
     */
    @JvmName("tbdrnytpaxypkxjq")
    public suspend fun label(`value`: Output<String>) {
        this.label = value
    }

    /**
     * @param value Identifier of the message.
     */
    @JvmName("hquliwmxtlgwsgjx")
    public suspend fun messageId(`value`: Output<String>) {
        this.messageId = value
    }

    /**
     * @param value dictionary object for custom filters
     */
    @JvmName("wycstdpqgcwgwhix")
    public suspend fun properties(`value`: Output<Map<String, String>>) {
        this.properties = value
    }

    /**
     * @param value Address of the queue to reply to.
     */
    @JvmName("bsgqgcdxqlhaowfm")
    public suspend fun replyTo(`value`: Output<String>) {
        this.replyTo = value
    }

    /**
     * @param value Session identifier to reply to.
     */
    @JvmName("gltyannwiuhkjkca")
    public suspend fun replyToSessionId(`value`: Output<String>) {
        this.replyToSessionId = value
    }

    /**
     * @param value Value that indicates whether the rule action requires preprocessing.
     */
    @JvmName("cryyqscauhiaqebk")
    public suspend fun requiresPreprocessing(`value`: Output<Boolean>) {
        this.requiresPreprocessing = value
    }

    /**
     * @param value Session identifier.
     */
    @JvmName("kypebkavgdqehgfx")
    public suspend fun sessionId(`value`: Output<String>) {
        this.sessionId = value
    }

    /**
     * @param value Address to send to.
     */
    @JvmName("edeseaptpfhgftxs")
    public suspend fun to(`value`: Output<String>) {
        this.to = value
    }

    /**
     * @param value Content type of the message.
     */
    @JvmName("rsuqmyxphlgalfwa")
    public suspend fun contentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contentType = mapped
    }

    /**
     * @param value Identifier of the correlation.
     */
    @JvmName("rkgbhoejasuvxpus")
    public suspend fun correlationId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.correlationId = mapped
    }

    /**
     * @param value Application specific label.
     */
    @JvmName("ejownhvxkutxknlf")
    public suspend fun label(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.label = mapped
    }

    /**
     * @param value Identifier of the message.
     */
    @JvmName("sayvdowjckhajxfv")
    public suspend fun messageId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.messageId = mapped
    }

    /**
     * @param value dictionary object for custom filters
     */
    @JvmName("mujipxppbpuvivfi")
    public suspend fun properties(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param values dictionary object for custom filters
     */
    @JvmName("rcpsedfrkfyitmsq")
    public fun properties(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value Address of the queue to reply to.
     */
    @JvmName("kfqsubpartoktasy")
    public suspend fun replyTo(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replyTo = mapped
    }

    /**
     * @param value Session identifier to reply to.
     */
    @JvmName("gicybpbbqyulirqi")
    public suspend fun replyToSessionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replyToSessionId = mapped
    }

    /**
     * @param value Value that indicates whether the rule action requires preprocessing.
     */
    @JvmName("sodxbkqvoytldkqs")
    public suspend fun requiresPreprocessing(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requiresPreprocessing = mapped
    }

    /**
     * @param value Session identifier.
     */
    @JvmName("xcuvvnpudgbqkfqn")
    public suspend fun sessionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sessionId = mapped
    }

    /**
     * @param value Address to send to.
     */
    @JvmName("mjptuxuvcwvrhhxv")
    public suspend fun to(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.to = mapped
    }

    internal fun build(): CorrelationFilterArgs = CorrelationFilterArgs(
        contentType = contentType,
        correlationId = correlationId,
        label = label,
        messageId = messageId,
        properties = properties,
        replyTo = replyTo,
        replyToSessionId = replyToSessionId,
        requiresPreprocessing = requiresPreprocessing,
        sessionId = sessionId,
        to = to,
    )
}
