@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicebus.kotlin.inputs

import com.pulumi.azurenative.servicebus.inputs.GetMigrationConfigPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property configName The configuration name. Should always be "$default".
 * @property namespaceName The namespace name
 * @property resourceGroupName Name of the Resource group within the Azure subscription.
 */
public data class GetMigrationConfigPlainArgs(
    public val configName: String,
    public val namespaceName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.servicebus.inputs.GetMigrationConfigPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.servicebus.inputs.GetMigrationConfigPlainArgs =
        com.pulumi.azurenative.servicebus.inputs.GetMigrationConfigPlainArgs.builder()
            .configName(configName.let({ args0 -> args0 }))
            .namespaceName(namespaceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetMigrationConfigPlainArgs].
 */
@PulumiTagMarker
public class GetMigrationConfigPlainArgsBuilder internal constructor() {
    private var configName: String? = null

    private var namespaceName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The configuration name. Should always be "$default".
     */
    @JvmName("qtdjwbltxfnruhvf")
    public suspend fun configName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.configName = mapped
    }

    /**
     * @param value The namespace name
     */
    @JvmName("phrbaxxrxsyouegj")
    public suspend fun namespaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.namespaceName = mapped
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("targspahshswatev")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetMigrationConfigPlainArgs = GetMigrationConfigPlainArgs(
        configName = configName ?: throw PulumiNullFieldException("configName"),
        namespaceName = namespaceName ?: throw PulumiNullFieldException("namespaceName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
