@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicebus.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Single item in a List or Get IpFilterRules operation
 * @property action The IP Filter Action
 * @property filterName IP Filter name
 * @property id Resource Id
 * @property ipMask IP Mask
 * @property name Resource name
 * @property type Resource type
 */
public data class GetNamespaceIpFilterRuleResult(
    public val action: String? = null,
    public val filterName: String? = null,
    public val id: String,
    public val ipMask: String? = null,
    public val name: String,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.servicebus.outputs.GetNamespaceIpFilterRuleResult):
            GetNamespaceIpFilterRuleResult = GetNamespaceIpFilterRuleResult(
            action = javaType.action().map({ args0 -> args0 }).orElse(null),
            filterName = javaType.filterName().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ipMask = javaType.ipMask().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            type = javaType.type(),
        )
    }
}
