@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicebus.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Description of subscription resource.
 * @property accessedAt Last time there was a receive request to this subscription.
 * @property autoDeleteOnIdle ISO 8061 timeSpan idle interval after which the topic is automatically deleted. The minimum duration is 5 minutes.
 * @property clientAffineProperties Properties specific to client affine subscriptions.
 * @property countDetails Message count details
 * @property createdAt Exact time the message was created.
 * @property deadLetteringOnFilterEvaluationExceptions Value that indicates whether a subscription has dead letter support on filter evaluation exceptions.
 * @property deadLetteringOnMessageExpiration Value that indicates whether a subscription has dead letter support when a message expires.
 * @property defaultMessageTimeToLive ISO 8061 Default message timespan to live value. This is the duration after which the message expires, starting from when the message is sent to Service Bus. This is the default value used when TimeToLive is not set on a message itself.
 * @property duplicateDetectionHistoryTimeWindow ISO 8601 timeSpan structure that defines the duration of the duplicate detection history. The default value is 10 minutes.
 * @property enableBatchedOperations Value that indicates whether server-side batched operations are enabled.
 * @property forwardDeadLetteredMessagesTo Queue/Topic name to forward the Dead Letter message
 * @property forwardTo Queue/Topic name to forward the messages
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property isClientAffine Value that indicates whether the subscription has an affinity to the client id.
 * @property location The geo-location where the resource lives
 * @property lockDuration ISO 8061 lock duration timespan for the subscription. The default value is 1 minute.
 * @property maxDeliveryCount Number of maximum deliveries.
 * @property messageCount Number of messages.
 * @property name The name of the resource
 * @property requiresSession Value indicating if a subscription supports the concept of sessions.
 * @property status Enumerates the possible values for the status of a messaging entity.
 * @property systemData The system meta data relating to this resource.
 * @property type The type of the resource. E.g. "Microsoft.EventHub/Namespaces" or "Microsoft.EventHub/Namespaces/EventHubs"
 * @property updatedAt The exact time the message was updated.
 */
public data class GetSubscriptionResult(
    public val accessedAt: String,
    public val autoDeleteOnIdle: String? = null,
    public val clientAffineProperties: SBClientAffinePropertiesResponse? = null,
    public val countDetails: MessageCountDetailsResponse,
    public val createdAt: String,
    public val deadLetteringOnFilterEvaluationExceptions: Boolean? = null,
    public val deadLetteringOnMessageExpiration: Boolean? = null,
    public val defaultMessageTimeToLive: String? = null,
    public val duplicateDetectionHistoryTimeWindow: String? = null,
    public val enableBatchedOperations: Boolean? = null,
    public val forwardDeadLetteredMessagesTo: String? = null,
    public val forwardTo: String? = null,
    public val id: String,
    public val isClientAffine: Boolean? = null,
    public val location: String,
    public val lockDuration: String? = null,
    public val maxDeliveryCount: Int? = null,
    public val messageCount: Double,
    public val name: String,
    public val requiresSession: Boolean? = null,
    public val status: String? = null,
    public val systemData: SystemDataResponse,
    public val type: String,
    public val updatedAt: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.servicebus.outputs.GetSubscriptionResult):
            GetSubscriptionResult = GetSubscriptionResult(
            accessedAt = javaType.accessedAt(),
            autoDeleteOnIdle = javaType.autoDeleteOnIdle().map({ args0 -> args0 }).orElse(null),
            clientAffineProperties = javaType.clientAffineProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.servicebus.kotlin.outputs.SBClientAffinePropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            countDetails = javaType.countDetails().let({ args0 ->
                com.pulumi.azurenative.servicebus.kotlin.outputs.MessageCountDetailsResponse.Companion.toKotlin(args0)
            }),
            createdAt = javaType.createdAt(),
            deadLetteringOnFilterEvaluationExceptions = javaType.deadLetteringOnFilterEvaluationExceptions().map({ args0 ->
                args0
            }).orElse(null),
            deadLetteringOnMessageExpiration = javaType.deadLetteringOnMessageExpiration().map({ args0 ->
                args0
            }).orElse(null),
            defaultMessageTimeToLive = javaType.defaultMessageTimeToLive().map({ args0 -> args0 }).orElse(null),
            duplicateDetectionHistoryTimeWindow = javaType.duplicateDetectionHistoryTimeWindow().map({ args0 ->
                args0
            }).orElse(null),
            enableBatchedOperations = javaType.enableBatchedOperations().map({ args0 -> args0 }).orElse(null),
            forwardDeadLetteredMessagesTo = javaType.forwardDeadLetteredMessagesTo().map({ args0 ->
                args0
            }).orElse(null),
            forwardTo = javaType.forwardTo().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            isClientAffine = javaType.isClientAffine().map({ args0 -> args0 }).orElse(null),
            location = javaType.location(),
            lockDuration = javaType.lockDuration().map({ args0 -> args0 }).orElse(null),
            maxDeliveryCount = javaType.maxDeliveryCount().map({ args0 -> args0 }).orElse(null),
            messageCount = javaType.messageCount(),
            name = javaType.name(),
            requiresSession = javaType.requiresSession().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.servicebus.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
            updatedAt = javaType.updatedAt(),
        )
    }
}
