@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicebus.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 * Description of VirtualNetworkRules - NetworkRules resource.
 * @property ignoreMissingVnetServiceEndpoint Value that indicates whether to ignore missing VNet Service Endpoint
 * @property subnet Subnet properties
 */
public data class NWRuleSetVirtualNetworkRulesResponse(
    public val ignoreMissingVnetServiceEndpoint: Boolean? = null,
    public val subnet: SubnetResponse? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.servicebus.outputs.NWRuleSetVirtualNetworkRulesResponse):
            NWRuleSetVirtualNetworkRulesResponse = NWRuleSetVirtualNetworkRulesResponse(
            ignoreMissingVnetServiceEndpoint = javaType.ignoreMissingVnetServiceEndpoint().map({ args0 ->
                args0
            }).orElse(null),
            subnet = javaType.subnet().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.servicebus.kotlin.outputs.SubnetResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
