@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin

import com.pulumi.azurenative.servicefabric.kotlin.outputs.ApplicationUpgradePolicyResponse
import com.pulumi.azurenative.servicefabric.kotlin.outputs.ApplicationUserAssignedIdentityResponse
import com.pulumi.azurenative.servicefabric.kotlin.outputs.ManagedIdentityResponse
import com.pulumi.azurenative.servicefabric.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.servicefabric.kotlin.outputs.ApplicationUpgradePolicyResponse.Companion.toKotlin as applicationUpgradePolicyResponseToKotlin
import com.pulumi.azurenative.servicefabric.kotlin.outputs.ApplicationUserAssignedIdentityResponse.Companion.toKotlin as applicationUserAssignedIdentityResponseToKotlin
import com.pulumi.azurenative.servicefabric.kotlin.outputs.ManagedIdentityResponse.Companion.toKotlin as managedIdentityResponseToKotlin
import com.pulumi.azurenative.servicefabric.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [ManagedClusterApplication].
 */
@PulumiTagMarker
public class ManagedClusterApplicationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ManagedClusterApplicationArgs = ManagedClusterApplicationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ManagedClusterApplicationArgsBuilder.() -> Unit) {
        val builder = ManagedClusterApplicationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ManagedClusterApplication {
        val builtJavaResource =
            com.pulumi.azurenative.servicefabric.ManagedClusterApplication(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ManagedClusterApplication(builtJavaResource)
    }
}

/**
 * The application resource.
 * Azure REST API version: 2023-03-01-preview.
 * Other available API versions: 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview, 2023-12-01-preview, 2024-02-01-preview.
 * ## Example Usage
 * ### Put an application with maximum parameters
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedClusterApplication = new AzureNative.ServiceFabric.ManagedClusterApplication("managedClusterApplication", new()
 *     {
 *         ApplicationName = "myApp",
 *         ClusterName = "myCluster",
 *         Location = "eastus",
 *         Parameters =
 *         {
 *             { "param1", "value1" },
 *         },
 *         ResourceGroupName = "resRg",
 *         Tags =
 *         {
 *             { "a", "b" },
 *         },
 *         UpgradePolicy = new AzureNative.ServiceFabric.Inputs.ApplicationUpgradePolicyArgs
 *         {
 *             ApplicationHealthPolicy = new AzureNative.ServiceFabric.Inputs.ApplicationHealthPolicyArgs
 *             {
 *                 ConsiderWarningAsError = true,
 *                 DefaultServiceTypeHealthPolicy = new AzureNative.ServiceFabric.Inputs.ServiceTypeHealthPolicyArgs
 *                 {
 *                     MaxPercentUnhealthyPartitionsPerService = 0,
 *                     MaxPercentUnhealthyReplicasPerPartition = 0,
 *                     MaxPercentUnhealthyServices = 0,
 *                 },
 *                 MaxPercentUnhealthyDeployedApplications = 0,
 *                 ServiceTypeHealthPolicyMap =
 *                 {
 *                     { "myService", new AzureNative.ServiceFabric.Inputs.ServiceTypeHealthPolicyArgs
 *                     {
 *                         MaxPercentUnhealthyPartitionsPerService = 30,
 *                         MaxPercentUnhealthyReplicasPerPartition = 30,
 *                         MaxPercentUnhealthyServices = 30,
 *                     } },
 *                 },
 *             },
 *             ForceRestart = false,
 *             InstanceCloseDelayDuration = 600,
 *             RecreateApplication = false,
 *             RollingUpgradeMonitoringPolicy = new AzureNative.ServiceFabric.Inputs.RollingUpgradeMonitoringPolicyArgs
 *             {
 *                 FailureAction = AzureNative.ServiceFabric.FailureAction.Rollback,
 *                 HealthCheckRetryTimeout = "00:10:00",
 *                 HealthCheckStableDuration = "00:05:00",
 *                 HealthCheckWaitDuration = "00:02:00",
 *                 UpgradeDomainTimeout = "00:15:00",
 *                 UpgradeTimeout = "01:00:00",
 *             },
 *             UpgradeMode = AzureNative.ServiceFabric.RollingUpgradeMode.UnmonitoredAuto,
 *             UpgradeReplicaSetCheckTimeout = 3600,
 *         },
 *         Version = "/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/resRg/providers/Microsoft.ServiceFabric/managedclusters/myCluster/applicationTypes/myAppType/versions/1.0",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/servicefabric/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := servicefabric.NewManagedClusterApplication(ctx, "managedClusterApplication", &servicefabric.ManagedClusterApplicationArgs{
 * 			ApplicationName: pulumi.String("myApp"),
 * 			ClusterName:     pulumi.String("myCluster"),
 * 			Location:        pulumi.String("eastus"),
 * 			Parameters: pulumi.StringMap{
 * 				"param1": pulumi.String("value1"),
 * 			},
 * 			ResourceGroupName: pulumi.String("resRg"),
 * 			Tags: pulumi.StringMap{
 * 				"a": pulumi.String("b"),
 * 			},
 * 			UpgradePolicy: &servicefabric.ApplicationUpgradePolicyArgs{
 * 				ApplicationHealthPolicy: &servicefabric.ApplicationHealthPolicyArgs{
 * 					ConsiderWarningAsError: pulumi.Bool(true),
 * 					DefaultServiceTypeHealthPolicy: &servicefabric.ServiceTypeHealthPolicyArgs{
 * 						MaxPercentUnhealthyPartitionsPerService: pulumi.Int(0),
 * 						MaxPercentUnhealthyReplicasPerPartition: pulumi.Int(0),
 * 						MaxPercentUnhealthyServices:             pulumi.Int(0),
 * 					},
 * 					MaxPercentUnhealthyDeployedApplications: pulumi.Int(0),
 * 					ServiceTypeHealthPolicyMap: servicefabric.ServiceTypeHealthPolicyMap{
 * 						"myService": &servicefabric.ServiceTypeHealthPolicyArgs{
 * 							MaxPercentUnhealthyPartitionsPerService: pulumi.Int(30),
 * 							MaxPercentUnhealthyReplicasPerPartition: pulumi.Int(30),
 * 							MaxPercentUnhealthyServices:             pulumi.Int(30),
 * 						},
 * 					},
 * 				},
 * 				ForceRestart:               pulumi.Bool(false),
 * 				InstanceCloseDelayDuration: pulumi.Float64(600),
 * 				RecreateApplication:        pulumi.Bool(false),
 * 				RollingUpgradeMonitoringPolicy: &servicefabric.RollingUpgradeMonitoringPolicyArgs{
 * 					FailureAction:             pulumi.String(servicefabric.FailureActionRollback),
 * 					HealthCheckRetryTimeout:   pulumi.String("00:10:00"),
 * 					HealthCheckStableDuration: pulumi.String("00:05:00"),
 * 					HealthCheckWaitDuration:   pulumi.String("00:02:00"),
 * 					UpgradeDomainTimeout:      pulumi.String("00:15:00"),
 * 					UpgradeTimeout:            pulumi.String("01:00:00"),
 * 				},
 * 				UpgradeMode:                   pulumi.String(servicefabric.RollingUpgradeModeUnmonitoredAuto),
 * 				UpgradeReplicaSetCheckTimeout: pulumi.Float64(3600),
 * 			},
 * 			Version: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/resRg/providers/Microsoft.ServiceFabric/managedclusters/myCluster/applicationTypes/myAppType/versions/1.0"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.servicefabric.ManagedClusterApplication;
 * import com.pulumi.azurenative.servicefabric.ManagedClusterApplicationArgs;
 * import com.pulumi.azurenative.servicefabric.inputs.ApplicationUpgradePolicyArgs;
 * import com.pulumi.azurenative.servicefabric.inputs.ApplicationHealthPolicyArgs;
 * import com.pulumi.azurenative.servicefabric.inputs.ServiceTypeHealthPolicyArgs;
 * import com.pulumi.azurenative.servicefabric.inputs.RollingUpgradeMonitoringPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedClusterApplication = new ManagedClusterApplication("managedClusterApplication", ManagedClusterApplicationArgs.builder()
 *             .applicationName("myApp")
 *             .clusterName("myCluster")
 *             .location("eastus")
 *             .parameters(Map.of("param1", "value1"))
 *             .resourceGroupName("resRg")
 *             .tags(Map.of("a", "b"))
 *             .upgradePolicy(ApplicationUpgradePolicyArgs.builder()
 *                 .applicationHealthPolicy(ApplicationHealthPolicyArgs.builder()
 *                     .considerWarningAsError(true)
 *                     .defaultServiceTypeHealthPolicy(ServiceTypeHealthPolicyArgs.builder()
 *                         .maxPercentUnhealthyPartitionsPerService(0)
 *                         .maxPercentUnhealthyReplicasPerPartition(0)
 *                         .maxPercentUnhealthyServices(0)
 *                         .build())
 *                     .maxPercentUnhealthyDeployedApplications(0)
 *                     .serviceTypeHealthPolicyMap(Map.of("myService", Map.ofEntries(
 *                         Map.entry("maxPercentUnhealthyPartitionsPerService", 30),
 *                         Map.entry("maxPercentUnhealthyReplicasPerPartition", 30),
 *                         Map.entry("maxPercentUnhealthyServices", 30)
 *                     )))
 *                     .build())
 *                 .forceRestart(false)
 *                 .instanceCloseDelayDuration(600)
 *                 .recreateApplication(false)
 *                 .rollingUpgradeMonitoringPolicy(RollingUpgradeMonitoringPolicyArgs.builder()
 *                     .failureAction("Rollback")
 *                     .healthCheckRetryTimeout("00:10:00")
 *                     .healthCheckStableDuration("00:05:00")
 *                     .healthCheckWaitDuration("00:02:00")
 *                     .upgradeDomainTimeout("00:15:00")
 *                     .upgradeTimeout("01:00:00")
 *                     .build())
 *                 .upgradeMode("UnmonitoredAuto")
 *                 .upgradeReplicaSetCheckTimeout(3600)
 *                 .build())
 *             .version("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/resRg/providers/Microsoft.ServiceFabric/managedclusters/myCluster/applicationTypes/myAppType/versions/1.0")
 *             .build());
 *     }
 * }
 * ```
 * ### Put an application with minimum parameters
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedClusterApplication = new AzureNative.ServiceFabric.ManagedClusterApplication("managedClusterApplication", new()
 *     {
 *         ApplicationName = "myApp",
 *         ClusterName = "myCluster",
 *         Location = "eastus",
 *         ResourceGroupName = "resRg",
 *         Version = "/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/resRg/providers/Microsoft.ServiceFabric/managedclusters/myCluster/applicationTypes/myAppType/versions/1.0",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/servicefabric/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := servicefabric.NewManagedClusterApplication(ctx, "managedClusterApplication", &servicefabric.ManagedClusterApplicationArgs{
 * 			ApplicationName:   pulumi.String("myApp"),
 * 			ClusterName:       pulumi.String("myCluster"),
 * 			Location:          pulumi.String("eastus"),
 * 			ResourceGroupName: pulumi.String("resRg"),
 * 			Version:           pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/resRg/providers/Microsoft.ServiceFabric/managedclusters/myCluster/applicationTypes/myAppType/versions/1.0"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.servicefabric.ManagedClusterApplication;
 * import com.pulumi.azurenative.servicefabric.ManagedClusterApplicationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedClusterApplication = new ManagedClusterApplication("managedClusterApplication", ManagedClusterApplicationArgs.builder()
 *             .applicationName("myApp")
 *             .clusterName("myCluster")
 *             .location("eastus")
 *             .resourceGroupName("resRg")
 *             .version("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/resRg/providers/Microsoft.ServiceFabric/managedclusters/myCluster/applicationTypes/myAppType/versions/1.0")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:servicefabric:ManagedClusterApplication myApp /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceFabric/managedclusters/{clusterName}/applications/{applicationName}
 * ```
 */
public class ManagedClusterApplication internal constructor(
    override val javaResource: com.pulumi.azurenative.servicefabric.ManagedClusterApplication,
) : KotlinCustomResource(javaResource, ManagedClusterApplicationMapper) {
    /**
     * Describes the managed identities for an Azure resource.
     */
    public val identity: Output<ManagedIdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    managedIdentityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * Resource location depends on the parent resource.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * List of user assigned identities for the application, each mapped to a friendly name.
     */
    public val managedIdentities: Output<List<ApplicationUserAssignedIdentityResponse>>?
        get() = javaResource.managedIdentities().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        applicationUserAssignedIdentityResponseToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Azure resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * List of application parameters with overridden values from their default values specified in the application manifest.
     */
    public val parameters: Output<Map<String, String>>?
        get() = javaResource.parameters().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The current deployment or provisioning state, which only appears in the response
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Azure resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Azure resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Describes the policy for a monitored application upgrade.
     */
    public val upgradePolicy: Output<ApplicationUpgradePolicyResponse>?
        get() = javaResource.upgradePolicy().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> applicationUpgradePolicyResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The version of the application type as defined in the application manifest.
     * This name must be the full Arm Resource ID for the referenced application type version.
     */
    public val version: Output<String>?
        get() = javaResource.version().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object ManagedClusterApplicationMapper : ResourceMapper<ManagedClusterApplication> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.servicefabric.ManagedClusterApplication::class == javaResource::class

    override fun map(javaResource: Resource): ManagedClusterApplication =
        ManagedClusterApplication(
            javaResource as
                com.pulumi.azurenative.servicefabric.ManagedClusterApplication,
        )
}

/**
 * @see [ManagedClusterApplication].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ManagedClusterApplication].
 */
public suspend fun managedClusterApplication(
    name: String,
    block: suspend ManagedClusterApplicationResourceBuilder.() -> Unit,
): ManagedClusterApplication {
    val builder = ManagedClusterApplicationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ManagedClusterApplication].
 * @param name The _unique_ name of the resulting resource.
 */
public fun managedClusterApplication(name: String): ManagedClusterApplication {
    val builder = ManagedClusterApplicationResourceBuilder()
    builder.name(name)
    return builder.build()
}
