@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin

import com.pulumi.azurenative.servicefabric.ManagedClusterApplicationArgs.builder
import com.pulumi.azurenative.servicefabric.kotlin.inputs.ApplicationUpgradePolicyArgs
import com.pulumi.azurenative.servicefabric.kotlin.inputs.ApplicationUpgradePolicyArgsBuilder
import com.pulumi.azurenative.servicefabric.kotlin.inputs.ApplicationUserAssignedIdentityArgs
import com.pulumi.azurenative.servicefabric.kotlin.inputs.ApplicationUserAssignedIdentityArgsBuilder
import com.pulumi.azurenative.servicefabric.kotlin.inputs.ManagedIdentityArgs
import com.pulumi.azurenative.servicefabric.kotlin.inputs.ManagedIdentityArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The application resource.
 * Azure REST API version: 2023-03-01-preview.
 * Other available API versions: 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview, 2023-12-01-preview, 2024-02-01-preview.
 * ## Example Usage
 * ### Put an application with maximum parameters
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedClusterApplication = new AzureNative.ServiceFabric.ManagedClusterApplication("managedClusterApplication", new()
 *     {
 *         ApplicationName = "myApp",
 *         ClusterName = "myCluster",
 *         Location = "eastus",
 *         Parameters =
 *         {
 *             { "param1", "value1" },
 *         },
 *         ResourceGroupName = "resRg",
 *         Tags =
 *         {
 *             { "a", "b" },
 *         },
 *         UpgradePolicy = new AzureNative.ServiceFabric.Inputs.ApplicationUpgradePolicyArgs
 *         {
 *             ApplicationHealthPolicy = new AzureNative.ServiceFabric.Inputs.ApplicationHealthPolicyArgs
 *             {
 *                 ConsiderWarningAsError = true,
 *                 DefaultServiceTypeHealthPolicy = new AzureNative.ServiceFabric.Inputs.ServiceTypeHealthPolicyArgs
 *                 {
 *                     MaxPercentUnhealthyPartitionsPerService = 0,
 *                     MaxPercentUnhealthyReplicasPerPartition = 0,
 *                     MaxPercentUnhealthyServices = 0,
 *                 },
 *                 MaxPercentUnhealthyDeployedApplications = 0,
 *                 ServiceTypeHealthPolicyMap =
 *                 {
 *                     { "myService", new AzureNative.ServiceFabric.Inputs.ServiceTypeHealthPolicyArgs
 *                     {
 *                         MaxPercentUnhealthyPartitionsPerService = 30,
 *                         MaxPercentUnhealthyReplicasPerPartition = 30,
 *                         MaxPercentUnhealthyServices = 30,
 *                     } },
 *                 },
 *             },
 *             ForceRestart = false,
 *             InstanceCloseDelayDuration = 600,
 *             RecreateApplication = false,
 *             RollingUpgradeMonitoringPolicy = new AzureNative.ServiceFabric.Inputs.RollingUpgradeMonitoringPolicyArgs
 *             {
 *                 FailureAction = AzureNative.ServiceFabric.FailureAction.Rollback,
 *                 HealthCheckRetryTimeout = "00:10:00",
 *                 HealthCheckStableDuration = "00:05:00",
 *                 HealthCheckWaitDuration = "00:02:00",
 *                 UpgradeDomainTimeout = "00:15:00",
 *                 UpgradeTimeout = "01:00:00",
 *             },
 *             UpgradeMode = AzureNative.ServiceFabric.RollingUpgradeMode.UnmonitoredAuto,
 *             UpgradeReplicaSetCheckTimeout = 3600,
 *         },
 *         Version = "/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/resRg/providers/Microsoft.ServiceFabric/managedclusters/myCluster/applicationTypes/myAppType/versions/1.0",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/servicefabric/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := servicefabric.NewManagedClusterApplication(ctx, "managedClusterApplication", &servicefabric.ManagedClusterApplicationArgs{
 * 			ApplicationName: pulumi.String("myApp"),
 * 			ClusterName:     pulumi.String("myCluster"),
 * 			Location:        pulumi.String("eastus"),
 * 			Parameters: pulumi.StringMap{
 * 				"param1": pulumi.String("value1"),
 * 			},
 * 			ResourceGroupName: pulumi.String("resRg"),
 * 			Tags: pulumi.StringMap{
 * 				"a": pulumi.String("b"),
 * 			},
 * 			UpgradePolicy: &servicefabric.ApplicationUpgradePolicyArgs{
 * 				ApplicationHealthPolicy: &servicefabric.ApplicationHealthPolicyArgs{
 * 					ConsiderWarningAsError: pulumi.Bool(true),
 * 					DefaultServiceTypeHealthPolicy: &servicefabric.ServiceTypeHealthPolicyArgs{
 * 						MaxPercentUnhealthyPartitionsPerService: pulumi.Int(0),
 * 						MaxPercentUnhealthyReplicasPerPartition: pulumi.Int(0),
 * 						MaxPercentUnhealthyServices:             pulumi.Int(0),
 * 					},
 * 					MaxPercentUnhealthyDeployedApplications: pulumi.Int(0),
 * 					ServiceTypeHealthPolicyMap: servicefabric.ServiceTypeHealthPolicyMap{
 * 						"myService": &servicefabric.ServiceTypeHealthPolicyArgs{
 * 							MaxPercentUnhealthyPartitionsPerService: pulumi.Int(30),
 * 							MaxPercentUnhealthyReplicasPerPartition: pulumi.Int(30),
 * 							MaxPercentUnhealthyServices:             pulumi.Int(30),
 * 						},
 * 					},
 * 				},
 * 				ForceRestart:               pulumi.Bool(false),
 * 				InstanceCloseDelayDuration: pulumi.Float64(600),
 * 				RecreateApplication:        pulumi.Bool(false),
 * 				RollingUpgradeMonitoringPolicy: &servicefabric.RollingUpgradeMonitoringPolicyArgs{
 * 					FailureAction:             pulumi.String(servicefabric.FailureActionRollback),
 * 					HealthCheckRetryTimeout:   pulumi.String("00:10:00"),
 * 					HealthCheckStableDuration: pulumi.String("00:05:00"),
 * 					HealthCheckWaitDuration:   pulumi.String("00:02:00"),
 * 					UpgradeDomainTimeout:      pulumi.String("00:15:00"),
 * 					UpgradeTimeout:            pulumi.String("01:00:00"),
 * 				},
 * 				UpgradeMode:                   pulumi.String(servicefabric.RollingUpgradeModeUnmonitoredAuto),
 * 				UpgradeReplicaSetCheckTimeout: pulumi.Float64(3600),
 * 			},
 * 			Version: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/resRg/providers/Microsoft.ServiceFabric/managedclusters/myCluster/applicationTypes/myAppType/versions/1.0"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.servicefabric.ManagedClusterApplication;
 * import com.pulumi.azurenative.servicefabric.ManagedClusterApplicationArgs;
 * import com.pulumi.azurenative.servicefabric.inputs.ApplicationUpgradePolicyArgs;
 * import com.pulumi.azurenative.servicefabric.inputs.ApplicationHealthPolicyArgs;
 * import com.pulumi.azurenative.servicefabric.inputs.ServiceTypeHealthPolicyArgs;
 * import com.pulumi.azurenative.servicefabric.inputs.RollingUpgradeMonitoringPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedClusterApplication = new ManagedClusterApplication("managedClusterApplication", ManagedClusterApplicationArgs.builder()
 *             .applicationName("myApp")
 *             .clusterName("myCluster")
 *             .location("eastus")
 *             .parameters(Map.of("param1", "value1"))
 *             .resourceGroupName("resRg")
 *             .tags(Map.of("a", "b"))
 *             .upgradePolicy(ApplicationUpgradePolicyArgs.builder()
 *                 .applicationHealthPolicy(ApplicationHealthPolicyArgs.builder()
 *                     .considerWarningAsError(true)
 *                     .defaultServiceTypeHealthPolicy(ServiceTypeHealthPolicyArgs.builder()
 *                         .maxPercentUnhealthyPartitionsPerService(0)
 *                         .maxPercentUnhealthyReplicasPerPartition(0)
 *                         .maxPercentUnhealthyServices(0)
 *                         .build())
 *                     .maxPercentUnhealthyDeployedApplications(0)
 *                     .serviceTypeHealthPolicyMap(Map.of("myService", Map.ofEntries(
 *                         Map.entry("maxPercentUnhealthyPartitionsPerService", 30),
 *                         Map.entry("maxPercentUnhealthyReplicasPerPartition", 30),
 *                         Map.entry("maxPercentUnhealthyServices", 30)
 *                     )))
 *                     .build())
 *                 .forceRestart(false)
 *                 .instanceCloseDelayDuration(600)
 *                 .recreateApplication(false)
 *                 .rollingUpgradeMonitoringPolicy(RollingUpgradeMonitoringPolicyArgs.builder()
 *                     .failureAction("Rollback")
 *                     .healthCheckRetryTimeout("00:10:00")
 *                     .healthCheckStableDuration("00:05:00")
 *                     .healthCheckWaitDuration("00:02:00")
 *                     .upgradeDomainTimeout("00:15:00")
 *                     .upgradeTimeout("01:00:00")
 *                     .build())
 *                 .upgradeMode("UnmonitoredAuto")
 *                 .upgradeReplicaSetCheckTimeout(3600)
 *                 .build())
 *             .version("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/resRg/providers/Microsoft.ServiceFabric/managedclusters/myCluster/applicationTypes/myAppType/versions/1.0")
 *             .build());
 *     }
 * }
 * ```
 * ### Put an application with minimum parameters
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedClusterApplication = new AzureNative.ServiceFabric.ManagedClusterApplication("managedClusterApplication", new()
 *     {
 *         ApplicationName = "myApp",
 *         ClusterName = "myCluster",
 *         Location = "eastus",
 *         ResourceGroupName = "resRg",
 *         Version = "/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/resRg/providers/Microsoft.ServiceFabric/managedclusters/myCluster/applicationTypes/myAppType/versions/1.0",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/servicefabric/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := servicefabric.NewManagedClusterApplication(ctx, "managedClusterApplication", &servicefabric.ManagedClusterApplicationArgs{
 * 			ApplicationName:   pulumi.String("myApp"),
 * 			ClusterName:       pulumi.String("myCluster"),
 * 			Location:          pulumi.String("eastus"),
 * 			ResourceGroupName: pulumi.String("resRg"),
 * 			Version:           pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/resRg/providers/Microsoft.ServiceFabric/managedclusters/myCluster/applicationTypes/myAppType/versions/1.0"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.servicefabric.ManagedClusterApplication;
 * import com.pulumi.azurenative.servicefabric.ManagedClusterApplicationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedClusterApplication = new ManagedClusterApplication("managedClusterApplication", ManagedClusterApplicationArgs.builder()
 *             .applicationName("myApp")
 *             .clusterName("myCluster")
 *             .location("eastus")
 *             .resourceGroupName("resRg")
 *             .version("/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/resRg/providers/Microsoft.ServiceFabric/managedclusters/myCluster/applicationTypes/myAppType/versions/1.0")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:servicefabric:ManagedClusterApplication myApp /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceFabric/managedclusters/{clusterName}/applications/{applicationName}
 * ```
 * @property applicationName The name of the application resource.
 * @property clusterName The name of the cluster resource.
 * @property identity Describes the managed identities for an Azure resource.
 * @property location Resource location depends on the parent resource.
 * @property managedIdentities List of user assigned identities for the application, each mapped to a friendly name.
 * @property parameters List of application parameters with overridden values from their default values specified in the application manifest.
 * @property resourceGroupName The name of the resource group.
 * @property tags Azure resource tags.
 * @property upgradePolicy Describes the policy for a monitored application upgrade.
 * @property version The version of the application type as defined in the application manifest.
 * This name must be the full Arm Resource ID for the referenced application type version.
 */
public data class ManagedClusterApplicationArgs(
    public val applicationName: Output<String>? = null,
    public val clusterName: Output<String>? = null,
    public val identity: Output<ManagedIdentityArgs>? = null,
    public val location: Output<String>? = null,
    public val managedIdentities: Output<List<ApplicationUserAssignedIdentityArgs>>? = null,
    public val parameters: Output<Map<String, String>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val upgradePolicy: Output<ApplicationUpgradePolicyArgs>? = null,
    public val version: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.servicefabric.ManagedClusterApplicationArgs> {
    override fun toJava(): com.pulumi.azurenative.servicefabric.ManagedClusterApplicationArgs =
        com.pulumi.azurenative.servicefabric.ManagedClusterApplicationArgs.builder()
            .applicationName(applicationName?.applyValue({ args0 -> args0 }))
            .clusterName(clusterName?.applyValue({ args0 -> args0 }))
            .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .managedIdentities(
                managedIdentities?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .upgradePolicy(upgradePolicy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ManagedClusterApplicationArgs].
 */
@PulumiTagMarker
public class ManagedClusterApplicationArgsBuilder internal constructor() {
    private var applicationName: Output<String>? = null

    private var clusterName: Output<String>? = null

    private var identity: Output<ManagedIdentityArgs>? = null

    private var location: Output<String>? = null

    private var managedIdentities: Output<List<ApplicationUserAssignedIdentityArgs>>? = null

    private var parameters: Output<Map<String, String>>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var upgradePolicy: Output<ApplicationUpgradePolicyArgs>? = null

    private var version: Output<String>? = null

    /**
     * @param value The name of the application resource.
     */
    @JvmName("wxrfryrnwoijstjb")
    public suspend fun applicationName(`value`: Output<String>) {
        this.applicationName = value
    }

    /**
     * @param value The name of the cluster resource.
     */
    @JvmName("vbmhgremdeoctvas")
    public suspend fun clusterName(`value`: Output<String>) {
        this.clusterName = value
    }

    /**
     * @param value Describes the managed identities for an Azure resource.
     */
    @JvmName("yqbsoboigouynnik")
    public suspend fun identity(`value`: Output<ManagedIdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value Resource location depends on the parent resource.
     */
    @JvmName("vvkpjptbptfsxnir")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value List of user assigned identities for the application, each mapped to a friendly name.
     */
    @JvmName("uadmcjcvnjkbnjxc")
    public suspend fun managedIdentities(`value`: Output<List<ApplicationUserAssignedIdentityArgs>>) {
        this.managedIdentities = value
    }

    @JvmName("xfrpmuskfnuyewaa")
    public suspend fun managedIdentities(vararg values: Output<ApplicationUserAssignedIdentityArgs>) {
        this.managedIdentities = Output.all(values.asList())
    }

    /**
     * @param values List of user assigned identities for the application, each mapped to a friendly name.
     */
    @JvmName("yshauurqwuehxbbl")
    public suspend fun managedIdentities(values: List<Output<ApplicationUserAssignedIdentityArgs>>) {
        this.managedIdentities = Output.all(values)
    }

    /**
     * @param value List of application parameters with overridden values from their default values specified in the application manifest.
     */
    @JvmName("qijhmwulnsrfxynr")
    public suspend fun parameters(`value`: Output<Map<String, String>>) {
        this.parameters = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("ogeniqnvpjxmytuj")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Azure resource tags.
     */
    @JvmName("npjxfjxxcwoxjeap")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Describes the policy for a monitored application upgrade.
     */
    @JvmName("exighkflatvbofci")
    public suspend fun upgradePolicy(`value`: Output<ApplicationUpgradePolicyArgs>) {
        this.upgradePolicy = value
    }

    /**
     * @param value The version of the application type as defined in the application manifest.
     * This name must be the full Arm Resource ID for the referenced application type version.
     */
    @JvmName("gkuifopxtujwxfte")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value The name of the application resource.
     */
    @JvmName("ghsugsvugeyyawih")
    public suspend fun applicationName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationName = mapped
    }

    /**
     * @param value The name of the cluster resource.
     */
    @JvmName("etxwuncsisimtcxe")
    public suspend fun clusterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterName = mapped
    }

    /**
     * @param value Describes the managed identities for an Azure resource.
     */
    @JvmName("bkjpqtqltnwjrtww")
    public suspend fun identity(`value`: ManagedIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument Describes the managed identities for an Azure resource.
     */
    @JvmName("enjbssdcjkgglugq")
    public suspend fun identity(argument: suspend ManagedIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value Resource location depends on the parent resource.
     */
    @JvmName("gjkxtvecnuintvre")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value List of user assigned identities for the application, each mapped to a friendly name.
     */
    @JvmName("otecjoyvxnsyycyf")
    public suspend fun managedIdentities(`value`: List<ApplicationUserAssignedIdentityArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedIdentities = mapped
    }

    /**
     * @param argument List of user assigned identities for the application, each mapped to a friendly name.
     */
    @JvmName("qhkvnllyflanbhak")
    public suspend
    fun managedIdentities(argument: List<suspend ApplicationUserAssignedIdentityArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ApplicationUserAssignedIdentityArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.managedIdentities = mapped
    }

    /**
     * @param argument List of user assigned identities for the application, each mapped to a friendly name.
     */
    @JvmName("bnfnadifdefwdjlk")
    public suspend fun managedIdentities(
        vararg
        argument: suspend ApplicationUserAssignedIdentityArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ApplicationUserAssignedIdentityArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.managedIdentities = mapped
    }

    /**
     * @param argument List of user assigned identities for the application, each mapped to a friendly name.
     */
    @JvmName("ognydrcwimabisay")
    public suspend
    fun managedIdentities(argument: suspend ApplicationUserAssignedIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ApplicationUserAssignedIdentityArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.managedIdentities = mapped
    }

    /**
     * @param values List of user assigned identities for the application, each mapped to a friendly name.
     */
    @JvmName("bngyygavfplsutgn")
    public suspend fun managedIdentities(vararg values: ApplicationUserAssignedIdentityArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.managedIdentities = mapped
    }

    /**
     * @param value List of application parameters with overridden values from their default values specified in the application manifest.
     */
    @JvmName("roldgyivtggpdygk")
    public suspend fun parameters(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param values List of application parameters with overridden values from their default values specified in the application manifest.
     */
    @JvmName("raiutqmwedvihhiy")
    public fun parameters(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("suurvwnokmpwjjad")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Azure resource tags.
     */
    @JvmName("iwqfyfxojojkhele")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Azure resource tags.
     */
    @JvmName("mgpfytecswmhkowe")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Describes the policy for a monitored application upgrade.
     */
    @JvmName("kwyfduycxfhhcbks")
    public suspend fun upgradePolicy(`value`: ApplicationUpgradePolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.upgradePolicy = mapped
    }

    /**
     * @param argument Describes the policy for a monitored application upgrade.
     */
    @JvmName("odsbeschbsxamybu")
    public suspend
    fun upgradePolicy(argument: suspend ApplicationUpgradePolicyArgsBuilder.() -> Unit) {
        val toBeMapped = ApplicationUpgradePolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.upgradePolicy = mapped
    }

    /**
     * @param value The version of the application type as defined in the application manifest.
     * This name must be the full Arm Resource ID for the referenced application type version.
     */
    @JvmName("nqbaoofauahseajg")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): ManagedClusterApplicationArgs = ManagedClusterApplicationArgs(
        applicationName = applicationName,
        clusterName = clusterName,
        identity = identity,
        location = location,
        managedIdentities = managedIdentities,
        parameters = parameters,
        resourceGroupName = resourceGroupName,
        tags = tags,
        upgradePolicy = upgradePolicy,
        version = version,
    )
}
