@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin

import com.pulumi.azurenative.servicefabric.ManagedClusterApplicationTypeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The application type name resource
 * Azure REST API version: 2023-03-01-preview.
 * Other available API versions: 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview, 2023-12-01-preview, 2024-02-01-preview.
 * ## Example Usage
 * ### Put an application type
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedClusterApplicationType = new AzureNative.ServiceFabric.ManagedClusterApplicationType("managedClusterApplicationType", new()
 *     {
 *         ApplicationTypeName = "myAppType",
 *         ClusterName = "myCluster",
 *         Location = "eastus",
 *         ResourceGroupName = "resRg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/servicefabric/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := servicefabric.NewManagedClusterApplicationType(ctx, "managedClusterApplicationType", &servicefabric.ManagedClusterApplicationTypeArgs{
 * 			ApplicationTypeName: pulumi.String("myAppType"),
 * 			ClusterName:         pulumi.String("myCluster"),
 * 			Location:            pulumi.String("eastus"),
 * 			ResourceGroupName:   pulumi.String("resRg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.servicefabric.ManagedClusterApplicationType;
 * import com.pulumi.azurenative.servicefabric.ManagedClusterApplicationTypeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedClusterApplicationType = new ManagedClusterApplicationType("managedClusterApplicationType", ManagedClusterApplicationTypeArgs.builder()
 *             .applicationTypeName("myAppType")
 *             .clusterName("myCluster")
 *             .location("eastus")
 *             .resourceGroupName("resRg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:servicefabric:ManagedClusterApplicationType myAppType /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceFabric/managedclusters/{clusterName}/applicationTypes/{applicationTypeName}
 * ```
 * @property applicationTypeName The name of the application type name resource.
 * @property clusterName The name of the cluster resource.
 * @property location Resource location depends on the parent resource.
 * @property resourceGroupName The name of the resource group.
 * @property tags Azure resource tags.
 */
public data class ManagedClusterApplicationTypeArgs(
    public val applicationTypeName: Output<String>? = null,
    public val clusterName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.servicefabric.ManagedClusterApplicationTypeArgs> {
    override fun toJava(): com.pulumi.azurenative.servicefabric.ManagedClusterApplicationTypeArgs =
        com.pulumi.azurenative.servicefabric.ManagedClusterApplicationTypeArgs.builder()
            .applicationTypeName(applicationTypeName?.applyValue({ args0 -> args0 }))
            .clusterName(clusterName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ManagedClusterApplicationTypeArgs].
 */
@PulumiTagMarker
public class ManagedClusterApplicationTypeArgsBuilder internal constructor() {
    private var applicationTypeName: Output<String>? = null

    private var clusterName: Output<String>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The name of the application type name resource.
     */
    @JvmName("aqqvwlyexvqdofmn")
    public suspend fun applicationTypeName(`value`: Output<String>) {
        this.applicationTypeName = value
    }

    /**
     * @param value The name of the cluster resource.
     */
    @JvmName("xxyjlnearxlajtpb")
    public suspend fun clusterName(`value`: Output<String>) {
        this.clusterName = value
    }

    /**
     * @param value Resource location depends on the parent resource.
     */
    @JvmName("xptiuchpmcbmuqeg")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("tosdcxqwfdssgfio")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Azure resource tags.
     */
    @JvmName("gbrfhiahjneistgd")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The name of the application type name resource.
     */
    @JvmName("swqymahmdetbbxnr")
    public suspend fun applicationTypeName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationTypeName = mapped
    }

    /**
     * @param value The name of the cluster resource.
     */
    @JvmName("pllowriocfrrnsot")
    public suspend fun clusterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterName = mapped
    }

    /**
     * @param value Resource location depends on the parent resource.
     */
    @JvmName("jamkiebmtqkiobrw")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("kkkverxrinemnwpf")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Azure resource tags.
     */
    @JvmName("gbwwrptptmvohnif")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Azure resource tags.
     */
    @JvmName("lqclsaonmsimjxfq")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ManagedClusterApplicationTypeArgs = ManagedClusterApplicationTypeArgs(
        applicationTypeName = applicationTypeName,
        clusterName = clusterName,
        location = location,
        resourceGroupName = resourceGroupName,
        tags = tags,
    )
}
