@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin

import com.pulumi.azurenative.servicefabric.kotlin.outputs.SystemDataResponse
import com.pulumi.azurenative.servicefabric.kotlin.outputs.SystemDataResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [ManagedClusterApplicationTypeVersion].
 */
@PulumiTagMarker
public class ManagedClusterApplicationTypeVersionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ManagedClusterApplicationTypeVersionArgs =
        ManagedClusterApplicationTypeVersionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend
    fun args(block: suspend ManagedClusterApplicationTypeVersionArgsBuilder.() -> Unit) {
        val builder = ManagedClusterApplicationTypeVersionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ManagedClusterApplicationTypeVersion {
        val builtJavaResource =
            com.pulumi.azurenative.servicefabric.ManagedClusterApplicationTypeVersion(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ManagedClusterApplicationTypeVersion(builtJavaResource)
    }
}

/**
 * An application type version resource for the specified application type name resource.
 * Azure REST API version: 2023-03-01-preview.
 * Other available API versions: 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview, 2023-12-01-preview, 2024-02-01-preview.
 * ## Example Usage
 * ### Put an application type version
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedClusterApplicationTypeVersion = new AzureNative.ServiceFabric.ManagedClusterApplicationTypeVersion("managedClusterApplicationTypeVersion", new()
 *     {
 *         AppPackageUrl = "http://fakelink.test.com/MyAppType",
 *         ApplicationTypeName = "myAppType",
 *         ClusterName = "myCluster",
 *         Location = "eastus",
 *         ResourceGroupName = "resRg",
 *         Version = "1.0",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/servicefabric/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := servicefabric.NewManagedClusterApplicationTypeVersion(ctx, "managedClusterApplicationTypeVersion", &servicefabric.ManagedClusterApplicationTypeVersionArgs{
 * 			AppPackageUrl:       pulumi.String("http://fakelink.test.com/MyAppType"),
 * 			ApplicationTypeName: pulumi.String("myAppType"),
 * 			ClusterName:         pulumi.String("myCluster"),
 * 			Location:            pulumi.String("eastus"),
 * 			ResourceGroupName:   pulumi.String("resRg"),
 * 			Version:             pulumi.String("1.0"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.servicefabric.ManagedClusterApplicationTypeVersion;
 * import com.pulumi.azurenative.servicefabric.ManagedClusterApplicationTypeVersionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedClusterApplicationTypeVersion = new ManagedClusterApplicationTypeVersion("managedClusterApplicationTypeVersion", ManagedClusterApplicationTypeVersionArgs.builder()
 *             .appPackageUrl("http://fakelink.test.com/MyAppType")
 *             .applicationTypeName("myAppType")
 *             .clusterName("myCluster")
 *             .location("eastus")
 *             .resourceGroupName("resRg")
 *             .version("1.0")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:servicefabric:ManagedClusterApplicationTypeVersion 1.0 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceFabric/managedclusters/{clusterName}/applicationTypes/{applicationTypeName}/versions/{version}
 * ```
 */
public class ManagedClusterApplicationTypeVersion internal constructor(
    override val javaResource:
    com.pulumi.azurenative.servicefabric.ManagedClusterApplicationTypeVersion,
) : KotlinCustomResource(javaResource, ManagedClusterApplicationTypeVersionMapper) {
    /**
     * The URL to the application package
     */
    public val appPackageUrl: Output<String>
        get() = javaResource.appPackageUrl().applyValue({ args0 -> args0 })

    /**
     * Resource location depends on the parent resource.
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Azure resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The current deployment or provisioning state, which only appears in the response
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Azure resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Azure resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ManagedClusterApplicationTypeVersionMapper :
    ResourceMapper<ManagedClusterApplicationTypeVersion> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.servicefabric.ManagedClusterApplicationTypeVersion::class == javaResource::class

    override fun map(javaResource: Resource): ManagedClusterApplicationTypeVersion =
        ManagedClusterApplicationTypeVersion(
            javaResource as
                com.pulumi.azurenative.servicefabric.ManagedClusterApplicationTypeVersion,
        )
}

/**
 * @see [ManagedClusterApplicationTypeVersion].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ManagedClusterApplicationTypeVersion].
 */
public suspend fun managedClusterApplicationTypeVersion(
    name: String,
    block: suspend ManagedClusterApplicationTypeVersionResourceBuilder.() -> Unit,
):
    ManagedClusterApplicationTypeVersion {
    val builder = ManagedClusterApplicationTypeVersionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ManagedClusterApplicationTypeVersion].
 * @param name The _unique_ name of the resulting resource.
 */
public fun managedClusterApplicationTypeVersion(name: String):
    ManagedClusterApplicationTypeVersion {
    val builder = ManagedClusterApplicationTypeVersionResourceBuilder()
    builder.name(name)
    return builder.build()
}
