@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin

import com.pulumi.azurenative.servicefabric.ManagedClusterApplicationTypeVersionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * An application type version resource for the specified application type name resource.
 * Azure REST API version: 2023-03-01-preview.
 * Other available API versions: 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview, 2023-12-01-preview, 2024-02-01-preview.
 * ## Example Usage
 * ### Put an application type version
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var managedClusterApplicationTypeVersion = new AzureNative.ServiceFabric.ManagedClusterApplicationTypeVersion("managedClusterApplicationTypeVersion", new()
 *     {
 *         AppPackageUrl = "http://fakelink.test.com/MyAppType",
 *         ApplicationTypeName = "myAppType",
 *         ClusterName = "myCluster",
 *         Location = "eastus",
 *         ResourceGroupName = "resRg",
 *         Version = "1.0",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/servicefabric/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := servicefabric.NewManagedClusterApplicationTypeVersion(ctx, "managedClusterApplicationTypeVersion", &servicefabric.ManagedClusterApplicationTypeVersionArgs{
 * 			AppPackageUrl:       pulumi.String("http://fakelink.test.com/MyAppType"),
 * 			ApplicationTypeName: pulumi.String("myAppType"),
 * 			ClusterName:         pulumi.String("myCluster"),
 * 			Location:            pulumi.String("eastus"),
 * 			ResourceGroupName:   pulumi.String("resRg"),
 * 			Version:             pulumi.String("1.0"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.servicefabric.ManagedClusterApplicationTypeVersion;
 * import com.pulumi.azurenative.servicefabric.ManagedClusterApplicationTypeVersionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var managedClusterApplicationTypeVersion = new ManagedClusterApplicationTypeVersion("managedClusterApplicationTypeVersion", ManagedClusterApplicationTypeVersionArgs.builder()
 *             .appPackageUrl("http://fakelink.test.com/MyAppType")
 *             .applicationTypeName("myAppType")
 *             .clusterName("myCluster")
 *             .location("eastus")
 *             .resourceGroupName("resRg")
 *             .version("1.0")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:servicefabric:ManagedClusterApplicationTypeVersion 1.0 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceFabric/managedclusters/{clusterName}/applicationTypes/{applicationTypeName}/versions/{version}
 * ```
 * @property appPackageUrl The URL to the application package
 * @property applicationTypeName The name of the application type name resource.
 * @property clusterName The name of the cluster resource.
 * @property location Resource location depends on the parent resource.
 * @property resourceGroupName The name of the resource group.
 * @property tags Azure resource tags.
 * @property version The application type version.
 */
public data class ManagedClusterApplicationTypeVersionArgs(
    public val appPackageUrl: Output<String>? = null,
    public val applicationTypeName: Output<String>? = null,
    public val clusterName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val version: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.servicefabric.ManagedClusterApplicationTypeVersionArgs> {
    override fun toJava():
        com.pulumi.azurenative.servicefabric.ManagedClusterApplicationTypeVersionArgs =
        com.pulumi.azurenative.servicefabric.ManagedClusterApplicationTypeVersionArgs.builder()
            .appPackageUrl(appPackageUrl?.applyValue({ args0 -> args0 }))
            .applicationTypeName(applicationTypeName?.applyValue({ args0 -> args0 }))
            .clusterName(clusterName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ManagedClusterApplicationTypeVersionArgs].
 */
@PulumiTagMarker
public class ManagedClusterApplicationTypeVersionArgsBuilder internal constructor() {
    private var appPackageUrl: Output<String>? = null

    private var applicationTypeName: Output<String>? = null

    private var clusterName: Output<String>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var version: Output<String>? = null

    /**
     * @param value The URL to the application package
     */
    @JvmName("ucviisosvqiltfiq")
    public suspend fun appPackageUrl(`value`: Output<String>) {
        this.appPackageUrl = value
    }

    /**
     * @param value The name of the application type name resource.
     */
    @JvmName("sgfvhepwnynkasvi")
    public suspend fun applicationTypeName(`value`: Output<String>) {
        this.applicationTypeName = value
    }

    /**
     * @param value The name of the cluster resource.
     */
    @JvmName("bgqnngdtadqvkwki")
    public suspend fun clusterName(`value`: Output<String>) {
        this.clusterName = value
    }

    /**
     * @param value Resource location depends on the parent resource.
     */
    @JvmName("xbxfboifaecucqro")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("smcnpcetfqopnagy")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Azure resource tags.
     */
    @JvmName("syxlrnwldigjqoee")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The application type version.
     */
    @JvmName("ocbajdmugjvhlslu")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value The URL to the application package
     */
    @JvmName("bkrdfuvtvagswjnk")
    public suspend fun appPackageUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appPackageUrl = mapped
    }

    /**
     * @param value The name of the application type name resource.
     */
    @JvmName("qeuhmmyyvwivdycy")
    public suspend fun applicationTypeName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationTypeName = mapped
    }

    /**
     * @param value The name of the cluster resource.
     */
    @JvmName("umnbmohumtpqunvi")
    public suspend fun clusterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterName = mapped
    }

    /**
     * @param value Resource location depends on the parent resource.
     */
    @JvmName("upracyuwfysyvmwp")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("tehhkyajeegwvwyv")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Azure resource tags.
     */
    @JvmName("aykuvqtkloqgrimi")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Azure resource tags.
     */
    @JvmName("gwekbrxgjagtqswa")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The application type version.
     */
    @JvmName("agdpxlujhlkmcmac")
    public suspend fun version(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): ManagedClusterApplicationTypeVersionArgs =
        ManagedClusterApplicationTypeVersionArgs(
            appPackageUrl = appPackageUrl,
            applicationTypeName = applicationTypeName,
            clusterName = clusterName,
            location = location,
            resourceGroupName = resourceGroupName,
            tags = tags,
            version = version,
        )
}
