@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin

import com.pulumi.azurenative.servicefabric.NodeTypeArgs.builder
import com.pulumi.azurenative.servicefabric.kotlin.enums.DiskType
import com.pulumi.azurenative.servicefabric.kotlin.enums.EvictionPolicyType
import com.pulumi.azurenative.servicefabric.kotlin.enums.SecurityType
import com.pulumi.azurenative.servicefabric.kotlin.enums.VmSetupAction
import com.pulumi.azurenative.servicefabric.kotlin.inputs.EndpointRangeDescriptionArgs
import com.pulumi.azurenative.servicefabric.kotlin.inputs.EndpointRangeDescriptionArgsBuilder
import com.pulumi.azurenative.servicefabric.kotlin.inputs.FrontendConfigurationArgs
import com.pulumi.azurenative.servicefabric.kotlin.inputs.FrontendConfigurationArgsBuilder
import com.pulumi.azurenative.servicefabric.kotlin.inputs.NetworkSecurityRuleArgs
import com.pulumi.azurenative.servicefabric.kotlin.inputs.NetworkSecurityRuleArgsBuilder
import com.pulumi.azurenative.servicefabric.kotlin.inputs.NodeTypeSkuArgs
import com.pulumi.azurenative.servicefabric.kotlin.inputs.NodeTypeSkuArgsBuilder
import com.pulumi.azurenative.servicefabric.kotlin.inputs.VMSSExtensionArgs
import com.pulumi.azurenative.servicefabric.kotlin.inputs.VMSSExtensionArgsBuilder
import com.pulumi.azurenative.servicefabric.kotlin.inputs.VaultSecretGroupArgs
import com.pulumi.azurenative.servicefabric.kotlin.inputs.VaultSecretGroupArgsBuilder
import com.pulumi.azurenative.servicefabric.kotlin.inputs.VmImagePlanArgs
import com.pulumi.azurenative.servicefabric.kotlin.inputs.VmImagePlanArgsBuilder
import com.pulumi.azurenative.servicefabric.kotlin.inputs.VmManagedIdentityArgs
import com.pulumi.azurenative.servicefabric.kotlin.inputs.VmManagedIdentityArgsBuilder
import com.pulumi.azurenative.servicefabric.kotlin.inputs.VmssDataDiskArgs
import com.pulumi.azurenative.servicefabric.kotlin.inputs.VmssDataDiskArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Describes a node type in the cluster, each node type represents sub set of nodes in the cluster.
 * Azure REST API version: 2023-03-01-preview. Prior API version in Azure Native 1.x: 2020-01-01-preview.
 * Other available API versions: 2021-09-01-privatepreview, 2023-07-01-preview, 2023-09-01-preview, 2023-11-01-preview, 2023-12-01-preview, 2024-02-01-preview.
 * ## Example Usage
 * ### Put a node type with auto-scale parameters
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var nodeType = new AzureNative.ServiceFabric.NodeType("nodeType", new()
 *     {
 *         Capacities =
 *         {
 *             { "ClientConnections", "65536" },
 *         },
 *         ClusterName = "myCluster",
 *         DataDiskSizeGB = 200,
 *         DataDiskType = AzureNative.ServiceFabric.DiskType.Premium_LRS,
 *         IsPrimary = false,
 *         IsStateless = true,
 *         MultiplePlacementGroups = true,
 *         NodeTypeName = "BE",
 *         PlacementProperties =
 *         {
 *             { "HasSSD", "true" },
 *             { "NodeColor", "green" },
 *             { "SomeProperty", "5" },
 *         },
 *         ResourceGroupName = "resRg",
 *         VmExtensions = new[]
 *         {
 *             new AzureNative.ServiceFabric.Inputs.VMSSExtensionArgs
 *             {
 *                 AutoUpgradeMinorVersion = true,
 *                 Name = "Microsoft.Azure.Geneva.GenevaMonitoring",
 *                 Publisher = "Microsoft.Azure.Geneva",
 *                 Settings = null,
 *                 Type = "GenevaMonitoring",
 *                 TypeHandlerVersion = "2.0",
 *             },
 *         },
 *         VmImageOffer = "WindowsServer",
 *         VmImagePublisher = "MicrosoftWindowsServer",
 *         VmImageSku = "2016-Datacenter-Server-Core",
 *         VmImageVersion = "latest",
 *         VmInstanceCount = -1,
 *         VmManagedIdentity = new AzureNative.ServiceFabric.Inputs.VmManagedIdentityArgs
 *         {
 *             UserAssignedIdentities = new[]
 *             {
 *                 "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resRg/providers/Microsoft.ManagedIdentity/userAssignedIdentities/myIdentity",
 *                 "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resRg/providers/Microsoft.ManagedIdentity/userAssignedIdentities/myIdentity2",
 *             },
 *         },
 *         VmSecrets = new[]
 *         {
 *             new AzureNative.ServiceFabric.Inputs.VaultSecretGroupArgs
 *             {
 *                 SourceVault = new AzureNative.ServiceFabric.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resRg/providers/Microsoft.KeyVault/vaults/myVault",
 *                 },
 *                 VaultCertificates = new[]
 *                 {
 *                     new AzureNative.ServiceFabric.Inputs.VaultCertificateArgs
 *                     {
 *                         CertificateStore = "My",
 *                         CertificateUrl = "https://myVault.vault.azure.net:443/secrets/myCert/ef1a31d39e1f46bca33def54b6cda54c",
 *                     },
 *                 },
 *             },
 *         },
 *         VmSize = "Standard_DS3",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/servicefabric/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := servicefabric.NewNodeType(ctx, "nodeType", &servicefabric.NodeTypeArgs{
 * 			Capacities: pulumi.StringMap{
 * 				"ClientConnections": pulumi.String("65536"),
 * 			},
 * 			ClusterName:             pulumi.String("myCluster"),
 * 			DataDiskSizeGB:          pulumi.Int(200),
 * 			DataDiskType:            pulumi.String(servicefabric.DiskType_Premium_LRS),
 * 			IsPrimary:               pulumi.Bool(false),
 * 			IsStateless:             pulumi.Bool(true),
 * 			MultiplePlacementGroups: pulumi.Bool(true),
 * 			NodeTypeName:            pulumi.String("BE"),
 * 			PlacementProperties: pulumi.StringMap{
 * 				"HasSSD":       pulumi.String("true"),
 * 				"NodeColor":    pulumi.String("green"),
 * 				"SomeProperty": pulumi.String("5"),
 * 			},
 * 			ResourceGroupName: pulumi.String("resRg"),
 * 			VmExtensions: servicefabric.VMSSExtensionArray{
 * 				&servicefabric.VMSSExtensionArgs{
 * 					AutoUpgradeMinorVersion: pulumi.Bool(true),
 * 					Name:                    pulumi.String("Microsoft.Azure.Geneva.GenevaMonitoring"),
 * 					Publisher:               pulumi.String("Microsoft.Azure.Geneva"),
 * 					Settings:                pulumi.Any(nil),
 * 					Type:                    pulumi.String("GenevaMonitoring"),
 * 					TypeHandlerVersion:      pulumi.String("2.0"),
 * 				},
 * 			},
 * 			VmImageOffer:     pulumi.String("WindowsServer"),
 * 			VmImagePublisher: pulumi.String("MicrosoftWindowsServer"),
 * 			VmImageSku:       pulumi.String("2016-Datacenter-Server-Core"),
 * 			VmImageVersion:   pulumi.String("latest"),
 * 			VmInstanceCount:  -1,
 * 			VmManagedIdentity: &servicefabric.VmManagedIdentityArgs{
 * 				UserAssignedIdentities: pulumi.StringArray{
 * 					pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resRg/providers/Microsoft.ManagedIdentity/userAssignedIdentities/myIdentity"),
 * 					pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resRg/providers/Microsoft.ManagedIdentity/userAssignedIdentities/myIdentity2"),
 * 				},
 * 			},
 * 			VmSecrets: servicefabric.VaultSecretGroupArray{
 * 				&servicefabric.VaultSecretGroupArgs{
 * 					SourceVault: &servicefabric.SubResourceArgs{
 * 						Id: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resRg/providers/Microsoft.KeyVault/vaults/myVault"),
 * 					},
 * 					VaultCertificates: servicefabric.VaultCertificateArray{
 * 						&servicefabric.VaultCertificateArgs{
 * 							CertificateStore: pulumi.String("My"),
 * 							CertificateUrl:   pulumi.String("https://myVault.vault.azure.net:443/secrets/myCert/ef1a31d39e1f46bca33def54b6cda54c"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			VmSize: pulumi.String("Standard_DS3"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.servicefabric.NodeType;
 * import com.pulumi.azurenative.servicefabric.NodeTypeArgs;
 * import com.pulumi.azurenative.servicefabric.inputs.VMSSExtensionArgs;
 * import com.pulumi.azurenative.servicefabric.inputs.VmManagedIdentityArgs;
 * import com.pulumi.azurenative.servicefabric.inputs.VaultSecretGroupArgs;
 * import com.pulumi.azurenative.servicefabric.inputs.SubResourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var nodeType = new NodeType("nodeType", NodeTypeArgs.builder()
 *             .capacities(Map.of("ClientConnections", "65536"))
 *             .clusterName("myCluster")
 *             .dataDiskSizeGB(200)
 *             .dataDiskType("Premium_LRS")
 *             .isPrimary(false)
 *             .isStateless(true)
 *             .multiplePlacementGroups(true)
 *             .nodeTypeName("BE")
 *             .placementProperties(Map.ofEntries(
 *                 Map.entry("HasSSD", "true"),
 *                 Map.entry("NodeColor", "green"),
 *                 Map.entry("SomeProperty", "5")
 *             ))
 *             .resourceGroupName("resRg")
 *             .vmExtensions(VMSSExtensionArgs.builder()
 *                 .autoUpgradeMinorVersion(true)
 *                 .name("Microsoft.Azure.Geneva.GenevaMonitoring")
 *                 .publisher("Microsoft.Azure.Geneva")
 *                 .settings()
 *                 .type("GenevaMonitoring")
 *                 .typeHandlerVersion("2.0")
 *                 .build())
 *             .vmImageOffer("WindowsServer")
 *             .vmImagePublisher("MicrosoftWindowsServer")
 *             .vmImageSku("2016-Datacenter-Server-Core")
 *             .vmImageVersion("latest")
 *             .vmInstanceCount("TODO: GenUnaryOpExpression")
 *             .vmManagedIdentity(VmManagedIdentityArgs.builder()
 *                 .userAssignedIdentities(
 *                     "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resRg/providers/Microsoft.ManagedIdentity/userAssignedIdentities/myIdentity",
 *                     "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resRg/providers/Microsoft.ManagedIdentity/userAssignedIdentities/myIdentity2")
 *                 .build())
 *             .vmSecrets(VaultSecretGroupArgs.builder()
 *                 .sourceVault(SubResourceArgs.builder()
 *                     .id("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resRg/providers/Microsoft.KeyVault/vaults/myVault")
 *                     .build())
 *                 .vaultCertificates(VaultCertificateArgs.builder()
 *                     .certificateStore("My")
 *                     .certificateUrl("https://myVault.vault.azure.net:443/secrets/myCert/ef1a31d39e1f46bca33def54b6cda54c")
 *                     .build())
 *                 .build())
 *             .vmSize("Standard_DS3")
 *             .build());
 *     }
 * }
 * ```
 * ### Put a node type with maximum parameters
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var nodeType = new AzureNative.ServiceFabric.NodeType("nodeType", new()
 *     {
 *         AdditionalDataDisks = new[]
 *         {
 *             new AzureNative.ServiceFabric.Inputs.VmssDataDiskArgs
 *             {
 *                 DiskLetter = "F",
 *                 DiskSizeGB = 256,
 *                 DiskType = AzureNative.ServiceFabric.DiskType.StandardSSD_LRS,
 *                 Lun = 1,
 *             },
 *             new AzureNative.ServiceFabric.Inputs.VmssDataDiskArgs
 *             {
 *                 DiskLetter = "G",
 *                 DiskSizeGB = 150,
 *                 DiskType = AzureNative.ServiceFabric.DiskType.Premium_LRS,
 *                 Lun = 2,
 *             },
 *         },
 *         Capacities =
 *         {
 *             { "ClientConnections", "65536" },
 *         },
 *         ClusterName = "myCluster",
 *         DataDiskLetter = "S",
 *         DataDiskSizeGB = 200,
 *         DataDiskType = AzureNative.ServiceFabric.DiskType.Premium_LRS,
 *         EnableAcceleratedNetworking = true,
 *         EnableEncryptionAtHost = true,
 *         EnableNodePublicIP = true,
 *         EnableOverProvisioning = false,
 *         EvictionPolicy = AzureNative.ServiceFabric.EvictionPolicyType.Deallocate,
 *         FrontendConfigurations = new[]
 *         {
 *             new AzureNative.ServiceFabric.Inputs.FrontendConfigurationArgs
 *             {
 *                 ApplicationGatewayBackendAddressPoolId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resRg/providers/Microsoft.Network/applicationGateways/appgw-test/backendAddressPools/appgwBepoolTest",
 *                 LoadBalancerBackendAddressPoolId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resRg/providers/Microsoft.Network/loadBalancers/test-LB/backendAddressPools/LoadBalancerBEAddressPool",
 *                 LoadBalancerInboundNatPoolId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resRg/providers/Microsoft.Network/loadBalancers/test-LB/inboundNatPools/LoadBalancerNATPool",
 *             },
 *         },
 *         IsPrimary = false,
 *         IsSpotVM = true,
 *         IsStateless = true,
 *         MultiplePlacementGroups = true,
 *         NatGatewayId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resRg/providers/Microsoft.Network/natGateways/myNatGateway",
 *         NodeTypeName = "BE",
 *         PlacementProperties =
 *         {
 *             { "HasSSD", "true" },
 *             { "NodeColor", "green" },
 *             { "SomeProperty", "5" },
 *         },
 *         ResourceGroupName = "resRg",
 *         SecureBootEnabled = true,
 *         SecurityType = AzureNative.ServiceFabric.SecurityType.TrustedLaunch,
 *         SpotRestoreTimeout = "PT30M",
 *         SubnetId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resRg/providers/Microsoft.Network/virtualNetworks/vnet1/subnets/subnet1",
 *         UseDefaultPublicLoadBalancer = true,
 *         UseEphemeralOSDisk = true,
 *         VmExtensions = new[]
 *         {
 *             new AzureNative.ServiceFabric.Inputs.VMSSExtensionArgs
 *             {
 *                 AutoUpgradeMinorVersion = true,
 *                 EnableAutomaticUpgrade = true,
 *                 ForceUpdateTag = "v.1.0",
 *                 Name = "Microsoft.Azure.Geneva.GenevaMonitoring",
 *                 Publisher = "Microsoft.Azure.Geneva",
 *                 Settings = null,
 *                 Type = "GenevaMonitoring",
 *                 TypeHandlerVersion = "2.0",
 *             },
 *         },
 *         VmImageOffer = "WindowsServer",
 *         VmImagePublisher = "MicrosoftWindowsServer",
 *         VmImageSku = "2016-Datacenter-Server-Core",
 *         VmImageVersion = "latest",
 *         VmInstanceCount = 10,
 *         VmManagedIdentity = new AzureNative.ServiceFabric.Inputs.VmManagedIdentityArgs
 *         {
 *             UserAssignedIdentities = new[]
 *             {
 *                 "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resRg/providers/Microsoft.ManagedIdentity/userAssignedIdentities/myIdentity",
 *                 "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resRg/providers/Microsoft.ManagedIdentity/userAssignedIdentities/myIdentity2",
 *             },
 *         },
 *         VmSecrets = new[]
 *         {
 *             new AzureNative.ServiceFabric.Inputs.VaultSecretGroupArgs
 *             {
 *                 SourceVault = new AzureNative.ServiceFabric.Inputs.SubResourceArgs
 *                 {
 *                     Id = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resRg/providers/Microsoft.KeyVault/vaults/myVault",
 *                 },
 *                 VaultCertificates = new[]
 *                 {
 *                     new AzureNative.ServiceFabric.Inputs.VaultCertificateArgs
 *                     {
 *                         CertificateStore = "My",
 *                         CertificateUrl = "https://myVault.vault.azure.net:443/secrets/myCert/ef1a31d39e1f46bca33def54b6cda54c",
 *                     },
 *                 },
 *             },
 *         },
 *         VmSetupActions = new[]
 *         {
 *             AzureNative.ServiceFabric.VmSetupAction.EnableContainers,
 *             AzureNative.ServiceFabric.VmSetupAction.EnableHyperV,
 *         },
 *         VmSize = "Standard_DS3",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/servicefabric/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := servicefabric.NewNodeType(ctx, "nodeType", &servicefabric.NodeTypeArgs{
 * 			AdditionalDataDisks: servicefabric.VmssDataDiskArray{
 * 				&servicefabric.VmssDataDiskArgs{
 * 					DiskLetter: pulumi.String("F"),
 * 					DiskSizeGB: pulumi.Int(256),
 * 					DiskType:   pulumi.String(servicefabric.DiskType_StandardSSD_LRS),
 * 					Lun:        pulumi.Int(1),
 * 				},
 * 				&servicefabric.VmssDataDiskArgs{
 * 					DiskLetter: pulumi.String("G"),
 * 					DiskSizeGB: pulumi.Int(150),
 * 					DiskType:   pulumi.String(servicefabric.DiskType_Premium_LRS),
 * 					Lun:        pulumi.Int(2),
 * 				},
 * 			},
 * 			Capacities: pulumi.StringMap{
 * 				"ClientConnections": pulumi.String("65536"),
 * 			},
 * 			ClusterName:                 pulumi.String("myCluster"),
 * 			DataDiskLetter:              pulumi.String("S"),
 * 			DataDiskSizeGB:              pulumi.Int(200),
 * 			DataDiskType:                pulumi.String(servicefabric.DiskType_Premium_LRS),
 * 			EnableAcceleratedNetworking: pulumi.Bool(true),
 * 			EnableEncryptionAtHost:      pulumi.Bool(true),
 * 			EnableNodePublicIP:          pulumi.Bool(true),
 * 			EnableOverProvisioning:      pulumi.Bool(false),
 * 			EvictionPolicy:              pulumi.String(servicefabric.EvictionPolicyTypeDeallocate),
 * 			FrontendConfigurations: servicefabric.FrontendConfigurationArray{
 * 				&servicefabric.FrontendConfigurationArgs{
 * 					ApplicationGatewayBackendAddressPoolId: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resRg/providers/Microsoft.Network/applicationGateways/appgw-test/backendAddressPools/appgwBepoolTest"),
 * 					LoadBalancerBackendAddressPoolId:       pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resRg/providers/Microsoft.Network/loadBalancers/test-LB/backendAddressPools/LoadBalancerBEAddressPool"),
 * 					LoadBalancerInboundNatPoolId:           pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resRg/providers/Microsoft.Network/loadBalancers/test-LB/inboundNatPools/LoadBalancerNATPool"),
 * 				},
 * 			},
 * 			IsPrimary:               pulumi.Bool(false),
 * 			IsSpotVM:                pulumi.Bool(true),
 * 			IsStateless:             pulumi.Bool(true),
 * 			MultiplePlacementGroups: pulumi.Bool(true),
 * 			NatGatewayId:            pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resRg/providers/Microsoft.Network/natGateways/myNatGateway"),
 * 			NodeTypeName:            pulumi.String("BE"),
 * 			PlacementProperties: pulumi.StringMap{
 * 				"HasSSD":       pulumi.String("true"),
 * 				"NodeColor":    pulumi.String("green"),
 * 				"SomeProperty": pulumi.String("5"),
 * 			},
 * 			ResourceGroupName:            pulumi.String("resRg"),
 * 			SecureBootEnabled:            pulumi.Bool(true),
 * 			SecurityType:                 pulumi.String(servicefabric.SecurityTypeTrustedLaunch),
 * 			SpotRestoreTimeout:           pulumi.String("PT30M"),
 * 			SubnetId:                     pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resRg/providers/Microsoft.Network/virtualNetworks/vnet1/subnets/subnet1"),
 * 			UseDefaultPublicLoadBalancer: pulumi.Bool(true),
 * 			UseEphemeralOSDisk:           pulumi.Bool(true),
 * 			VmExtensions: servicefabric.VMSSExtensionArray{
 * 				&servicefabric.VMSSExtensionArgs{
 * 					AutoUpgradeMinorVersion: pulumi.Bool(true),
 * 					EnableAutomaticUpgrade:  pulumi.Bool(true),
 * 					ForceUpdateTag:          pulumi.String("v.1.0"),
 * 					Name:                    pulumi.String("Microsoft.Azure.Geneva.GenevaMonitoring"),
 * 					Publisher:               pulumi.String("Microsoft.Azure.Geneva"),
 * 					Settings:                pulumi.Any(nil),
 * 					Type:                    pulumi.String("GenevaMonitoring"),
 * 					TypeHandlerVersion:      pulumi.String("2.0"),
 * 				},
 * 			},
 * 			VmImageOffer:     pulumi.String("WindowsServer"),
 * 			VmImagePublisher: pulumi.String("MicrosoftWindowsServer"),
 * 			VmImageSku:       pulumi.String("2016-Datacenter-Server-Core"),
 * 			VmImageVersion:   pulumi.String("latest"),
 * 			VmInstanceCount:  pulumi.Int(10),
 * 			VmManagedIdentity: &servicefabric.VmManagedIdentityArgs{
 * 				UserAssignedIdentities: pulumi.StringArray{
 * 					pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resRg/providers/Microsoft.ManagedIdentity/userAssignedIdentities/myIdentity"),
 * 					pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resRg/providers/Microsoft.ManagedIdentity/userAssignedIdentities/myIdentity2"),
 * 				},
 * 			},
 * 			VmSecrets: servicefabric.VaultSecretGroupArray{
 * 				&servicefabric.VaultSecretGroupArgs{
 * 					SourceVault: &servicefabric.SubResourceArgs{
 * 						Id: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resRg/providers/Microsoft.KeyVault/vaults/myVault"),
 * 					},
 * 					VaultCertificates: servicefabric.VaultCertificateArray{
 * 						&servicefabric.VaultCertificateArgs{
 * 							CertificateStore: pulumi.String("My"),
 * 							CertificateUrl:   pulumi.String("https://myVault.vault.azure.net:443/secrets/myCert/ef1a31d39e1f46bca33def54b6cda54c"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			VmSetupActions: pulumi.StringArray{
 * 				pulumi.String(servicefabric.VmSetupActionEnableContainers),
 * 				pulumi.String(servicefabric.VmSetupActionEnableHyperV),
 * 			},
 * 			VmSize: pulumi.String("Standard_DS3"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.servicefabric.NodeType;
 * import com.pulumi.azurenative.servicefabric.NodeTypeArgs;
 * import com.pulumi.azurenative.servicefabric.inputs.VmssDataDiskArgs;
 * import com.pulumi.azurenative.servicefabric.inputs.FrontendConfigurationArgs;
 * import com.pulumi.azurenative.servicefabric.inputs.VMSSExtensionArgs;
 * import com.pulumi.azurenative.servicefabric.inputs.VmManagedIdentityArgs;
 * import com.pulumi.azurenative.servicefabric.inputs.VaultSecretGroupArgs;
 * import com.pulumi.azurenative.servicefabric.inputs.SubResourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var nodeType = new NodeType("nodeType", NodeTypeArgs.builder()
 *             .additionalDataDisks(
 *                 VmssDataDiskArgs.builder()
 *                     .diskLetter("F")
 *                     .diskSizeGB(256)
 *                     .diskType("StandardSSD_LRS")
 *                     .lun(1)
 *                     .build(),
 *                 VmssDataDiskArgs.builder()
 *                     .diskLetter("G")
 *                     .diskSizeGB(150)
 *                     .diskType("Premium_LRS")
 *                     .lun(2)
 *                     .build())
 *             .capacities(Map.of("ClientConnections", "65536"))
 *             .clusterName("myCluster")
 *             .dataDiskLetter("S")
 *             .dataDiskSizeGB(200)
 *             .dataDiskType("Premium_LRS")
 *             .enableAcceleratedNetworking(true)
 *             .enableEncryptionAtHost(true)
 *             .enableNodePublicIP(true)
 *             .enableOverProvisioning(false)
 *             .evictionPolicy("Deallocate")
 *             .frontendConfigurations(FrontendConfigurationArgs.builder()
 *                 .applicationGatewayBackendAddressPoolId("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resRg/providers/Microsoft.Network/applicationGateways/appgw-test/backendAddressPools/appgwBepoolTest")
 *                 .loadBalancerBackendAddressPoolId("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resRg/providers/Microsoft.Network/loadBalancers/test-LB/backendAddressPools/LoadBalancerBEAddressPool")
 *                 .loadBalancerInboundNatPoolId("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resRg/providers/Microsoft.Network/loadBalancers/test-LB/inboundNatPools/LoadBalancerNATPool")
 *                 .build())
 *             .isPrimary(false)
 *             .isSpotVM(true)
 *             .isStateless(true)
 *             .multiplePlacementGroups(true)
 *             .natGatewayId("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resRg/providers/Microsoft.Network/natGateways/myNatGateway")
 *             .nodeTypeName("BE")
 *             .placementProperties(Map.ofEntries(
 *                 Map.entry("HasSSD", "true"),
 *                 Map.entry("NodeColor", "green"),
 *                 Map.entry("SomeProperty", "5")
 *             ))
 *             .resourceGroupName("resRg")
 *             .secureBootEnabled(true)
 *             .securityType("TrustedLaunch")
 *             .spotRestoreTimeout("PT30M")
 *             .subnetId("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resRg/providers/Microsoft.Network/virtualNetworks/vnet1/subnets/subnet1")
 *             .useDefaultPublicLoadBalancer(true)
 *             .useEphemeralOSDisk(true)
 *             .vmExtensions(VMSSExtensionArgs.builder()
 *                 .autoUpgradeMinorVersion(true)
 *                 .enableAutomaticUpgrade(true)
 *                 .forceUpdateTag("v.1.0")
 *                 .name("Microsoft.Azure.Geneva.GenevaMonitoring")
 *                 .publisher("Microsoft.Azure.Geneva")
 *                 .settings()
 *                 .type("GenevaMonitoring")
 *                 .typeHandlerVersion("2.0")
 *                 .build())
 *             .vmImageOffer("WindowsServer")
 *             .vmImagePublisher("MicrosoftWindowsServer")
 *             .vmImageSku("2016-Datacenter-Server-Core")
 *             .vmImageVersion("latest")
 *             .vmInstanceCount(10)
 *             .vmManagedIdentity(VmManagedIdentityArgs.builder()
 *                 .userAssignedIdentities(
 *                     "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resRg/providers/Microsoft.ManagedIdentity/userAssignedIdentities/myIdentity",
 *                     "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resRg/providers/Microsoft.ManagedIdentity/userAssignedIdentities/myIdentity2")
 *                 .build())
 *             .vmSecrets(VaultSecretGroupArgs.builder()
 *                 .sourceVault(SubResourceArgs.builder()
 *                     .id("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/resRg/providers/Microsoft.KeyVault/vaults/myVault")
 *                     .build())
 *                 .vaultCertificates(VaultCertificateArgs.builder()
 *                     .certificateStore("My")
 *                     .certificateUrl("https://myVault.vault.azure.net:443/secrets/myCert/ef1a31d39e1f46bca33def54b6cda54c")
 *                     .build())
 *                 .build())
 *             .vmSetupActions(
 *                 "EnableContainers",
 *                 "EnableHyperV")
 *             .vmSize("Standard_DS3")
 *             .build());
 *     }
 * }
 * ```
 * ### Put a node type with minimum parameters
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var nodeType = new AzureNative.ServiceFabric.NodeType("nodeType", new()
 *     {
 *         ClusterName = "myCluster",
 *         DataDiskSizeGB = 200,
 *         IsPrimary = false,
 *         NodeTypeName = "BE",
 *         ResourceGroupName = "resRg",
 *         VmImageOffer = "WindowsServer",
 *         VmImagePublisher = "MicrosoftWindowsServer",
 *         VmImageSku = "2016-Datacenter-Server-Core",
 *         VmImageVersion = "latest",
 *         VmInstanceCount = 10,
 *         VmSize = "Standard_D3",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/servicefabric/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := servicefabric.NewNodeType(ctx, "nodeType", &servicefabric.NodeTypeArgs{
 * 			ClusterName:       pulumi.String("myCluster"),
 * 			DataDiskSizeGB:    pulumi.Int(200),
 * 			IsPrimary:         pulumi.Bool(false),
 * 			NodeTypeName:      pulumi.String("BE"),
 * 			ResourceGroupName: pulumi.String("resRg"),
 * 			VmImageOffer:      pulumi.String("WindowsServer"),
 * 			VmImagePublisher:  pulumi.String("MicrosoftWindowsServer"),
 * 			VmImageSku:        pulumi.String("2016-Datacenter-Server-Core"),
 * 			VmImageVersion:    pulumi.String("latest"),
 * 			VmInstanceCount:   pulumi.Int(10),
 * 			VmSize:            pulumi.String("Standard_D3"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.servicefabric.NodeType;
 * import com.pulumi.azurenative.servicefabric.NodeTypeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var nodeType = new NodeType("nodeType", NodeTypeArgs.builder()
 *             .clusterName("myCluster")
 *             .dataDiskSizeGB(200)
 *             .isPrimary(false)
 *             .nodeTypeName("BE")
 *             .resourceGroupName("resRg")
 *             .vmImageOffer("WindowsServer")
 *             .vmImagePublisher("MicrosoftWindowsServer")
 *             .vmImageSku("2016-Datacenter-Server-Core")
 *             .vmImageVersion("latest")
 *             .vmInstanceCount(10)
 *             .vmSize("Standard_D3")
 *             .build());
 *     }
 * }
 * ```
 * ### Put an stateless node type with temporary disk for service fabric
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var nodeType = new AzureNative.ServiceFabric.NodeType("nodeType", new()
 *     {
 *         ClusterName = "myCluster",
 *         EnableEncryptionAtHost = true,
 *         IsPrimary = false,
 *         IsStateless = true,
 *         MultiplePlacementGroups = true,
 *         NodeTypeName = "BE",
 *         ResourceGroupName = "resRg",
 *         UseTempDataDisk = true,
 *         VmExtensions = new[]
 *         {
 *             new AzureNative.ServiceFabric.Inputs.VMSSExtensionArgs
 *             {
 *                 AutoUpgradeMinorVersion = true,
 *                 Name = "Microsoft.Azure.Geneva.GenevaMonitoring",
 *                 Publisher = "Microsoft.Azure.Geneva",
 *                 Settings = null,
 *                 Type = "GenevaMonitoring",
 *                 TypeHandlerVersion = "2.0",
 *             },
 *         },
 *         VmImageOffer = "WindowsServer",
 *         VmImagePublisher = "MicrosoftWindowsServer",
 *         VmImageSku = "2016-Datacenter-Server-Core",
 *         VmImageVersion = "latest",
 *         VmInstanceCount = 10,
 *         VmSize = "Standard_DS3",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/servicefabric/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := servicefabric.NewNodeType(ctx, "nodeType", &servicefabric.NodeTypeArgs{
 * 			ClusterName:             pulumi.String("myCluster"),
 * 			EnableEncryptionAtHost:  pulumi.Bool(true),
 * 			IsPrimary:               pulumi.Bool(false),
 * 			IsStateless:             pulumi.Bool(true),
 * 			MultiplePlacementGroups: pulumi.Bool(true),
 * 			NodeTypeName:            pulumi.String("BE"),
 * 			ResourceGroupName:       pulumi.String("resRg"),
 * 			UseTempDataDisk:         pulumi.Bool(true),
 * 			VmExtensions: servicefabric.VMSSExtensionArray{
 * 				&servicefabric.VMSSExtensionArgs{
 * 					AutoUpgradeMinorVersion: pulumi.Bool(true),
 * 					Name:                    pulumi.String("Microsoft.Azure.Geneva.GenevaMonitoring"),
 * 					Publisher:               pulumi.String("Microsoft.Azure.Geneva"),
 * 					Settings:                pulumi.Any(nil),
 * 					Type:                    pulumi.String("GenevaMonitoring"),
 * 					TypeHandlerVersion:      pulumi.String("2.0"),
 * 				},
 * 			},
 * 			VmImageOffer:     pulumi.String("WindowsServer"),
 * 			VmImagePublisher: pulumi.String("MicrosoftWindowsServer"),
 * 			VmImageSku:       pulumi.String("2016-Datacenter-Server-Core"),
 * 			VmImageVersion:   pulumi.String("latest"),
 * 			VmInstanceCount:  pulumi.Int(10),
 * 			VmSize:           pulumi.String("Standard_DS3"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.servicefabric.NodeType;
 * import com.pulumi.azurenative.servicefabric.NodeTypeArgs;
 * import com.pulumi.azurenative.servicefabric.inputs.VMSSExtensionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var nodeType = new NodeType("nodeType", NodeTypeArgs.builder()
 *             .clusterName("myCluster")
 *             .enableEncryptionAtHost(true)
 *             .isPrimary(false)
 *             .isStateless(true)
 *             .multiplePlacementGroups(true)
 *             .nodeTypeName("BE")
 *             .resourceGroupName("resRg")
 *             .useTempDataDisk(true)
 *             .vmExtensions(VMSSExtensionArgs.builder()
 *                 .autoUpgradeMinorVersion(true)
 *                 .name("Microsoft.Azure.Geneva.GenevaMonitoring")
 *                 .publisher("Microsoft.Azure.Geneva")
 *                 .settings()
 *                 .type("GenevaMonitoring")
 *                 .typeHandlerVersion("2.0")
 *                 .build())
 *             .vmImageOffer("WindowsServer")
 *             .vmImagePublisher("MicrosoftWindowsServer")
 *             .vmImageSku("2016-Datacenter-Server-Core")
 *             .vmImageVersion("latest")
 *             .vmInstanceCount(10)
 *             .vmSize("Standard_DS3")
 *             .build());
 *     }
 * }
 * ```
 * ### Put node type with custom vm image
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var nodeType = new AzureNative.ServiceFabric.NodeType("nodeType", new()
 *     {
 *         ClusterName = "myCluster",
 *         DataDiskSizeGB = 200,
 *         IsPrimary = false,
 *         NodeTypeName = "BE",
 *         ResourceGroupName = "resRg",
 *         VmImageResourceId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/test-custom-image/providers/Microsoft.Compute/galleries/myCustomImages/images/Win2019DC",
 *         VmInstanceCount = 10,
 *         VmSize = "Standard_D3",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/servicefabric/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := servicefabric.NewNodeType(ctx, "nodeType", &servicefabric.NodeTypeArgs{
 * 			ClusterName:       pulumi.String("myCluster"),
 * 			DataDiskSizeGB:    pulumi.Int(200),
 * 			IsPrimary:         pulumi.Bool(false),
 * 			NodeTypeName:      pulumi.String("BE"),
 * 			ResourceGroupName: pulumi.String("resRg"),
 * 			VmImageResourceId: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/test-custom-image/providers/Microsoft.Compute/galleries/myCustomImages/images/Win2019DC"),
 * 			VmInstanceCount:   pulumi.Int(10),
 * 			VmSize:            pulumi.String("Standard_D3"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.servicefabric.NodeType;
 * import com.pulumi.azurenative.servicefabric.NodeTypeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var nodeType = new NodeType("nodeType", NodeTypeArgs.builder()
 *             .clusterName("myCluster")
 *             .dataDiskSizeGB(200)
 *             .isPrimary(false)
 *             .nodeTypeName("BE")
 *             .resourceGroupName("resRg")
 *             .vmImageResourceId("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/test-custom-image/providers/Microsoft.Compute/galleries/myCustomImages/images/Win2019DC")
 *             .vmInstanceCount(10)
 *             .vmSize("Standard_D3")
 *             .build());
 *     }
 * }
 * ```
 * ### Put node type with dedicated hosts
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var nodeType = new AzureNative.ServiceFabric.NodeType("nodeType", new()
 *     {
 *         Capacities = null,
 *         ClusterName = "myCluster",
 *         DataDiskSizeGB = 200,
 *         DataDiskType = AzureNative.ServiceFabric.DiskType.StandardSSD_LRS,
 *         HostGroupId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/testhostgroupRG/providers/Microsoft.Compute/hostGroups/testHostGroup",
 *         IsPrimary = false,
 *         NodeTypeName = "BE",
 *         PlacementProperties = null,
 *         ResourceGroupName = "resRg",
 *         VmImageOffer = "WindowsServer",
 *         VmImagePublisher = "MicrosoftWindowsServer",
 *         VmImageSku = "2019-Datacenter",
 *         VmImageVersion = "latest",
 *         VmInstanceCount = 10,
 *         VmSize = "Standard_D8s_v3",
 *         Zones = new[]
 *         {
 *             "1",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/servicefabric/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := servicefabric.NewNodeType(ctx, "nodeType", &servicefabric.NodeTypeArgs{
 * 			Capacities:          nil,
 * 			ClusterName:         pulumi.String("myCluster"),
 * 			DataDiskSizeGB:      pulumi.Int(200),
 * 			DataDiskType:        pulumi.String(servicefabric.DiskType_StandardSSD_LRS),
 * 			HostGroupId:         pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/testhostgroupRG/providers/Microsoft.Compute/hostGroups/testHostGroup"),
 * 			IsPrimary:           pulumi.Bool(false),
 * 			NodeTypeName:        pulumi.String("BE"),
 * 			PlacementProperties: nil,
 * 			ResourceGroupName:   pulumi.String("resRg"),
 * 			VmImageOffer:        pulumi.String("WindowsServer"),
 * 			VmImagePublisher:    pulumi.String("MicrosoftWindowsServer"),
 * 			VmImageSku:          pulumi.String("2019-Datacenter"),
 * 			VmImageVersion:      pulumi.String("latest"),
 * 			VmInstanceCount:     pulumi.Int(10),
 * 			VmSize:              pulumi.String("Standard_D8s_v3"),
 * 			Zones: pulumi.StringArray{
 * 				pulumi.String("1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.servicefabric.NodeType;
 * import com.pulumi.azurenative.servicefabric.NodeTypeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var nodeType = new NodeType("nodeType", NodeTypeArgs.builder()
 *             .capacities()
 *             .clusterName("myCluster")
 *             .dataDiskSizeGB(200)
 *             .dataDiskType("StandardSSD_LRS")
 *             .hostGroupId("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/testhostgroupRG/providers/Microsoft.Compute/hostGroups/testHostGroup")
 *             .isPrimary(false)
 *             .nodeTypeName("BE")
 *             .placementProperties()
 *             .resourceGroupName("resRg")
 *             .vmImageOffer("WindowsServer")
 *             .vmImagePublisher("MicrosoftWindowsServer")
 *             .vmImageSku("2019-Datacenter")
 *             .vmImageVersion("latest")
 *             .vmInstanceCount(10)
 *             .vmSize("Standard_D8s_v3")
 *             .zones("1")
 *             .build());
 *     }
 * }
 * ```
 * ### Put node type with shared galleries custom vm image
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var nodeType = new AzureNative.ServiceFabric.NodeType("nodeType", new()
 *     {
 *         ClusterName = "myCluster",
 *         DataDiskSizeGB = 200,
 *         IsPrimary = false,
 *         NodeTypeName = "BE",
 *         ResourceGroupName = "resRg",
 *         VmInstanceCount = 10,
 *         VmSharedGalleryImageId = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/test-custom-image/providers/Microsoft.Compute/sharedGalleries/35349201-a0b3-405e-8a23-9f1450984307-SFSHAREDGALLERY/images/TestNoProdContainerDImage/versions/latest",
 *         VmSize = "Standard_D3",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/servicefabric/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := servicefabric.NewNodeType(ctx, "nodeType", &servicefabric.NodeTypeArgs{
 * 			ClusterName:            pulumi.String("myCluster"),
 * 			DataDiskSizeGB:         pulumi.Int(200),
 * 			IsPrimary:              pulumi.Bool(false),
 * 			NodeTypeName:           pulumi.String("BE"),
 * 			ResourceGroupName:      pulumi.String("resRg"),
 * 			VmInstanceCount:        pulumi.Int(10),
 * 			VmSharedGalleryImageId: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/test-custom-image/providers/Microsoft.Compute/sharedGalleries/35349201-a0b3-405e-8a23-9f1450984307-SFSHAREDGALLERY/images/TestNoProdContainerDImage/versions/latest"),
 * 			VmSize:                 pulumi.String("Standard_D3"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.servicefabric.NodeType;
 * import com.pulumi.azurenative.servicefabric.NodeTypeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var nodeType = new NodeType("nodeType", NodeTypeArgs.builder()
 *             .clusterName("myCluster")
 *             .dataDiskSizeGB(200)
 *             .isPrimary(false)
 *             .nodeTypeName("BE")
 *             .resourceGroupName("resRg")
 *             .vmInstanceCount(10)
 *             .vmSharedGalleryImageId("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/test-custom-image/providers/Microsoft.Compute/sharedGalleries/35349201-a0b3-405e-8a23-9f1450984307-SFSHAREDGALLERY/images/TestNoProdContainerDImage/versions/latest")
 *             .vmSize("Standard_D3")
 *             .build());
 *     }
 * }
 * ```
 * ### Put node type with vm image plan
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var nodeType = new AzureNative.ServiceFabric.NodeType("nodeType", new()
 *     {
 *         ClusterName = "myCluster",
 *         DataDiskSizeGB = 200,
 *         IsPrimary = false,
 *         NodeTypeName = "BE",
 *         ResourceGroupName = "resRg",
 *         VmImageOffer = "windows_2022_test",
 *         VmImagePlan = new AzureNative.ServiceFabric.Inputs.VmImagePlanArgs
 *         {
 *             Name = "win_2022_test_20_10_gen2",
 *             Product = "windows_2022_test",
 *             Publisher = "testpublisher",
 *         },
 *         VmImagePublisher = "testpublisher",
 *         VmImageSku = "win_2022_test_20_10_gen2",
 *         VmImageVersion = "latest",
 *         VmInstanceCount = 10,
 *         VmSize = "Standard_D3",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/servicefabric/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := servicefabric.NewNodeType(ctx, "nodeType", &servicefabric.NodeTypeArgs{
 * 			ClusterName:       pulumi.String("myCluster"),
 * 			DataDiskSizeGB:    pulumi.Int(200),
 * 			IsPrimary:         pulumi.Bool(false),
 * 			NodeTypeName:      pulumi.String("BE"),
 * 			ResourceGroupName: pulumi.String("resRg"),
 * 			VmImageOffer:      pulumi.String("windows_2022_test"),
 * 			VmImagePlan: &servicefabric.VmImagePlanArgs{
 * 				Name:      pulumi.String("win_2022_test_20_10_gen2"),
 * 				Product:   pulumi.String("windows_2022_test"),
 * 				Publisher: pulumi.String("testpublisher"),
 * 			},
 * 			VmImagePublisher: pulumi.String("testpublisher"),
 * 			VmImageSku:       pulumi.String("win_2022_test_20_10_gen2"),
 * 			VmImageVersion:   pulumi.String("latest"),
 * 			VmInstanceCount:  pulumi.Int(10),
 * 			VmSize:           pulumi.String("Standard_D3"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.servicefabric.NodeType;
 * import com.pulumi.azurenative.servicefabric.NodeTypeArgs;
 * import com.pulumi.azurenative.servicefabric.inputs.VmImagePlanArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var nodeType = new NodeType("nodeType", NodeTypeArgs.builder()
 *             .clusterName("myCluster")
 *             .dataDiskSizeGB(200)
 *             .isPrimary(false)
 *             .nodeTypeName("BE")
 *             .resourceGroupName("resRg")
 *             .vmImageOffer("windows_2022_test")
 *             .vmImagePlan(VmImagePlanArgs.builder()
 *                 .name("win_2022_test_20_10_gen2")
 *                 .product("windows_2022_test")
 *                 .publisher("testpublisher")
 *                 .build())
 *             .vmImagePublisher("testpublisher")
 *             .vmImageSku("win_2022_test_20_10_gen2")
 *             .vmImageVersion("latest")
 *             .vmInstanceCount(10)
 *             .vmSize("Standard_D3")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:servicefabric:NodeType BE /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceFabric/managedClusters/{clusterName}/nodeTypes/{nodeTypeName}
 * ```
 * @property additionalDataDisks Additional managed data disks.
 * @property applicationPorts The range of ports from which cluster assigned port to Service Fabric applications.
 * @property capacities The capacity tags applied to the nodes in the node type, the cluster resource manager uses these tags to understand how much resource a node has.
 * @property clusterName The name of the cluster resource.
 * @property dataDiskLetter Managed data disk letter. It can not use the reserved letter C or D and it can not change after created.
 * @property dataDiskSizeGB Disk size for the managed disk attached to the vms on the node type in GBs.
 * @property dataDiskType Managed data disk type. Specifies the storage account type for the managed disk
 * @property enableAcceleratedNetworking Specifies whether the network interface is accelerated networking-enabled.
 * @property enableEncryptionAtHost Enable or disable the Host Encryption for the virtual machines on the node type. This will enable the encryption for all the disks including Resource/Temp disk at host itself. Default: The Encryption at host will be disabled unless this property is set to true for the resource.
 * @property enableNodePublicIP Specifies whether each node is allocated its own public IP address. This is only supported on secondary node types with custom Load Balancers.
 * @property enableOverProvisioning Specifies whether the node type should be overprovisioned. It is only allowed for stateless node types.
 * @property ephemeralPorts The range of ephemeral ports that nodes in this node type should be configured with.
 * @property evictionPolicy Specifies the eviction policy for virtual machines in a SPOT node type. Default is Delete.
 * @property frontendConfigurations Indicates the node type uses its own frontend configurations instead of the default one for the cluster. This setting can only be specified for non-primary node types and can not be added or removed after the node type is created.
 * @property hostGroupId Specifies the full host group resource Id. This property is used for deploying on azure dedicated hosts.
 * @property isPrimary Indicates the Service Fabric system services for the cluster will run on this node type. This setting cannot be changed once the node type is created.
 * @property isSpotVM Indicates whether the node type will be Spot Virtual Machines. Azure will allocate the VMs if there is capacity available and the VMs can be evicted at any time.
 * @property isStateless Indicates if the node type can only host Stateless workloads.
 * @property multiplePlacementGroups Indicates if scale set associated with the node type can be composed of multiple placement groups.
 * @property natGatewayId Specifies the resource id of a NAT Gateway to attach to the subnet of this node type. Node type must use custom load balancer.
 * @property networkSecurityRules The Network Security Rules for this node type. This setting can only be specified for node types that are configured with frontend configurations.
 * @property nodeTypeName The name of the node type.
 * @property placementProperties The placement tags applied to nodes in the node type, which can be used to indicate where certain services (workload) should run.
 * @property resourceGroupName The name of the resource group.
 * @property secureBootEnabled Specifies whether secure boot should be enabled on the nodeType. Can only be used with TrustedLaunch SecurityType
 * @property securityType Specifies the security type of the nodeType. Only TrustedLaunch is currently supported
 * @property sku The node type sku.
 * @property spotRestoreTimeout Indicates the time duration after which the platform will not try to restore the VMSS SPOT instances specified as ISO 8601.
 * @property subnetId Indicates the resource id of the subnet for the node type.
 * @property tags Azure resource tags.
 * @property useDefaultPublicLoadBalancer Specifies whether the use public load balancer. If not specified and the node type doesn't have its own frontend configuration, it will be attached to the default load balancer. If the node type uses its own Load balancer and useDefaultPublicLoadBalancer is true, then the frontend has to be an Internal Load Balancer. If the node type uses its own Load balancer and useDefaultPublicLoadBalancer is false or not set, then the custom load balancer must include a public load balancer to provide outbound connectivity.
 * @property useEphemeralOSDisk Indicates whether to use ephemeral os disk. The sku selected on the vmSize property needs to support this feature.
 * @property useTempDataDisk Specifies whether to use the temporary disk for the service fabric data root, in which case no managed data disk will be attached and the temporary disk will be used. It is only allowed for stateless node types.
 * @property vmExtensions Set of extensions that should be installed onto the virtual machines.
 * @property vmImageOffer The offer type of the Azure Virtual Machines Marketplace image. For example, UbuntuServer or WindowsServer.
 * @property vmImagePlan Specifies information about the marketplace image used to create the virtual machine. This element is only used for marketplace images. Before you can use a marketplace image from an API, you must enable the image for programmatic use. In the Azure portal, find the marketplace image that you want to use and then click Want to deploy programmatically, Get Started ->. Enter any required information and then click Save.
 * @property vmImagePublisher The publisher of the Azure Virtual Machines Marketplace image. For example, Canonical or MicrosoftWindowsServer.
 * @property vmImageResourceId Indicates the resource id of the vm image. This parameter is used for custom vm image.
 * @property vmImageSku The SKU of the Azure Virtual Machines Marketplace image. For example, 14.04.0-LTS or 2012-R2-Datacenter.
 * @property vmImageVersion The version of the Azure Virtual Machines Marketplace image. A value of 'latest' can be specified to select the latest version of an image. If omitted, the default is 'latest'.
 * @property vmInstanceCount The number of nodes in the node type. <br /><br />**Values:** <br />-1 - Use when auto scale rules are configured or sku.capacity is defined <br /> 0 - Not supported <br /> >0 - Use for manual scale.
 * @property vmManagedIdentity Identities to assign to the virtual machine scale set under the node type.
 * @property vmSecrets The secrets to install in the virtual machines.
 * @property vmSetupActions Specifies the actions to be performed on the vms before bootstrapping the service fabric runtime.
 * @property vmSharedGalleryImageId Indicates the resource id of the vm shared galleries image. This parameter is used for custom vm image.
 * @property vmSize The size of virtual machines in the pool. All virtual machines in a pool are the same size. For example, Standard_D3.
 * @property zones Specifies the availability zones where the node type would span across. If the cluster is not spanning across availability zones, initiates az migration for the cluster.
 */
public data class NodeTypeArgs(
    public val additionalDataDisks: Output<List<VmssDataDiskArgs>>? = null,
    public val applicationPorts: Output<EndpointRangeDescriptionArgs>? = null,
    public val capacities: Output<Map<String, String>>? = null,
    public val clusterName: Output<String>? = null,
    public val dataDiskLetter: Output<String>? = null,
    public val dataDiskSizeGB: Output<Int>? = null,
    public val dataDiskType: Output<Either<String, DiskType>>? = null,
    public val enableAcceleratedNetworking: Output<Boolean>? = null,
    public val enableEncryptionAtHost: Output<Boolean>? = null,
    public val enableNodePublicIP: Output<Boolean>? = null,
    public val enableOverProvisioning: Output<Boolean>? = null,
    public val ephemeralPorts: Output<EndpointRangeDescriptionArgs>? = null,
    public val evictionPolicy: Output<Either<String, EvictionPolicyType>>? = null,
    public val frontendConfigurations: Output<List<FrontendConfigurationArgs>>? = null,
    public val hostGroupId: Output<String>? = null,
    public val isPrimary: Output<Boolean>? = null,
    public val isSpotVM: Output<Boolean>? = null,
    public val isStateless: Output<Boolean>? = null,
    public val multiplePlacementGroups: Output<Boolean>? = null,
    public val natGatewayId: Output<String>? = null,
    public val networkSecurityRules: Output<List<NetworkSecurityRuleArgs>>? = null,
    public val nodeTypeName: Output<String>? = null,
    public val placementProperties: Output<Map<String, String>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val secureBootEnabled: Output<Boolean>? = null,
    public val securityType: Output<Either<String, SecurityType>>? = null,
    public val sku: Output<NodeTypeSkuArgs>? = null,
    public val spotRestoreTimeout: Output<String>? = null,
    public val subnetId: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val useDefaultPublicLoadBalancer: Output<Boolean>? = null,
    public val useEphemeralOSDisk: Output<Boolean>? = null,
    public val useTempDataDisk: Output<Boolean>? = null,
    public val vmExtensions: Output<List<VMSSExtensionArgs>>? = null,
    public val vmImageOffer: Output<String>? = null,
    public val vmImagePlan: Output<VmImagePlanArgs>? = null,
    public val vmImagePublisher: Output<String>? = null,
    public val vmImageResourceId: Output<String>? = null,
    public val vmImageSku: Output<String>? = null,
    public val vmImageVersion: Output<String>? = null,
    public val vmInstanceCount: Output<Int>? = null,
    public val vmManagedIdentity: Output<VmManagedIdentityArgs>? = null,
    public val vmSecrets: Output<List<VaultSecretGroupArgs>>? = null,
    public val vmSetupActions: Output<List<Either<String, VmSetupAction>>>? = null,
    public val vmSharedGalleryImageId: Output<String>? = null,
    public val vmSize: Output<String>? = null,
    public val zones: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.servicefabric.NodeTypeArgs> {
    override fun toJava(): com.pulumi.azurenative.servicefabric.NodeTypeArgs =
        com.pulumi.azurenative.servicefabric.NodeTypeArgs.builder()
            .additionalDataDisks(
                additionalDataDisks?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .applicationPorts(applicationPorts?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .capacities(
                capacities?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .clusterName(clusterName?.applyValue({ args0 -> args0 }))
            .dataDiskLetter(dataDiskLetter?.applyValue({ args0 -> args0 }))
            .dataDiskSizeGB(dataDiskSizeGB?.applyValue({ args0 -> args0 }))
            .dataDiskType(
                dataDiskType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .enableAcceleratedNetworking(enableAcceleratedNetworking?.applyValue({ args0 -> args0 }))
            .enableEncryptionAtHost(enableEncryptionAtHost?.applyValue({ args0 -> args0 }))
            .enableNodePublicIP(enableNodePublicIP?.applyValue({ args0 -> args0 }))
            .enableOverProvisioning(enableOverProvisioning?.applyValue({ args0 -> args0 }))
            .ephemeralPorts(ephemeralPorts?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .evictionPolicy(
                evictionPolicy?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .frontendConfigurations(
                frontendConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .hostGroupId(hostGroupId?.applyValue({ args0 -> args0 }))
            .isPrimary(isPrimary?.applyValue({ args0 -> args0 }))
            .isSpotVM(isSpotVM?.applyValue({ args0 -> args0 }))
            .isStateless(isStateless?.applyValue({ args0 -> args0 }))
            .multiplePlacementGroups(multiplePlacementGroups?.applyValue({ args0 -> args0 }))
            .natGatewayId(natGatewayId?.applyValue({ args0 -> args0 }))
            .networkSecurityRules(
                networkSecurityRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .nodeTypeName(nodeTypeName?.applyValue({ args0 -> args0 }))
            .placementProperties(
                placementProperties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .secureBootEnabled(secureBootEnabled?.applyValue({ args0 -> args0 }))
            .securityType(
                securityType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .sku(sku?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .spotRestoreTimeout(spotRestoreTimeout?.applyValue({ args0 -> args0 }))
            .subnetId(subnetId?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .useDefaultPublicLoadBalancer(useDefaultPublicLoadBalancer?.applyValue({ args0 -> args0 }))
            .useEphemeralOSDisk(useEphemeralOSDisk?.applyValue({ args0 -> args0 }))
            .useTempDataDisk(useTempDataDisk?.applyValue({ args0 -> args0 }))
            .vmExtensions(
                vmExtensions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .vmImageOffer(vmImageOffer?.applyValue({ args0 -> args0 }))
            .vmImagePlan(vmImagePlan?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .vmImagePublisher(vmImagePublisher?.applyValue({ args0 -> args0 }))
            .vmImageResourceId(vmImageResourceId?.applyValue({ args0 -> args0 }))
            .vmImageSku(vmImageSku?.applyValue({ args0 -> args0 }))
            .vmImageVersion(vmImageVersion?.applyValue({ args0 -> args0 }))
            .vmInstanceCount(vmInstanceCount?.applyValue({ args0 -> args0 }))
            .vmManagedIdentity(vmManagedIdentity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .vmSecrets(
                vmSecrets?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .vmSetupActions(
                vmSetupActions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.transform({ args0 ->
                            args0
                        }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                    })
                }),
            )
            .vmSharedGalleryImageId(vmSharedGalleryImageId?.applyValue({ args0 -> args0 }))
            .vmSize(vmSize?.applyValue({ args0 -> args0 }))
            .zones(zones?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [NodeTypeArgs].
 */
@PulumiTagMarker
public class NodeTypeArgsBuilder internal constructor() {
    private var additionalDataDisks: Output<List<VmssDataDiskArgs>>? = null

    private var applicationPorts: Output<EndpointRangeDescriptionArgs>? = null

    private var capacities: Output<Map<String, String>>? = null

    private var clusterName: Output<String>? = null

    private var dataDiskLetter: Output<String>? = null

    private var dataDiskSizeGB: Output<Int>? = null

    private var dataDiskType: Output<Either<String, DiskType>>? = null

    private var enableAcceleratedNetworking: Output<Boolean>? = null

    private var enableEncryptionAtHost: Output<Boolean>? = null

    private var enableNodePublicIP: Output<Boolean>? = null

    private var enableOverProvisioning: Output<Boolean>? = null

    private var ephemeralPorts: Output<EndpointRangeDescriptionArgs>? = null

    private var evictionPolicy: Output<Either<String, EvictionPolicyType>>? = null

    private var frontendConfigurations: Output<List<FrontendConfigurationArgs>>? = null

    private var hostGroupId: Output<String>? = null

    private var isPrimary: Output<Boolean>? = null

    private var isSpotVM: Output<Boolean>? = null

    private var isStateless: Output<Boolean>? = null

    private var multiplePlacementGroups: Output<Boolean>? = null

    private var natGatewayId: Output<String>? = null

    private var networkSecurityRules: Output<List<NetworkSecurityRuleArgs>>? = null

    private var nodeTypeName: Output<String>? = null

    private var placementProperties: Output<Map<String, String>>? = null

    private var resourceGroupName: Output<String>? = null

    private var secureBootEnabled: Output<Boolean>? = null

    private var securityType: Output<Either<String, SecurityType>>? = null

    private var sku: Output<NodeTypeSkuArgs>? = null

    private var spotRestoreTimeout: Output<String>? = null

    private var subnetId: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var useDefaultPublicLoadBalancer: Output<Boolean>? = null

    private var useEphemeralOSDisk: Output<Boolean>? = null

    private var useTempDataDisk: Output<Boolean>? = null

    private var vmExtensions: Output<List<VMSSExtensionArgs>>? = null

    private var vmImageOffer: Output<String>? = null

    private var vmImagePlan: Output<VmImagePlanArgs>? = null

    private var vmImagePublisher: Output<String>? = null

    private var vmImageResourceId: Output<String>? = null

    private var vmImageSku: Output<String>? = null

    private var vmImageVersion: Output<String>? = null

    private var vmInstanceCount: Output<Int>? = null

    private var vmManagedIdentity: Output<VmManagedIdentityArgs>? = null

    private var vmSecrets: Output<List<VaultSecretGroupArgs>>? = null

    private var vmSetupActions: Output<List<Either<String, VmSetupAction>>>? = null

    private var vmSharedGalleryImageId: Output<String>? = null

    private var vmSize: Output<String>? = null

    private var zones: Output<List<String>>? = null

    /**
     * @param value Additional managed data disks.
     */
    @JvmName("wahiepminmdsgacr")
    public suspend fun additionalDataDisks(`value`: Output<List<VmssDataDiskArgs>>) {
        this.additionalDataDisks = value
    }

    @JvmName("dphxpvnbljjjvewg")
    public suspend fun additionalDataDisks(vararg values: Output<VmssDataDiskArgs>) {
        this.additionalDataDisks = Output.all(values.asList())
    }

    /**
     * @param values Additional managed data disks.
     */
    @JvmName("fgvjbfxxtsmpriow")
    public suspend fun additionalDataDisks(values: List<Output<VmssDataDiskArgs>>) {
        this.additionalDataDisks = Output.all(values)
    }

    /**
     * @param value The range of ports from which cluster assigned port to Service Fabric applications.
     */
    @JvmName("qrntlruqvvkajpgi")
    public suspend fun applicationPorts(`value`: Output<EndpointRangeDescriptionArgs>) {
        this.applicationPorts = value
    }

    /**
     * @param value The capacity tags applied to the nodes in the node type, the cluster resource manager uses these tags to understand how much resource a node has.
     */
    @JvmName("cgbogvlnohujuvlw")
    public suspend fun capacities(`value`: Output<Map<String, String>>) {
        this.capacities = value
    }

    /**
     * @param value The name of the cluster resource.
     */
    @JvmName("frieqwpuvbjyrtkt")
    public suspend fun clusterName(`value`: Output<String>) {
        this.clusterName = value
    }

    /**
     * @param value Managed data disk letter. It can not use the reserved letter C or D and it can not change after created.
     */
    @JvmName("swkdoshwvwsgwbru")
    public suspend fun dataDiskLetter(`value`: Output<String>) {
        this.dataDiskLetter = value
    }

    /**
     * @param value Disk size for the managed disk attached to the vms on the node type in GBs.
     */
    @JvmName("ijwguctjtlaogwpn")
    public suspend fun dataDiskSizeGB(`value`: Output<Int>) {
        this.dataDiskSizeGB = value
    }

    /**
     * @param value Managed data disk type. Specifies the storage account type for the managed disk
     */
    @JvmName("dchyyxxigwuyxxxs")
    public suspend fun dataDiskType(`value`: Output<Either<String, DiskType>>) {
        this.dataDiskType = value
    }

    /**
     * @param value Specifies whether the network interface is accelerated networking-enabled.
     */
    @JvmName("anpbsoeiblqgveom")
    public suspend fun enableAcceleratedNetworking(`value`: Output<Boolean>) {
        this.enableAcceleratedNetworking = value
    }

    /**
     * @param value Enable or disable the Host Encryption for the virtual machines on the node type. This will enable the encryption for all the disks including Resource/Temp disk at host itself. Default: The Encryption at host will be disabled unless this property is set to true for the resource.
     */
    @JvmName("lvsmnghjgcfjviol")
    public suspend fun enableEncryptionAtHost(`value`: Output<Boolean>) {
        this.enableEncryptionAtHost = value
    }

    /**
     * @param value Specifies whether each node is allocated its own public IP address. This is only supported on secondary node types with custom Load Balancers.
     */
    @JvmName("htvkaklefkhubokh")
    public suspend fun enableNodePublicIP(`value`: Output<Boolean>) {
        this.enableNodePublicIP = value
    }

    /**
     * @param value Specifies whether the node type should be overprovisioned. It is only allowed for stateless node types.
     */
    @JvmName("tncojltihctrkggk")
    public suspend fun enableOverProvisioning(`value`: Output<Boolean>) {
        this.enableOverProvisioning = value
    }

    /**
     * @param value The range of ephemeral ports that nodes in this node type should be configured with.
     */
    @JvmName("bbljcfsrffuqrxdq")
    public suspend fun ephemeralPorts(`value`: Output<EndpointRangeDescriptionArgs>) {
        this.ephemeralPorts = value
    }

    /**
     * @param value Specifies the eviction policy for virtual machines in a SPOT node type. Default is Delete.
     */
    @JvmName("iohiijflhevmhsie")
    public suspend fun evictionPolicy(`value`: Output<Either<String, EvictionPolicyType>>) {
        this.evictionPolicy = value
    }

    /**
     * @param value Indicates the node type uses its own frontend configurations instead of the default one for the cluster. This setting can only be specified for non-primary node types and can not be added or removed after the node type is created.
     */
    @JvmName("sfpbiakeqdqseygt")
    public suspend fun frontendConfigurations(`value`: Output<List<FrontendConfigurationArgs>>) {
        this.frontendConfigurations = value
    }

    @JvmName("bnhmuvjhhqigplqf")
    public suspend fun frontendConfigurations(vararg values: Output<FrontendConfigurationArgs>) {
        this.frontendConfigurations = Output.all(values.asList())
    }

    /**
     * @param values Indicates the node type uses its own frontend configurations instead of the default one for the cluster. This setting can only be specified for non-primary node types and can not be added or removed after the node type is created.
     */
    @JvmName("ecjqdhqltvadaiso")
    public suspend fun frontendConfigurations(values: List<Output<FrontendConfigurationArgs>>) {
        this.frontendConfigurations = Output.all(values)
    }

    /**
     * @param value Specifies the full host group resource Id. This property is used for deploying on azure dedicated hosts.
     */
    @JvmName("voxuevawavxlomcg")
    public suspend fun hostGroupId(`value`: Output<String>) {
        this.hostGroupId = value
    }

    /**
     * @param value Indicates the Service Fabric system services for the cluster will run on this node type. This setting cannot be changed once the node type is created.
     */
    @JvmName("miaoluytytekyvrh")
    public suspend fun isPrimary(`value`: Output<Boolean>) {
        this.isPrimary = value
    }

    /**
     * @param value Indicates whether the node type will be Spot Virtual Machines. Azure will allocate the VMs if there is capacity available and the VMs can be evicted at any time.
     */
    @JvmName("pxghrfoufmhhbiej")
    public suspend fun isSpotVM(`value`: Output<Boolean>) {
        this.isSpotVM = value
    }

    /**
     * @param value Indicates if the node type can only host Stateless workloads.
     */
    @JvmName("xulvgnmlnueljiak")
    public suspend fun isStateless(`value`: Output<Boolean>) {
        this.isStateless = value
    }

    /**
     * @param value Indicates if scale set associated with the node type can be composed of multiple placement groups.
     */
    @JvmName("btyrcayfoffbkiom")
    public suspend fun multiplePlacementGroups(`value`: Output<Boolean>) {
        this.multiplePlacementGroups = value
    }

    /**
     * @param value Specifies the resource id of a NAT Gateway to attach to the subnet of this node type. Node type must use custom load balancer.
     */
    @JvmName("mcrctapqpfeapsrm")
    public suspend fun natGatewayId(`value`: Output<String>) {
        this.natGatewayId = value
    }

    /**
     * @param value The Network Security Rules for this node type. This setting can only be specified for node types that are configured with frontend configurations.
     */
    @JvmName("psxyonitrjqmxcuw")
    public suspend fun networkSecurityRules(`value`: Output<List<NetworkSecurityRuleArgs>>) {
        this.networkSecurityRules = value
    }

    @JvmName("gccwpalkhrfqljnr")
    public suspend fun networkSecurityRules(vararg values: Output<NetworkSecurityRuleArgs>) {
        this.networkSecurityRules = Output.all(values.asList())
    }

    /**
     * @param values The Network Security Rules for this node type. This setting can only be specified for node types that are configured with frontend configurations.
     */
    @JvmName("tjafxcrafjmjiqej")
    public suspend fun networkSecurityRules(values: List<Output<NetworkSecurityRuleArgs>>) {
        this.networkSecurityRules = Output.all(values)
    }

    /**
     * @param value The name of the node type.
     */
    @JvmName("uscnjhrbudvttmxa")
    public suspend fun nodeTypeName(`value`: Output<String>) {
        this.nodeTypeName = value
    }

    /**
     * @param value The placement tags applied to nodes in the node type, which can be used to indicate where certain services (workload) should run.
     */
    @JvmName("tswlcyjqojctltvq")
    public suspend fun placementProperties(`value`: Output<Map<String, String>>) {
        this.placementProperties = value
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("vprflhaibufcjrlx")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Specifies whether secure boot should be enabled on the nodeType. Can only be used with TrustedLaunch SecurityType
     */
    @JvmName("jofrjcigqxltyarx")
    public suspend fun secureBootEnabled(`value`: Output<Boolean>) {
        this.secureBootEnabled = value
    }

    /**
     * @param value Specifies the security type of the nodeType. Only TrustedLaunch is currently supported
     */
    @JvmName("tivdiarmnypaimdt")
    public suspend fun securityType(`value`: Output<Either<String, SecurityType>>) {
        this.securityType = value
    }

    /**
     * @param value The node type sku.
     */
    @JvmName("igxlcvljphhamkgm")
    public suspend fun sku(`value`: Output<NodeTypeSkuArgs>) {
        this.sku = value
    }

    /**
     * @param value Indicates the time duration after which the platform will not try to restore the VMSS SPOT instances specified as ISO 8601.
     */
    @JvmName("oqxyvyefiqdkgunm")
    public suspend fun spotRestoreTimeout(`value`: Output<String>) {
        this.spotRestoreTimeout = value
    }

    /**
     * @param value Indicates the resource id of the subnet for the node type.
     */
    @JvmName("xhcccresyufqqtkh")
    public suspend fun subnetId(`value`: Output<String>) {
        this.subnetId = value
    }

    /**
     * @param value Azure resource tags.
     */
    @JvmName("oxvlhuthtxwcqowk")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Specifies whether the use public load balancer. If not specified and the node type doesn't have its own frontend configuration, it will be attached to the default load balancer. If the node type uses its own Load balancer and useDefaultPublicLoadBalancer is true, then the frontend has to be an Internal Load Balancer. If the node type uses its own Load balancer and useDefaultPublicLoadBalancer is false or not set, then the custom load balancer must include a public load balancer to provide outbound connectivity.
     */
    @JvmName("mdclgenryibbjapl")
    public suspend fun useDefaultPublicLoadBalancer(`value`: Output<Boolean>) {
        this.useDefaultPublicLoadBalancer = value
    }

    /**
     * @param value Indicates whether to use ephemeral os disk. The sku selected on the vmSize property needs to support this feature.
     */
    @JvmName("nwjlmesomvxctjnt")
    public suspend fun useEphemeralOSDisk(`value`: Output<Boolean>) {
        this.useEphemeralOSDisk = value
    }

    /**
     * @param value Specifies whether to use the temporary disk for the service fabric data root, in which case no managed data disk will be attached and the temporary disk will be used. It is only allowed for stateless node types.
     */
    @JvmName("lbqupbsmjhiekcjv")
    public suspend fun useTempDataDisk(`value`: Output<Boolean>) {
        this.useTempDataDisk = value
    }

    /**
     * @param value Set of extensions that should be installed onto the virtual machines.
     */
    @JvmName("urkfgcquknitdsyx")
    public suspend fun vmExtensions(`value`: Output<List<VMSSExtensionArgs>>) {
        this.vmExtensions = value
    }

    @JvmName("srvlelnajbnsakif")
    public suspend fun vmExtensions(vararg values: Output<VMSSExtensionArgs>) {
        this.vmExtensions = Output.all(values.asList())
    }

    /**
     * @param values Set of extensions that should be installed onto the virtual machines.
     */
    @JvmName("tvqfsdeyyyxfnjjx")
    public suspend fun vmExtensions(values: List<Output<VMSSExtensionArgs>>) {
        this.vmExtensions = Output.all(values)
    }

    /**
     * @param value The offer type of the Azure Virtual Machines Marketplace image. For example, UbuntuServer or WindowsServer.
     */
    @JvmName("pxccvqmpwanpwtdh")
    public suspend fun vmImageOffer(`value`: Output<String>) {
        this.vmImageOffer = value
    }

    /**
     * @param value Specifies information about the marketplace image used to create the virtual machine. This element is only used for marketplace images. Before you can use a marketplace image from an API, you must enable the image for programmatic use. In the Azure portal, find the marketplace image that you want to use and then click Want to deploy programmatically, Get Started ->. Enter any required information and then click Save.
     */
    @JvmName("oemeybilubylyuxt")
    public suspend fun vmImagePlan(`value`: Output<VmImagePlanArgs>) {
        this.vmImagePlan = value
    }

    /**
     * @param value The publisher of the Azure Virtual Machines Marketplace image. For example, Canonical or MicrosoftWindowsServer.
     */
    @JvmName("tjqaxicrdnpwxpkj")
    public suspend fun vmImagePublisher(`value`: Output<String>) {
        this.vmImagePublisher = value
    }

    /**
     * @param value Indicates the resource id of the vm image. This parameter is used for custom vm image.
     */
    @JvmName("ccchxmiqouxljswo")
    public suspend fun vmImageResourceId(`value`: Output<String>) {
        this.vmImageResourceId = value
    }

    /**
     * @param value The SKU of the Azure Virtual Machines Marketplace image. For example, 14.04.0-LTS or 2012-R2-Datacenter.
     */
    @JvmName("gogayvuxinkxfivu")
    public suspend fun vmImageSku(`value`: Output<String>) {
        this.vmImageSku = value
    }

    /**
     * @param value The version of the Azure Virtual Machines Marketplace image. A value of 'latest' can be specified to select the latest version of an image. If omitted, the default is 'latest'.
     */
    @JvmName("fokjoivbwstyybcr")
    public suspend fun vmImageVersion(`value`: Output<String>) {
        this.vmImageVersion = value
    }

    /**
     * @param value The number of nodes in the node type. <br /><br />**Values:** <br />-1 - Use when auto scale rules are configured or sku.capacity is defined <br /> 0 - Not supported <br /> >0 - Use for manual scale.
     */
    @JvmName("vitjoebrfflmnnvx")
    public suspend fun vmInstanceCount(`value`: Output<Int>) {
        this.vmInstanceCount = value
    }

    /**
     * @param value Identities to assign to the virtual machine scale set under the node type.
     */
    @JvmName("xvbexjronritcyin")
    public suspend fun vmManagedIdentity(`value`: Output<VmManagedIdentityArgs>) {
        this.vmManagedIdentity = value
    }

    /**
     * @param value The secrets to install in the virtual machines.
     */
    @JvmName("xxguipajgsqyptle")
    public suspend fun vmSecrets(`value`: Output<List<VaultSecretGroupArgs>>) {
        this.vmSecrets = value
    }

    @JvmName("hdvfrxrqmwrrcqtb")
    public suspend fun vmSecrets(vararg values: Output<VaultSecretGroupArgs>) {
        this.vmSecrets = Output.all(values.asList())
    }

    /**
     * @param values The secrets to install in the virtual machines.
     */
    @JvmName("ndqvcqelqtwvhnle")
    public suspend fun vmSecrets(values: List<Output<VaultSecretGroupArgs>>) {
        this.vmSecrets = Output.all(values)
    }

    /**
     * @param value Specifies the actions to be performed on the vms before bootstrapping the service fabric runtime.
     */
    @JvmName("cbyrgujvqxaumrbo")
    public suspend fun vmSetupActions(`value`: Output<List<Either<String, VmSetupAction>>>) {
        this.vmSetupActions = value
    }

    @JvmName("vogddajigjgmsfhu")
    public suspend fun vmSetupActions(vararg values: Output<Either<String, VmSetupAction>>) {
        this.vmSetupActions = Output.all(values.asList())
    }

    /**
     * @param values Specifies the actions to be performed on the vms before bootstrapping the service fabric runtime.
     */
    @JvmName("vgvhtajyoutwovil")
    public suspend fun vmSetupActions(values: List<Output<Either<String, VmSetupAction>>>) {
        this.vmSetupActions = Output.all(values)
    }

    /**
     * @param value Indicates the resource id of the vm shared galleries image. This parameter is used for custom vm image.
     */
    @JvmName("idynejkftqlnkujh")
    public suspend fun vmSharedGalleryImageId(`value`: Output<String>) {
        this.vmSharedGalleryImageId = value
    }

    /**
     * @param value The size of virtual machines in the pool. All virtual machines in a pool are the same size. For example, Standard_D3.
     */
    @JvmName("oxsisnadashdcetl")
    public suspend fun vmSize(`value`: Output<String>) {
        this.vmSize = value
    }

    /**
     * @param value Specifies the availability zones where the node type would span across. If the cluster is not spanning across availability zones, initiates az migration for the cluster.
     */
    @JvmName("wyniwdtxqqygqgkn")
    public suspend fun zones(`value`: Output<List<String>>) {
        this.zones = value
    }

    @JvmName("taxxvlbltfvwxlrl")
    public suspend fun zones(vararg values: Output<String>) {
        this.zones = Output.all(values.asList())
    }

    /**
     * @param values Specifies the availability zones where the node type would span across. If the cluster is not spanning across availability zones, initiates az migration for the cluster.
     */
    @JvmName("ytxysucmawvrqvgv")
    public suspend fun zones(values: List<Output<String>>) {
        this.zones = Output.all(values)
    }

    /**
     * @param value Additional managed data disks.
     */
    @JvmName("piiykhrlfeyibuxg")
    public suspend fun additionalDataDisks(`value`: List<VmssDataDiskArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.additionalDataDisks = mapped
    }

    /**
     * @param argument Additional managed data disks.
     */
    @JvmName("lstpqkldssqkoaim")
    public suspend
    fun additionalDataDisks(argument: List<suspend VmssDataDiskArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VmssDataDiskArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.additionalDataDisks = mapped
    }

    /**
     * @param argument Additional managed data disks.
     */
    @JvmName("wdxpwdymrirqrchn")
    public suspend fun additionalDataDisks(
        vararg
        argument: suspend VmssDataDiskArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            VmssDataDiskArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.additionalDataDisks = mapped
    }

    /**
     * @param argument Additional managed data disks.
     */
    @JvmName("ceitojbgpwknkmxa")
    public suspend fun additionalDataDisks(argument: suspend VmssDataDiskArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(VmssDataDiskArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.additionalDataDisks = mapped
    }

    /**
     * @param values Additional managed data disks.
     */
    @JvmName("ofnkwxavfabjkbjv")
    public suspend fun additionalDataDisks(vararg values: VmssDataDiskArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.additionalDataDisks = mapped
    }

    /**
     * @param value The range of ports from which cluster assigned port to Service Fabric applications.
     */
    @JvmName("wxmaqqsuejsfyjnt")
    public suspend fun applicationPorts(`value`: EndpointRangeDescriptionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationPorts = mapped
    }

    /**
     * @param argument The range of ports from which cluster assigned port to Service Fabric applications.
     */
    @JvmName("vbajyocjpltunrvf")
    public suspend
    fun applicationPorts(argument: suspend EndpointRangeDescriptionArgsBuilder.() -> Unit) {
        val toBeMapped = EndpointRangeDescriptionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.applicationPorts = mapped
    }

    /**
     * @param value The capacity tags applied to the nodes in the node type, the cluster resource manager uses these tags to understand how much resource a node has.
     */
    @JvmName("imvkgivoycjwbftj")
    public suspend fun capacities(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.capacities = mapped
    }

    /**
     * @param values The capacity tags applied to the nodes in the node type, the cluster resource manager uses these tags to understand how much resource a node has.
     */
    @JvmName("fogfrrqecgpiefdh")
    public fun capacities(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.capacities = mapped
    }

    /**
     * @param value The name of the cluster resource.
     */
    @JvmName("efqttylmpmxlraht")
    public suspend fun clusterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterName = mapped
    }

    /**
     * @param value Managed data disk letter. It can not use the reserved letter C or D and it can not change after created.
     */
    @JvmName("bdalbvvepvcfiqxm")
    public suspend fun dataDiskLetter(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataDiskLetter = mapped
    }

    /**
     * @param value Disk size for the managed disk attached to the vms on the node type in GBs.
     */
    @JvmName("myjwruqynwejrruy")
    public suspend fun dataDiskSizeGB(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataDiskSizeGB = mapped
    }

    /**
     * @param value Managed data disk type. Specifies the storage account type for the managed disk
     */
    @JvmName("bbbrmgorqhshiiqi")
    public suspend fun dataDiskType(`value`: Either<String, DiskType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataDiskType = mapped
    }

    /**
     * @param value Managed data disk type. Specifies the storage account type for the managed disk
     */
    @JvmName("brpnhftpcxukrkgm")
    public fun dataDiskType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DiskType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataDiskType = mapped
    }

    /**
     * @param value Managed data disk type. Specifies the storage account type for the managed disk
     */
    @JvmName("selntlhejxwcpuca")
    public fun dataDiskType(`value`: DiskType) {
        val toBeMapped = Either.ofRight<String, DiskType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataDiskType = mapped
    }

    /**
     * @param value Specifies whether the network interface is accelerated networking-enabled.
     */
    @JvmName("khclmmugkndofdym")
    public suspend fun enableAcceleratedNetworking(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableAcceleratedNetworking = mapped
    }

    /**
     * @param value Enable or disable the Host Encryption for the virtual machines on the node type. This will enable the encryption for all the disks including Resource/Temp disk at host itself. Default: The Encryption at host will be disabled unless this property is set to true for the resource.
     */
    @JvmName("vlnncnikmikukiuy")
    public suspend fun enableEncryptionAtHost(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableEncryptionAtHost = mapped
    }

    /**
     * @param value Specifies whether each node is allocated its own public IP address. This is only supported on secondary node types with custom Load Balancers.
     */
    @JvmName("vsbvjlhwolwiqujr")
    public suspend fun enableNodePublicIP(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableNodePublicIP = mapped
    }

    /**
     * @param value Specifies whether the node type should be overprovisioned. It is only allowed for stateless node types.
     */
    @JvmName("gheituyifmbogcww")
    public suspend fun enableOverProvisioning(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableOverProvisioning = mapped
    }

    /**
     * @param value The range of ephemeral ports that nodes in this node type should be configured with.
     */
    @JvmName("btkxvecsrmaphfdj")
    public suspend fun ephemeralPorts(`value`: EndpointRangeDescriptionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ephemeralPorts = mapped
    }

    /**
     * @param argument The range of ephemeral ports that nodes in this node type should be configured with.
     */
    @JvmName("hhgtflqxiurffqrg")
    public suspend
    fun ephemeralPorts(argument: suspend EndpointRangeDescriptionArgsBuilder.() -> Unit) {
        val toBeMapped = EndpointRangeDescriptionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.ephemeralPorts = mapped
    }

    /**
     * @param value Specifies the eviction policy for virtual machines in a SPOT node type. Default is Delete.
     */
    @JvmName("skwdsulsbyysbmby")
    public suspend fun evictionPolicy(`value`: Either<String, EvictionPolicyType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.evictionPolicy = mapped
    }

    /**
     * @param value Specifies the eviction policy for virtual machines in a SPOT node type. Default is Delete.
     */
    @JvmName("ocqrgnwynpbsgnux")
    public fun evictionPolicy(`value`: String) {
        val toBeMapped = Either.ofLeft<String, EvictionPolicyType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.evictionPolicy = mapped
    }

    /**
     * @param value Specifies the eviction policy for virtual machines in a SPOT node type. Default is Delete.
     */
    @JvmName("gypclcgegbjrudqi")
    public fun evictionPolicy(`value`: EvictionPolicyType) {
        val toBeMapped = Either.ofRight<String, EvictionPolicyType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.evictionPolicy = mapped
    }

    /**
     * @param value Indicates the node type uses its own frontend configurations instead of the default one for the cluster. This setting can only be specified for non-primary node types and can not be added or removed after the node type is created.
     */
    @JvmName("hvfunwdbxuxkcfmm")
    public suspend fun frontendConfigurations(`value`: List<FrontendConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.frontendConfigurations = mapped
    }

    /**
     * @param argument Indicates the node type uses its own frontend configurations instead of the default one for the cluster. This setting can only be specified for non-primary node types and can not be added or removed after the node type is created.
     */
    @JvmName("bcevwhmxlxmjlgac")
    public suspend
    fun frontendConfigurations(argument: List<suspend FrontendConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            FrontendConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.frontendConfigurations = mapped
    }

    /**
     * @param argument Indicates the node type uses its own frontend configurations instead of the default one for the cluster. This setting can only be specified for non-primary node types and can not be added or removed after the node type is created.
     */
    @JvmName("igjyljfybqmdvdnv")
    public suspend fun frontendConfigurations(
        vararg
        argument: suspend FrontendConfigurationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            FrontendConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.frontendConfigurations = mapped
    }

    /**
     * @param argument Indicates the node type uses its own frontend configurations instead of the default one for the cluster. This setting can only be specified for non-primary node types and can not be added or removed after the node type is created.
     */
    @JvmName("scnbgvssqibonidx")
    public suspend
    fun frontendConfigurations(argument: suspend FrontendConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(FrontendConfigurationArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.frontendConfigurations = mapped
    }

    /**
     * @param values Indicates the node type uses its own frontend configurations instead of the default one for the cluster. This setting can only be specified for non-primary node types and can not be added or removed after the node type is created.
     */
    @JvmName("rucknpykiqifysis")
    public suspend fun frontendConfigurations(vararg values: FrontendConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.frontendConfigurations = mapped
    }

    /**
     * @param value Specifies the full host group resource Id. This property is used for deploying on azure dedicated hosts.
     */
    @JvmName("dhvrbudixgknptew")
    public suspend fun hostGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostGroupId = mapped
    }

    /**
     * @param value Indicates the Service Fabric system services for the cluster will run on this node type. This setting cannot be changed once the node type is created.
     */
    @JvmName("hrwsharpqewafajc")
    public suspend fun isPrimary(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isPrimary = mapped
    }

    /**
     * @param value Indicates whether the node type will be Spot Virtual Machines. Azure will allocate the VMs if there is capacity available and the VMs can be evicted at any time.
     */
    @JvmName("selivjecfohhnxws")
    public suspend fun isSpotVM(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isSpotVM = mapped
    }

    /**
     * @param value Indicates if the node type can only host Stateless workloads.
     */
    @JvmName("uolryybrpcybergf")
    public suspend fun isStateless(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.isStateless = mapped
    }

    /**
     * @param value Indicates if scale set associated with the node type can be composed of multiple placement groups.
     */
    @JvmName("ewtmtiaynjljqmkb")
    public suspend fun multiplePlacementGroups(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.multiplePlacementGroups = mapped
    }

    /**
     * @param value Specifies the resource id of a NAT Gateway to attach to the subnet of this node type. Node type must use custom load balancer.
     */
    @JvmName("qjkvhnckinisnmgc")
    public suspend fun natGatewayId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.natGatewayId = mapped
    }

    /**
     * @param value The Network Security Rules for this node type. This setting can only be specified for node types that are configured with frontend configurations.
     */
    @JvmName("irffivqslugewawv")
    public suspend fun networkSecurityRules(`value`: List<NetworkSecurityRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkSecurityRules = mapped
    }

    /**
     * @param argument The Network Security Rules for this node type. This setting can only be specified for node types that are configured with frontend configurations.
     */
    @JvmName("yumtrmrrcqcsioaj")
    public suspend
    fun networkSecurityRules(argument: List<suspend NetworkSecurityRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            NetworkSecurityRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.networkSecurityRules = mapped
    }

    /**
     * @param argument The Network Security Rules for this node type. This setting can only be specified for node types that are configured with frontend configurations.
     */
    @JvmName("mhefcapvhlaaekaf")
    public suspend fun networkSecurityRules(
        vararg
        argument: suspend NetworkSecurityRuleArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            NetworkSecurityRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.networkSecurityRules = mapped
    }

    /**
     * @param argument The Network Security Rules for this node type. This setting can only be specified for node types that are configured with frontend configurations.
     */
    @JvmName("vgkiqnxyupoxvcyo")
    public suspend
    fun networkSecurityRules(argument: suspend NetworkSecurityRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(NetworkSecurityRuleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.networkSecurityRules = mapped
    }

    /**
     * @param values The Network Security Rules for this node type. This setting can only be specified for node types that are configured with frontend configurations.
     */
    @JvmName("tkopuelpgnjbfiux")
    public suspend fun networkSecurityRules(vararg values: NetworkSecurityRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.networkSecurityRules = mapped
    }

    /**
     * @param value The name of the node type.
     */
    @JvmName("yqjdowkufldgjxvt")
    public suspend fun nodeTypeName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nodeTypeName = mapped
    }

    /**
     * @param value The placement tags applied to nodes in the node type, which can be used to indicate where certain services (workload) should run.
     */
    @JvmName("nysfhakicmoeqvfe")
    public suspend fun placementProperties(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.placementProperties = mapped
    }

    /**
     * @param values The placement tags applied to nodes in the node type, which can be used to indicate where certain services (workload) should run.
     */
    @JvmName("pbhwcmbtaptdynbe")
    public fun placementProperties(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.placementProperties = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("urwhqlvqucdtjnfa")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Specifies whether secure boot should be enabled on the nodeType. Can only be used with TrustedLaunch SecurityType
     */
    @JvmName("cnhieajqcllyqsnu")
    public suspend fun secureBootEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secureBootEnabled = mapped
    }

    /**
     * @param value Specifies the security type of the nodeType. Only TrustedLaunch is currently supported
     */
    @JvmName("xpftpcksgdjugrnv")
    public suspend fun securityType(`value`: Either<String, SecurityType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityType = mapped
    }

    /**
     * @param value Specifies the security type of the nodeType. Only TrustedLaunch is currently supported
     */
    @JvmName("duwemuwkobxusado")
    public fun securityType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SecurityType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityType = mapped
    }

    /**
     * @param value Specifies the security type of the nodeType. Only TrustedLaunch is currently supported
     */
    @JvmName("jmgmdghounurfsrp")
    public fun securityType(`value`: SecurityType) {
        val toBeMapped = Either.ofRight<String, SecurityType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityType = mapped
    }

    /**
     * @param value The node type sku.
     */
    @JvmName("iekicjiqcxiggyxv")
    public suspend fun sku(`value`: NodeTypeSkuArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sku = mapped
    }

    /**
     * @param argument The node type sku.
     */
    @JvmName("qtiqdtwxpvnffhkx")
    public suspend fun sku(argument: suspend NodeTypeSkuArgsBuilder.() -> Unit) {
        val toBeMapped = NodeTypeSkuArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sku = mapped
    }

    /**
     * @param value Indicates the time duration after which the platform will not try to restore the VMSS SPOT instances specified as ISO 8601.
     */
    @JvmName("tahmwgjdoptehnnx")
    public suspend fun spotRestoreTimeout(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.spotRestoreTimeout = mapped
    }

    /**
     * @param value Indicates the resource id of the subnet for the node type.
     */
    @JvmName("mjgpirlqfvotciws")
    public suspend fun subnetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetId = mapped
    }

    /**
     * @param value Azure resource tags.
     */
    @JvmName("hbcleqabrlitpaaw")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Azure resource tags.
     */
    @JvmName("wwghqkydsartkxob")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Specifies whether the use public load balancer. If not specified and the node type doesn't have its own frontend configuration, it will be attached to the default load balancer. If the node type uses its own Load balancer and useDefaultPublicLoadBalancer is true, then the frontend has to be an Internal Load Balancer. If the node type uses its own Load balancer and useDefaultPublicLoadBalancer is false or not set, then the custom load balancer must include a public load balancer to provide outbound connectivity.
     */
    @JvmName("yapeagispbjxkfyh")
    public suspend fun useDefaultPublicLoadBalancer(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useDefaultPublicLoadBalancer = mapped
    }

    /**
     * @param value Indicates whether to use ephemeral os disk. The sku selected on the vmSize property needs to support this feature.
     */
    @JvmName("vvvwahtpdnrihvda")
    public suspend fun useEphemeralOSDisk(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useEphemeralOSDisk = mapped
    }

    /**
     * @param value Specifies whether to use the temporary disk for the service fabric data root, in which case no managed data disk will be attached and the temporary disk will be used. It is only allowed for stateless node types.
     */
    @JvmName("lbexjhtmdnccvewr")
    public suspend fun useTempDataDisk(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useTempDataDisk = mapped
    }

    /**
     * @param value Set of extensions that should be installed onto the virtual machines.
     */
    @JvmName("jgckcdfisympfcrd")
    public suspend fun vmExtensions(`value`: List<VMSSExtensionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vmExtensions = mapped
    }

    /**
     * @param argument Set of extensions that should be installed onto the virtual machines.
     */
    @JvmName("afxiewmnqjisksfq")
    public suspend fun vmExtensions(argument: List<suspend VMSSExtensionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VMSSExtensionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.vmExtensions = mapped
    }

    /**
     * @param argument Set of extensions that should be installed onto the virtual machines.
     */
    @JvmName("dgxtjqtunqkrttcp")
    public suspend fun vmExtensions(vararg argument: suspend VMSSExtensionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            VMSSExtensionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.vmExtensions = mapped
    }

    /**
     * @param argument Set of extensions that should be installed onto the virtual machines.
     */
    @JvmName("kbqgsplphefutyfm")
    public suspend fun vmExtensions(argument: suspend VMSSExtensionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(VMSSExtensionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.vmExtensions = mapped
    }

    /**
     * @param values Set of extensions that should be installed onto the virtual machines.
     */
    @JvmName("ufhelduoqegvwxrv")
    public suspend fun vmExtensions(vararg values: VMSSExtensionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vmExtensions = mapped
    }

    /**
     * @param value The offer type of the Azure Virtual Machines Marketplace image. For example, UbuntuServer or WindowsServer.
     */
    @JvmName("yvgjocbfvuinlxgc")
    public suspend fun vmImageOffer(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vmImageOffer = mapped
    }

    /**
     * @param value Specifies information about the marketplace image used to create the virtual machine. This element is only used for marketplace images. Before you can use a marketplace image from an API, you must enable the image for programmatic use. In the Azure portal, find the marketplace image that you want to use and then click Want to deploy programmatically, Get Started ->. Enter any required information and then click Save.
     */
    @JvmName("bbaovqxgcrpehyxg")
    public suspend fun vmImagePlan(`value`: VmImagePlanArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vmImagePlan = mapped
    }

    /**
     * @param argument Specifies information about the marketplace image used to create the virtual machine. This element is only used for marketplace images. Before you can use a marketplace image from an API, you must enable the image for programmatic use. In the Azure portal, find the marketplace image that you want to use and then click Want to deploy programmatically, Get Started ->. Enter any required information and then click Save.
     */
    @JvmName("ccvcdqtngiboidpc")
    public suspend fun vmImagePlan(argument: suspend VmImagePlanArgsBuilder.() -> Unit) {
        val toBeMapped = VmImagePlanArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.vmImagePlan = mapped
    }

    /**
     * @param value The publisher of the Azure Virtual Machines Marketplace image. For example, Canonical or MicrosoftWindowsServer.
     */
    @JvmName("jcbshiblgewdscxf")
    public suspend fun vmImagePublisher(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vmImagePublisher = mapped
    }

    /**
     * @param value Indicates the resource id of the vm image. This parameter is used for custom vm image.
     */
    @JvmName("kxwmbirjilubessg")
    public suspend fun vmImageResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vmImageResourceId = mapped
    }

    /**
     * @param value The SKU of the Azure Virtual Machines Marketplace image. For example, 14.04.0-LTS or 2012-R2-Datacenter.
     */
    @JvmName("nhbutisndmpncuxw")
    public suspend fun vmImageSku(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vmImageSku = mapped
    }

    /**
     * @param value The version of the Azure Virtual Machines Marketplace image. A value of 'latest' can be specified to select the latest version of an image. If omitted, the default is 'latest'.
     */
    @JvmName("chgoqlkvdmnnkbkc")
    public suspend fun vmImageVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vmImageVersion = mapped
    }

    /**
     * @param value The number of nodes in the node type. <br /><br />**Values:** <br />-1 - Use when auto scale rules are configured or sku.capacity is defined <br /> 0 - Not supported <br /> >0 - Use for manual scale.
     */
    @JvmName("xgjvomafqblkfdyu")
    public suspend fun vmInstanceCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vmInstanceCount = mapped
    }

    /**
     * @param value Identities to assign to the virtual machine scale set under the node type.
     */
    @JvmName("gsegfggaqpgojyvp")
    public suspend fun vmManagedIdentity(`value`: VmManagedIdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vmManagedIdentity = mapped
    }

    /**
     * @param argument Identities to assign to the virtual machine scale set under the node type.
     */
    @JvmName("aaaapubvxvngnevb")
    public suspend fun vmManagedIdentity(argument: suspend VmManagedIdentityArgsBuilder.() -> Unit) {
        val toBeMapped = VmManagedIdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.vmManagedIdentity = mapped
    }

    /**
     * @param value The secrets to install in the virtual machines.
     */
    @JvmName("tqhhiivyjesaewkk")
    public suspend fun vmSecrets(`value`: List<VaultSecretGroupArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vmSecrets = mapped
    }

    /**
     * @param argument The secrets to install in the virtual machines.
     */
    @JvmName("yvvaoryncxugmaqg")
    public suspend fun vmSecrets(argument: List<suspend VaultSecretGroupArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            VaultSecretGroupArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.vmSecrets = mapped
    }

    /**
     * @param argument The secrets to install in the virtual machines.
     */
    @JvmName("qiaxtjqskdmbfatl")
    public suspend fun vmSecrets(vararg argument: suspend VaultSecretGroupArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            VaultSecretGroupArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.vmSecrets = mapped
    }

    /**
     * @param argument The secrets to install in the virtual machines.
     */
    @JvmName("vomxrvnvxqaandiu")
    public suspend fun vmSecrets(argument: suspend VaultSecretGroupArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(VaultSecretGroupArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.vmSecrets = mapped
    }

    /**
     * @param values The secrets to install in the virtual machines.
     */
    @JvmName("lliyurjctxlaukof")
    public suspend fun vmSecrets(vararg values: VaultSecretGroupArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vmSecrets = mapped
    }

    /**
     * @param value Specifies the actions to be performed on the vms before bootstrapping the service fabric runtime.
     */
    @JvmName("jrgdtsftkiprknfx")
    public suspend fun vmSetupActions(`value`: List<Either<String, VmSetupAction>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vmSetupActions = mapped
    }

    /**
     * @param values Specifies the actions to be performed on the vms before bootstrapping the service fabric runtime.
     */
    @JvmName("fasncmekowbvdfks")
    public suspend fun vmSetupActions(vararg values: Either<String, VmSetupAction>) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vmSetupActions = mapped
    }

    /**
     * @param value Indicates the resource id of the vm shared galleries image. This parameter is used for custom vm image.
     */
    @JvmName("vuopmguvpywhrsso")
    public suspend fun vmSharedGalleryImageId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vmSharedGalleryImageId = mapped
    }

    /**
     * @param value The size of virtual machines in the pool. All virtual machines in a pool are the same size. For example, Standard_D3.
     */
    @JvmName("rhvswobbhrxtsmao")
    public suspend fun vmSize(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vmSize = mapped
    }

    /**
     * @param value Specifies the availability zones where the node type would span across. If the cluster is not spanning across availability zones, initiates az migration for the cluster.
     */
    @JvmName("sthijrujjkhxjidd")
    public suspend fun zones(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zones = mapped
    }

    /**
     * @param values Specifies the availability zones where the node type would span across. If the cluster is not spanning across availability zones, initiates az migration for the cluster.
     */
    @JvmName("gxcmwvmfauihqpul")
    public suspend fun zones(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.zones = mapped
    }

    internal fun build(): NodeTypeArgs = NodeTypeArgs(
        additionalDataDisks = additionalDataDisks,
        applicationPorts = applicationPorts,
        capacities = capacities,
        clusterName = clusterName,
        dataDiskLetter = dataDiskLetter,
        dataDiskSizeGB = dataDiskSizeGB,
        dataDiskType = dataDiskType,
        enableAcceleratedNetworking = enableAcceleratedNetworking,
        enableEncryptionAtHost = enableEncryptionAtHost,
        enableNodePublicIP = enableNodePublicIP,
        enableOverProvisioning = enableOverProvisioning,
        ephemeralPorts = ephemeralPorts,
        evictionPolicy = evictionPolicy,
        frontendConfigurations = frontendConfigurations,
        hostGroupId = hostGroupId,
        isPrimary = isPrimary,
        isSpotVM = isSpotVM,
        isStateless = isStateless,
        multiplePlacementGroups = multiplePlacementGroups,
        natGatewayId = natGatewayId,
        networkSecurityRules = networkSecurityRules,
        nodeTypeName = nodeTypeName,
        placementProperties = placementProperties,
        resourceGroupName = resourceGroupName,
        secureBootEnabled = secureBootEnabled,
        securityType = securityType,
        sku = sku,
        spotRestoreTimeout = spotRestoreTimeout,
        subnetId = subnetId,
        tags = tags,
        useDefaultPublicLoadBalancer = useDefaultPublicLoadBalancer,
        useEphemeralOSDisk = useEphemeralOSDisk,
        useTempDataDisk = useTempDataDisk,
        vmExtensions = vmExtensions,
        vmImageOffer = vmImageOffer,
        vmImagePlan = vmImagePlan,
        vmImagePublisher = vmImagePublisher,
        vmImageResourceId = vmImageResourceId,
        vmImageSku = vmImageSku,
        vmImageVersion = vmImageVersion,
        vmInstanceCount = vmInstanceCount,
        vmManagedIdentity = vmManagedIdentity,
        vmSecrets = vmSecrets,
        vmSetupActions = vmSetupActions,
        vmSharedGalleryImageId = vmSharedGalleryImageId,
        vmSize = vmSize,
        zones = zones,
    )
}
