@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.inputs

import com.pulumi.azurenative.servicefabric.inputs.AddRemoveIncrementalNamedPartitionScalingMechanismArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Represents a scaling mechanism for adding or removing named partitions of a stateless service. Partition names are in the format '0','1'...'N-1'.
 * @property kind Enumerates the ways that a service can be partitioned.
 * Expected value is 'AddRemoveIncrementalNamedPartition'.
 * @property maxPartitionCount Maximum number of named partitions of the service.
 * @property minPartitionCount Minimum number of named partitions of the service.
 * @property scaleIncrement The number of instances to add or remove during a scaling operation.
 */
public data class AddRemoveIncrementalNamedPartitionScalingMechanismArgs(
    public val kind: Output<String>,
    public val maxPartitionCount: Output<Int>,
    public val minPartitionCount: Output<Int>,
    public val scaleIncrement: Output<Int>,
) :
    ConvertibleToJava<com.pulumi.azurenative.servicefabric.inputs.AddRemoveIncrementalNamedPartitionScalingMechanismArgs> {
    override fun toJava():
        com.pulumi.azurenative.servicefabric.inputs.AddRemoveIncrementalNamedPartitionScalingMechanismArgs =
        com.pulumi.azurenative.servicefabric.inputs.AddRemoveIncrementalNamedPartitionScalingMechanismArgs.builder()
            .kind(kind.applyValue({ args0 -> args0 }))
            .maxPartitionCount(maxPartitionCount.applyValue({ args0 -> args0 }))
            .minPartitionCount(minPartitionCount.applyValue({ args0 -> args0 }))
            .scaleIncrement(scaleIncrement.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AddRemoveIncrementalNamedPartitionScalingMechanismArgs].
 */
@PulumiTagMarker
public class AddRemoveIncrementalNamedPartitionScalingMechanismArgsBuilder internal constructor() {
    private var kind: Output<String>? = null

    private var maxPartitionCount: Output<Int>? = null

    private var minPartitionCount: Output<Int>? = null

    private var scaleIncrement: Output<Int>? = null

    /**
     * @param value Enumerates the ways that a service can be partitioned.
     * Expected value is 'AddRemoveIncrementalNamedPartition'.
     */
    @JvmName("aulajbjmfchikunc")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Maximum number of named partitions of the service.
     */
    @JvmName("fvfsjnptwltnynul")
    public suspend fun maxPartitionCount(`value`: Output<Int>) {
        this.maxPartitionCount = value
    }

    /**
     * @param value Minimum number of named partitions of the service.
     */
    @JvmName("xdiohteguyiclrtn")
    public suspend fun minPartitionCount(`value`: Output<Int>) {
        this.minPartitionCount = value
    }

    /**
     * @param value The number of instances to add or remove during a scaling operation.
     */
    @JvmName("ppbltbxphwkicfji")
    public suspend fun scaleIncrement(`value`: Output<Int>) {
        this.scaleIncrement = value
    }

    /**
     * @param value Enumerates the ways that a service can be partitioned.
     * Expected value is 'AddRemoveIncrementalNamedPartition'.
     */
    @JvmName("jfybypdcmgwgaafd")
    public suspend fun kind(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Maximum number of named partitions of the service.
     */
    @JvmName("fmkpmekqmrflejei")
    public suspend fun maxPartitionCount(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.maxPartitionCount = mapped
    }

    /**
     * @param value Minimum number of named partitions of the service.
     */
    @JvmName("fqtodlxwbuynelde")
    public suspend fun minPartitionCount(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.minPartitionCount = mapped
    }

    /**
     * @param value The number of instances to add or remove during a scaling operation.
     */
    @JvmName("tiivcfgjerdsjyko")
    public suspend fun scaleIncrement(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scaleIncrement = mapped
    }

    internal fun build(): AddRemoveIncrementalNamedPartitionScalingMechanismArgs =
        AddRemoveIncrementalNamedPartitionScalingMechanismArgs(
            kind = kind ?: throw PulumiNullFieldException("kind"),
            maxPartitionCount = maxPartitionCount ?: throw PulumiNullFieldException("maxPartitionCount"),
            minPartitionCount = minPartitionCount ?: throw PulumiNullFieldException("minPartitionCount"),
            scaleIncrement = scaleIncrement ?: throw PulumiNullFieldException("scaleIncrement"),
        )
}
