@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.inputs

import com.pulumi.azurenative.servicefabric.inputs.ClientCertificateArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Client certificate definition.
 * @property commonName Certificate common name.
 * @property isAdmin Indicates if the client certificate has admin access to the cluster. Non admin clients can perform only read only operations on the cluster.
 * @property issuerThumbprint Issuer thumbprint for the certificate. Only used together with CommonName.
 * @property thumbprint Certificate thumbprint.
 */
public data class ClientCertificateArgs(
    public val commonName: Output<String>? = null,
    public val isAdmin: Output<Boolean>,
    public val issuerThumbprint: Output<String>? = null,
    public val thumbprint: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.servicefabric.inputs.ClientCertificateArgs> {
    override fun toJava(): com.pulumi.azurenative.servicefabric.inputs.ClientCertificateArgs =
        com.pulumi.azurenative.servicefabric.inputs.ClientCertificateArgs.builder()
            .commonName(commonName?.applyValue({ args0 -> args0 }))
            .isAdmin(isAdmin.applyValue({ args0 -> args0 }))
            .issuerThumbprint(issuerThumbprint?.applyValue({ args0 -> args0 }))
            .thumbprint(thumbprint?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClientCertificateArgs].
 */
@PulumiTagMarker
public class ClientCertificateArgsBuilder internal constructor() {
    private var commonName: Output<String>? = null

    private var isAdmin: Output<Boolean>? = null

    private var issuerThumbprint: Output<String>? = null

    private var thumbprint: Output<String>? = null

    /**
     * @param value Certificate common name.
     */
    @JvmName("ougbffoxyrdcuvqj")
    public suspend fun commonName(`value`: Output<String>) {
        this.commonName = value
    }

    /**
     * @param value Indicates if the client certificate has admin access to the cluster. Non admin clients can perform only read only operations on the cluster.
     */
    @JvmName("ybivveordyveehyc")
    public suspend fun isAdmin(`value`: Output<Boolean>) {
        this.isAdmin = value
    }

    /**
     * @param value Issuer thumbprint for the certificate. Only used together with CommonName.
     */
    @JvmName("expwhwbqpdjbqaqo")
    public suspend fun issuerThumbprint(`value`: Output<String>) {
        this.issuerThumbprint = value
    }

    /**
     * @param value Certificate thumbprint.
     */
    @JvmName("ftuxxxvvcbkdiisv")
    public suspend fun thumbprint(`value`: Output<String>) {
        this.thumbprint = value
    }

    /**
     * @param value Certificate common name.
     */
    @JvmName("errjuicnhxfsljut")
    public suspend fun commonName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.commonName = mapped
    }

    /**
     * @param value Indicates if the client certificate has admin access to the cluster. Non admin clients can perform only read only operations on the cluster.
     */
    @JvmName("foadreglektummda")
    public suspend fun isAdmin(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.isAdmin = mapped
    }

    /**
     * @param value Issuer thumbprint for the certificate. Only used together with CommonName.
     */
    @JvmName("rhorexdscsawigfo")
    public suspend fun issuerThumbprint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.issuerThumbprint = mapped
    }

    /**
     * @param value Certificate thumbprint.
     */
    @JvmName("acqxnefoxayleyxn")
    public suspend fun thumbprint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.thumbprint = mapped
    }

    internal fun build(): ClientCertificateArgs = ClientCertificateArgs(
        commonName = commonName,
        isAdmin = isAdmin ?: throw PulumiNullFieldException("isAdmin"),
        issuerThumbprint = issuerThumbprint,
        thumbprint = thumbprint,
    )
}
