@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.inputs

import com.pulumi.azurenative.servicefabric.inputs.EndpointRangeDescriptionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Port range details
 * @property endPort End port of a range of ports
 * @property startPort Starting port of a range of ports
 */
public data class EndpointRangeDescriptionArgs(
    public val endPort: Output<Int>,
    public val startPort: Output<Int>,
) : ConvertibleToJava<com.pulumi.azurenative.servicefabric.inputs.EndpointRangeDescriptionArgs> {
    override fun toJava(): com.pulumi.azurenative.servicefabric.inputs.EndpointRangeDescriptionArgs =
        com.pulumi.azurenative.servicefabric.inputs.EndpointRangeDescriptionArgs.builder()
            .endPort(endPort.applyValue({ args0 -> args0 }))
            .startPort(startPort.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [EndpointRangeDescriptionArgs].
 */
@PulumiTagMarker
public class EndpointRangeDescriptionArgsBuilder internal constructor() {
    private var endPort: Output<Int>? = null

    private var startPort: Output<Int>? = null

    /**
     * @param value End port of a range of ports
     */
    @JvmName("lauvdhuehgomkkqo")
    public suspend fun endPort(`value`: Output<Int>) {
        this.endPort = value
    }

    /**
     * @param value Starting port of a range of ports
     */
    @JvmName("ijwsmaudxgxcvebi")
    public suspend fun startPort(`value`: Output<Int>) {
        this.startPort = value
    }

    /**
     * @param value End port of a range of ports
     */
    @JvmName("uxvohpljgfsxaalk")
    public suspend fun endPort(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endPort = mapped
    }

    /**
     * @param value Starting port of a range of ports
     */
    @JvmName("tehluohtanknotrw")
    public suspend fun startPort(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.startPort = mapped
    }

    internal fun build(): EndpointRangeDescriptionArgs = EndpointRangeDescriptionArgs(
        endPort = endPort ?: throw PulumiNullFieldException("endPort"),
        startPort = startPort ?: throw PulumiNullFieldException("startPort"),
    )
}
