@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.inputs

import com.pulumi.azurenative.servicefabric.inputs.IPTagArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * IPTag associated with the object.
 * @property ipTagType The IP tag type.
 * @property tag The value of the IP tag.
 */
public data class IPTagArgs(
    public val ipTagType: Output<String>,
    public val tag: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.servicefabric.inputs.IPTagArgs> {
    override fun toJava(): com.pulumi.azurenative.servicefabric.inputs.IPTagArgs =
        com.pulumi.azurenative.servicefabric.inputs.IPTagArgs.builder()
            .ipTagType(ipTagType.applyValue({ args0 -> args0 }))
            .tag(tag.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IPTagArgs].
 */
@PulumiTagMarker
public class IPTagArgsBuilder internal constructor() {
    private var ipTagType: Output<String>? = null

    private var tag: Output<String>? = null

    /**
     * @param value The IP tag type.
     */
    @JvmName("wbugfktyfqycscuk")
    public suspend fun ipTagType(`value`: Output<String>) {
        this.ipTagType = value
    }

    /**
     * @param value The value of the IP tag.
     */
    @JvmName("lfsucrnrthqbtgef")
    public suspend fun tag(`value`: Output<String>) {
        this.tag = value
    }

    /**
     * @param value The IP tag type.
     */
    @JvmName("fnpksrigusgdepdy")
    public suspend fun ipTagType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ipTagType = mapped
    }

    /**
     * @param value The value of the IP tag.
     */
    @JvmName("edmdbrpmvbuvrcjw")
    public suspend fun tag(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tag = mapped
    }

    internal fun build(): IPTagArgs = IPTagArgs(
        ipTagType = ipTagType ?: throw PulumiNullFieldException("ipTagType"),
        tag = tag ?: throw PulumiNullFieldException("tag"),
    )
}
