@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.inputs

import com.pulumi.azurenative.servicefabric.inputs.NamedPartitionSchemeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Describes the named partition scheme of the service.
 * @property names Array for the names of the partitions.
 * @property partitionScheme Enumerates the ways that a service can be partitioned.
 * Expected value is 'Named'.
 */
public data class NamedPartitionSchemeArgs(
    public val names: Output<List<String>>,
    public val partitionScheme: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.servicefabric.inputs.NamedPartitionSchemeArgs> {
    override fun toJava(): com.pulumi.azurenative.servicefabric.inputs.NamedPartitionSchemeArgs =
        com.pulumi.azurenative.servicefabric.inputs.NamedPartitionSchemeArgs.builder()
            .names(names.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .partitionScheme(partitionScheme.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NamedPartitionSchemeArgs].
 */
@PulumiTagMarker
public class NamedPartitionSchemeArgsBuilder internal constructor() {
    private var names: Output<List<String>>? = null

    private var partitionScheme: Output<String>? = null

    /**
     * @param value Array for the names of the partitions.
     */
    @JvmName("blhqnnoufrxjshff")
    public suspend fun names(`value`: Output<List<String>>) {
        this.names = value
    }

    @JvmName("tbfrjdomnalpmjyy")
    public suspend fun names(vararg values: Output<String>) {
        this.names = Output.all(values.asList())
    }

    /**
     * @param values Array for the names of the partitions.
     */
    @JvmName("vidpsmbbmynlmtek")
    public suspend fun names(values: List<Output<String>>) {
        this.names = Output.all(values)
    }

    /**
     * @param value Enumerates the ways that a service can be partitioned.
     * Expected value is 'Named'.
     */
    @JvmName("qfsriyioytmbirxy")
    public suspend fun partitionScheme(`value`: Output<String>) {
        this.partitionScheme = value
    }

    /**
     * @param value Array for the names of the partitions.
     */
    @JvmName("xqjxulxipfssxjkn")
    public suspend fun names(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.names = mapped
    }

    /**
     * @param values Array for the names of the partitions.
     */
    @JvmName("hbqvymhldxwcuqlg")
    public suspend fun names(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.names = mapped
    }

    /**
     * @param value Enumerates the ways that a service can be partitioned.
     * Expected value is 'Named'.
     */
    @JvmName("cqnkokreuompfvmv")
    public suspend fun partitionScheme(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.partitionScheme = mapped
    }

    internal fun build(): NamedPartitionSchemeArgs = NamedPartitionSchemeArgs(
        names = names ?: throw PulumiNullFieldException("names"),
        partitionScheme = partitionScheme ?: throw PulumiNullFieldException("partitionScheme"),
    )
}
