@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.inputs

import com.pulumi.azurenative.servicefabric.inputs.ServiceCorrelationArgs.builder
import com.pulumi.azurenative.servicefabric.kotlin.enums.ServiceCorrelationScheme
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Creates a particular correlation between services.
 * @property scheme The ServiceCorrelationScheme which describes the relationship between this service and the service specified via ServiceName.
 * @property serviceName The Arm Resource ID of the service that the correlation relationship is established with.
 */
public data class ServiceCorrelationArgs(
    public val scheme: Output<Either<String, ServiceCorrelationScheme>>,
    public val serviceName: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.servicefabric.inputs.ServiceCorrelationArgs> {
    override fun toJava(): com.pulumi.azurenative.servicefabric.inputs.ServiceCorrelationArgs =
        com.pulumi.azurenative.servicefabric.inputs.ServiceCorrelationArgs.builder()
            .scheme(
                scheme.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .serviceName(serviceName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceCorrelationArgs].
 */
@PulumiTagMarker
public class ServiceCorrelationArgsBuilder internal constructor() {
    private var scheme: Output<Either<String, ServiceCorrelationScheme>>? = null

    private var serviceName: Output<String>? = null

    /**
     * @param value The ServiceCorrelationScheme which describes the relationship between this service and the service specified via ServiceName.
     */
    @JvmName("hoseeiosoveprbhs")
    public suspend fun scheme(`value`: Output<Either<String, ServiceCorrelationScheme>>) {
        this.scheme = value
    }

    /**
     * @param value The Arm Resource ID of the service that the correlation relationship is established with.
     */
    @JvmName("jconelwkvgnewkjd")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value The ServiceCorrelationScheme which describes the relationship between this service and the service specified via ServiceName.
     */
    @JvmName("lwcysvrsljdcrmna")
    public suspend fun scheme(`value`: Either<String, ServiceCorrelationScheme>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scheme = mapped
    }

    /**
     * @param value The ServiceCorrelationScheme which describes the relationship between this service and the service specified via ServiceName.
     */
    @JvmName("ixhjtmaarugyhyuh")
    public fun scheme(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ServiceCorrelationScheme>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scheme = mapped
    }

    /**
     * @param value The ServiceCorrelationScheme which describes the relationship between this service and the service specified via ServiceName.
     */
    @JvmName("hfaidrgtasdxclcj")
    public fun scheme(`value`: ServiceCorrelationScheme) {
        val toBeMapped = Either.ofRight<String, ServiceCorrelationScheme>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scheme = mapped
    }

    /**
     * @param value The Arm Resource ID of the service that the correlation relationship is established with.
     */
    @JvmName("mthryubfcelrkeoo")
    public suspend fun serviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    internal fun build(): ServiceCorrelationArgs = ServiceCorrelationArgs(
        scheme = scheme ?: throw PulumiNullFieldException("scheme"),
        serviceName = serviceName ?: throw PulumiNullFieldException("serviceName"),
    )
}
