@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.inputs

import com.pulumi.azurenative.servicefabric.inputs.ServicePlacementInvalidDomainPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes the policy to be used for placement of a Service Fabric service where a particular fault or upgrade domain should not be used for placement of the instances or replicas of that service.
 * @property domainName The name of the domain that should not be used for placement.
 * @property type The type of placement policy for a service fabric service. Following are the possible values.
 * Expected value is 'InvalidDomain'.
 */
public data class ServicePlacementInvalidDomainPolicyArgs(
    public val domainName: Output<String>,
    public val type: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.servicefabric.inputs.ServicePlacementInvalidDomainPolicyArgs> {
    override fun toJava():
        com.pulumi.azurenative.servicefabric.inputs.ServicePlacementInvalidDomainPolicyArgs =
        com.pulumi.azurenative.servicefabric.inputs.ServicePlacementInvalidDomainPolicyArgs.builder()
            .domainName(domainName.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServicePlacementInvalidDomainPolicyArgs].
 */
@PulumiTagMarker
public class ServicePlacementInvalidDomainPolicyArgsBuilder internal constructor() {
    private var domainName: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value The name of the domain that should not be used for placement.
     */
    @JvmName("didqqrrbeuetsxui")
    public suspend fun domainName(`value`: Output<String>) {
        this.domainName = value
    }

    /**
     * @param value The type of placement policy for a service fabric service. Following are the possible values.
     * Expected value is 'InvalidDomain'.
     */
    @JvmName("xjsgtoolpwhcfybs")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The name of the domain that should not be used for placement.
     */
    @JvmName("mbflawuorjikjxem")
    public suspend fun domainName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.domainName = mapped
    }

    /**
     * @param value The type of placement policy for a service fabric service. Following are the possible values.
     * Expected value is 'InvalidDomain'.
     */
    @JvmName("opiagkjwnkmtadon")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ServicePlacementInvalidDomainPolicyArgs =
        ServicePlacementInvalidDomainPolicyArgs(
            domainName = domainName ?: throw PulumiNullFieldException("domainName"),
            type = type ?: throw PulumiNullFieldException("type"),
        )
}
