@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.inputs

import com.pulumi.azurenative.servicefabric.inputs.StatelessServicePropertiesArgs.builder
import com.pulumi.azurenative.servicefabric.kotlin.enums.MoveCost
import com.pulumi.azurenative.servicefabric.kotlin.enums.ServicePackageActivationMode
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The properties of a stateless service resource.
 * @property correlationScheme A list that describes the correlation of the service with other services.
 * @property defaultMoveCost Specifies the move cost for the service.
 * @property instanceCount The instance count.
 * @property minInstanceCount MinInstanceCount is the minimum number of instances that must be up to meet the EnsureAvailability safety check during operations like upgrade or deactivate node. The actual number that is used is max( MinInstanceCount, ceil( MinInstancePercentage/100.0 * InstanceCount) ). Note, if InstanceCount is set to -1, during MinInstanceCount computation -1 is first converted into the number of nodes on which the instances are allowed to be placed according to the placement constraints on the service.
 * @property minInstancePercentage MinInstancePercentage is the minimum percentage of InstanceCount that must be up to meet the EnsureAvailability safety check during operations like upgrade or deactivate node. The actual number that is used is max( MinInstanceCount, ceil( MinInstancePercentage/100.0 * InstanceCount) ). Note, if InstanceCount is set to -1, during MinInstancePercentage computation, -1 is first converted into the number of nodes on which the instances are allowed to be placed according to the placement constraints on the service.
 * @property partitionDescription Describes how the service is partitioned.
 * @property placementConstraints The placement constraints as a string. Placement constraints are boolean expressions on node properties and allow for restricting a service to particular nodes based on the service requirements. For example, to place a service on nodes where NodeType is blue specify the following: "NodeColor == blue)".
 * @property scalingPolicies Scaling policies for this service.
 * @property serviceDnsName Dns name used for the service. If this is specified, then the DNS name can be used to return the IP addresses of service endpoints for application layer protocols (e.g., HTTP).
 * When updating serviceDnsName, old name may be temporarily resolvable. However, rely on new name.
 * When removing serviceDnsName, removed name may temporarily be resolvable. Do not rely on the name being unresolvable.
 * @property serviceKind The kind of service (Stateless or Stateful).
 * Expected value is 'Stateless'.
 * @property serviceLoadMetrics The service load metrics is given as an array of ServiceLoadMetric objects.
 * @property servicePackageActivationMode The activation Mode of the service package
 * @property servicePlacementPolicies A list that describes the correlation of the service with other services.
 * @property serviceTypeName The name of the service type
 */
public data class StatelessServicePropertiesArgs(
    public val correlationScheme: Output<List<ServiceCorrelationArgs>>? = null,
    public val defaultMoveCost: Output<Either<String, MoveCost>>? = null,
    public val instanceCount: Output<Int>,
    public val minInstanceCount: Output<Int>? = null,
    public val minInstancePercentage: Output<Int>? = null,
    public val partitionDescription: Output<Any>,
    public val placementConstraints: Output<String>? = null,
    public val scalingPolicies: Output<List<ScalingPolicyArgs>>? = null,
    public val serviceDnsName: Output<String>? = null,
    public val serviceKind: Output<String>,
    public val serviceLoadMetrics: Output<List<ServiceLoadMetricArgs>>? = null,
    public val servicePackageActivationMode: Output<Either<String, ServicePackageActivationMode>>? =
        null,
    public val servicePlacementPolicies: Output<List<Any>>? = null,
    public val serviceTypeName: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.servicefabric.inputs.StatelessServicePropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.servicefabric.inputs.StatelessServicePropertiesArgs =
        com.pulumi.azurenative.servicefabric.inputs.StatelessServicePropertiesArgs.builder()
            .correlationScheme(
                correlationScheme?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .defaultMoveCost(
                defaultMoveCost?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .instanceCount(instanceCount.applyValue({ args0 -> args0 }))
            .minInstanceCount(minInstanceCount?.applyValue({ args0 -> args0 }))
            .minInstancePercentage(minInstancePercentage?.applyValue({ args0 -> args0 }))
            .partitionDescription(partitionDescription.applyValue({ args0 -> args0 }))
            .placementConstraints(placementConstraints?.applyValue({ args0 -> args0 }))
            .scalingPolicies(
                scalingPolicies?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .serviceDnsName(serviceDnsName?.applyValue({ args0 -> args0 }))
            .serviceKind(serviceKind.applyValue({ args0 -> args0 }))
            .serviceLoadMetrics(
                serviceLoadMetrics?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .servicePackageActivationMode(
                servicePackageActivationMode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .servicePlacementPolicies(
                servicePlacementPolicies?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .serviceTypeName(serviceTypeName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [StatelessServicePropertiesArgs].
 */
@PulumiTagMarker
public class StatelessServicePropertiesArgsBuilder internal constructor() {
    private var correlationScheme: Output<List<ServiceCorrelationArgs>>? = null

    private var defaultMoveCost: Output<Either<String, MoveCost>>? = null

    private var instanceCount: Output<Int>? = null

    private var minInstanceCount: Output<Int>? = null

    private var minInstancePercentage: Output<Int>? = null

    private var partitionDescription: Output<Any>? = null

    private var placementConstraints: Output<String>? = null

    private var scalingPolicies: Output<List<ScalingPolicyArgs>>? = null

    private var serviceDnsName: Output<String>? = null

    private var serviceKind: Output<String>? = null

    private var serviceLoadMetrics: Output<List<ServiceLoadMetricArgs>>? = null

    private var servicePackageActivationMode: Output<Either<String, ServicePackageActivationMode>>? =
        null

    private var servicePlacementPolicies: Output<List<Any>>? = null

    private var serviceTypeName: Output<String>? = null

    /**
     * @param value A list that describes the correlation of the service with other services.
     */
    @JvmName("ycjrksvhujydgxsp")
    public suspend fun correlationScheme(`value`: Output<List<ServiceCorrelationArgs>>) {
        this.correlationScheme = value
    }

    @JvmName("eegfblnkjlmwhcey")
    public suspend fun correlationScheme(vararg values: Output<ServiceCorrelationArgs>) {
        this.correlationScheme = Output.all(values.asList())
    }

    /**
     * @param values A list that describes the correlation of the service with other services.
     */
    @JvmName("bbnffymvgomkjmib")
    public suspend fun correlationScheme(values: List<Output<ServiceCorrelationArgs>>) {
        this.correlationScheme = Output.all(values)
    }

    /**
     * @param value Specifies the move cost for the service.
     */
    @JvmName("hruecocqdipecvgm")
    public suspend fun defaultMoveCost(`value`: Output<Either<String, MoveCost>>) {
        this.defaultMoveCost = value
    }

    /**
     * @param value The instance count.
     */
    @JvmName("wvtofsfhibtcwdcl")
    public suspend fun instanceCount(`value`: Output<Int>) {
        this.instanceCount = value
    }

    /**
     * @param value MinInstanceCount is the minimum number of instances that must be up to meet the EnsureAvailability safety check during operations like upgrade or deactivate node. The actual number that is used is max( MinInstanceCount, ceil( MinInstancePercentage/100.0 * InstanceCount) ). Note, if InstanceCount is set to -1, during MinInstanceCount computation -1 is first converted into the number of nodes on which the instances are allowed to be placed according to the placement constraints on the service.
     */
    @JvmName("rmqtisdbidhmyedh")
    public suspend fun minInstanceCount(`value`: Output<Int>) {
        this.minInstanceCount = value
    }

    /**
     * @param value MinInstancePercentage is the minimum percentage of InstanceCount that must be up to meet the EnsureAvailability safety check during operations like upgrade or deactivate node. The actual number that is used is max( MinInstanceCount, ceil( MinInstancePercentage/100.0 * InstanceCount) ). Note, if InstanceCount is set to -1, during MinInstancePercentage computation, -1 is first converted into the number of nodes on which the instances are allowed to be placed according to the placement constraints on the service.
     */
    @JvmName("anxnmdyslityuohx")
    public suspend fun minInstancePercentage(`value`: Output<Int>) {
        this.minInstancePercentage = value
    }

    /**
     * @param value Describes how the service is partitioned.
     */
    @JvmName("mrjnyrieqvunjqvf")
    public suspend fun partitionDescription(`value`: Output<Any>) {
        this.partitionDescription = value
    }

    /**
     * @param value The placement constraints as a string. Placement constraints are boolean expressions on node properties and allow for restricting a service to particular nodes based on the service requirements. For example, to place a service on nodes where NodeType is blue specify the following: "NodeColor == blue)".
     */
    @JvmName("kiufdeywcqkaqikf")
    public suspend fun placementConstraints(`value`: Output<String>) {
        this.placementConstraints = value
    }

    /**
     * @param value Scaling policies for this service.
     */
    @JvmName("rhmvkefutopuomyx")
    public suspend fun scalingPolicies(`value`: Output<List<ScalingPolicyArgs>>) {
        this.scalingPolicies = value
    }

    @JvmName("qoneivetvcdnembi")
    public suspend fun scalingPolicies(vararg values: Output<ScalingPolicyArgs>) {
        this.scalingPolicies = Output.all(values.asList())
    }

    /**
     * @param values Scaling policies for this service.
     */
    @JvmName("fesdveocutsgrmhc")
    public suspend fun scalingPolicies(values: List<Output<ScalingPolicyArgs>>) {
        this.scalingPolicies = Output.all(values)
    }

    /**
     * @param value Dns name used for the service. If this is specified, then the DNS name can be used to return the IP addresses of service endpoints for application layer protocols (e.g., HTTP).
     * When updating serviceDnsName, old name may be temporarily resolvable. However, rely on new name.
     * When removing serviceDnsName, removed name may temporarily be resolvable. Do not rely on the name being unresolvable.
     */
    @JvmName("skagcusvvqtllduv")
    public suspend fun serviceDnsName(`value`: Output<String>) {
        this.serviceDnsName = value
    }

    /**
     * @param value The kind of service (Stateless or Stateful).
     * Expected value is 'Stateless'.
     */
    @JvmName("vfnkiplwjhwxfaad")
    public suspend fun serviceKind(`value`: Output<String>) {
        this.serviceKind = value
    }

    /**
     * @param value The service load metrics is given as an array of ServiceLoadMetric objects.
     */
    @JvmName("rwysohqawdlaaddk")
    public suspend fun serviceLoadMetrics(`value`: Output<List<ServiceLoadMetricArgs>>) {
        this.serviceLoadMetrics = value
    }

    @JvmName("trjdlgnstpdqtjan")
    public suspend fun serviceLoadMetrics(vararg values: Output<ServiceLoadMetricArgs>) {
        this.serviceLoadMetrics = Output.all(values.asList())
    }

    /**
     * @param values The service load metrics is given as an array of ServiceLoadMetric objects.
     */
    @JvmName("jitqivsobxivtjce")
    public suspend fun serviceLoadMetrics(values: List<Output<ServiceLoadMetricArgs>>) {
        this.serviceLoadMetrics = Output.all(values)
    }

    /**
     * @param value The activation Mode of the service package
     */
    @JvmName("wtemeuwbavcnfakq")
    public suspend
    fun servicePackageActivationMode(`value`: Output<Either<String, ServicePackageActivationMode>>) {
        this.servicePackageActivationMode = value
    }

    /**
     * @param value A list that describes the correlation of the service with other services.
     */
    @JvmName("gaxbjehgforqsivm")
    public suspend fun servicePlacementPolicies(`value`: Output<List<Any>>) {
        this.servicePlacementPolicies = value
    }

    @JvmName("jasoacambhbgjtfw")
    public suspend fun servicePlacementPolicies(vararg values: Output<Any>) {
        this.servicePlacementPolicies = Output.all(values.asList())
    }

    /**
     * @param values A list that describes the correlation of the service with other services.
     */
    @JvmName("fiwpkcndiretnncd")
    public suspend fun servicePlacementPolicies(values: List<Output<Any>>) {
        this.servicePlacementPolicies = Output.all(values)
    }

    /**
     * @param value The name of the service type
     */
    @JvmName("quadjxxaajlydmnp")
    public suspend fun serviceTypeName(`value`: Output<String>) {
        this.serviceTypeName = value
    }

    /**
     * @param value A list that describes the correlation of the service with other services.
     */
    @JvmName("jcwlxwrlkpocroxi")
    public suspend fun correlationScheme(`value`: List<ServiceCorrelationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.correlationScheme = mapped
    }

    /**
     * @param argument A list that describes the correlation of the service with other services.
     */
    @JvmName("owiigrqpbvhcukgg")
    public suspend
    fun correlationScheme(argument: List<suspend ServiceCorrelationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ServiceCorrelationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.correlationScheme = mapped
    }

    /**
     * @param argument A list that describes the correlation of the service with other services.
     */
    @JvmName("obckebmgfnglsmhm")
    public suspend fun correlationScheme(
        vararg
        argument: suspend ServiceCorrelationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ServiceCorrelationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.correlationScheme = mapped
    }

    /**
     * @param argument A list that describes the correlation of the service with other services.
     */
    @JvmName("iwgqexgyfodagvhv")
    public suspend fun correlationScheme(argument: suspend ServiceCorrelationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ServiceCorrelationArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.correlationScheme = mapped
    }

    /**
     * @param values A list that describes the correlation of the service with other services.
     */
    @JvmName("kpthtongrfrartkk")
    public suspend fun correlationScheme(vararg values: ServiceCorrelationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.correlationScheme = mapped
    }

    /**
     * @param value Specifies the move cost for the service.
     */
    @JvmName("jwisiommqwgdwfeo")
    public suspend fun defaultMoveCost(`value`: Either<String, MoveCost>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultMoveCost = mapped
    }

    /**
     * @param value Specifies the move cost for the service.
     */
    @JvmName("rmqjnpkokhaespng")
    public fun defaultMoveCost(`value`: String) {
        val toBeMapped = Either.ofLeft<String, MoveCost>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.defaultMoveCost = mapped
    }

    /**
     * @param value Specifies the move cost for the service.
     */
    @JvmName("aifnjtleqfolhgya")
    public fun defaultMoveCost(`value`: MoveCost) {
        val toBeMapped = Either.ofRight<String, MoveCost>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.defaultMoveCost = mapped
    }

    /**
     * @param value The instance count.
     */
    @JvmName("lmiwaowyuwrlfpnw")
    public suspend fun instanceCount(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instanceCount = mapped
    }

    /**
     * @param value MinInstanceCount is the minimum number of instances that must be up to meet the EnsureAvailability safety check during operations like upgrade or deactivate node. The actual number that is used is max( MinInstanceCount, ceil( MinInstancePercentage/100.0 * InstanceCount) ). Note, if InstanceCount is set to -1, during MinInstanceCount computation -1 is first converted into the number of nodes on which the instances are allowed to be placed according to the placement constraints on the service.
     */
    @JvmName("xshrlcbblsrbtkfw")
    public suspend fun minInstanceCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minInstanceCount = mapped
    }

    /**
     * @param value MinInstancePercentage is the minimum percentage of InstanceCount that must be up to meet the EnsureAvailability safety check during operations like upgrade or deactivate node. The actual number that is used is max( MinInstanceCount, ceil( MinInstancePercentage/100.0 * InstanceCount) ). Note, if InstanceCount is set to -1, during MinInstancePercentage computation, -1 is first converted into the number of nodes on which the instances are allowed to be placed according to the placement constraints on the service.
     */
    @JvmName("gemjbybrpyuoxmkp")
    public suspend fun minInstancePercentage(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minInstancePercentage = mapped
    }

    /**
     * @param value Describes how the service is partitioned.
     */
    @JvmName("lqmmxxnpseenwjmv")
    public suspend fun partitionDescription(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.partitionDescription = mapped
    }

    /**
     * @param value The placement constraints as a string. Placement constraints are boolean expressions on node properties and allow for restricting a service to particular nodes based on the service requirements. For example, to place a service on nodes where NodeType is blue specify the following: "NodeColor == blue)".
     */
    @JvmName("igohgcbcwwemdbej")
    public suspend fun placementConstraints(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.placementConstraints = mapped
    }

    /**
     * @param value Scaling policies for this service.
     */
    @JvmName("xpwvjmugibfyexri")
    public suspend fun scalingPolicies(`value`: List<ScalingPolicyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scalingPolicies = mapped
    }

    /**
     * @param argument Scaling policies for this service.
     */
    @JvmName("obbwowcbvvdeiify")
    public suspend fun scalingPolicies(argument: List<suspend ScalingPolicyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ScalingPolicyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.scalingPolicies = mapped
    }

    /**
     * @param argument Scaling policies for this service.
     */
    @JvmName("dcssljduxgxsgfes")
    public suspend fun scalingPolicies(vararg argument: suspend ScalingPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ScalingPolicyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.scalingPolicies = mapped
    }

    /**
     * @param argument Scaling policies for this service.
     */
    @JvmName("ihtyrsowkuwargph")
    public suspend fun scalingPolicies(argument: suspend ScalingPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ScalingPolicyArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.scalingPolicies = mapped
    }

    /**
     * @param values Scaling policies for this service.
     */
    @JvmName("rpabuoguphiajeur")
    public suspend fun scalingPolicies(vararg values: ScalingPolicyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.scalingPolicies = mapped
    }

    /**
     * @param value Dns name used for the service. If this is specified, then the DNS name can be used to return the IP addresses of service endpoints for application layer protocols (e.g., HTTP).
     * When updating serviceDnsName, old name may be temporarily resolvable. However, rely on new name.
     * When removing serviceDnsName, removed name may temporarily be resolvable. Do not rely on the name being unresolvable.
     */
    @JvmName("mayaloowoxhitmtp")
    public suspend fun serviceDnsName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceDnsName = mapped
    }

    /**
     * @param value The kind of service (Stateless or Stateful).
     * Expected value is 'Stateless'.
     */
    @JvmName("hcdhulyctrwpwfcb")
    public suspend fun serviceKind(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serviceKind = mapped
    }

    /**
     * @param value The service load metrics is given as an array of ServiceLoadMetric objects.
     */
    @JvmName("gffvlctqygotdynt")
    public suspend fun serviceLoadMetrics(`value`: List<ServiceLoadMetricArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceLoadMetrics = mapped
    }

    /**
     * @param argument The service load metrics is given as an array of ServiceLoadMetric objects.
     */
    @JvmName("xhwyxdlkqfuoxfpn")
    public suspend
    fun serviceLoadMetrics(argument: List<suspend ServiceLoadMetricArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ServiceLoadMetricArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.serviceLoadMetrics = mapped
    }

    /**
     * @param argument The service load metrics is given as an array of ServiceLoadMetric objects.
     */
    @JvmName("xnjjrgbhdklvwiyt")
    public suspend fun serviceLoadMetrics(
        vararg
        argument: suspend ServiceLoadMetricArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ServiceLoadMetricArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.serviceLoadMetrics = mapped
    }

    /**
     * @param argument The service load metrics is given as an array of ServiceLoadMetric objects.
     */
    @JvmName("rxtcndefxxbnplis")
    public suspend fun serviceLoadMetrics(argument: suspend ServiceLoadMetricArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ServiceLoadMetricArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.serviceLoadMetrics = mapped
    }

    /**
     * @param values The service load metrics is given as an array of ServiceLoadMetric objects.
     */
    @JvmName("bnaktjuowtlhyoiq")
    public suspend fun serviceLoadMetrics(vararg values: ServiceLoadMetricArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serviceLoadMetrics = mapped
    }

    /**
     * @param value The activation Mode of the service package
     */
    @JvmName("lhyqjsncadviqedt")
    public suspend
    fun servicePackageActivationMode(`value`: Either<String, ServicePackageActivationMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.servicePackageActivationMode = mapped
    }

    /**
     * @param value The activation Mode of the service package
     */
    @JvmName("hqchxfkvwcfrmxtd")
    public fun servicePackageActivationMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ServicePackageActivationMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.servicePackageActivationMode = mapped
    }

    /**
     * @param value The activation Mode of the service package
     */
    @JvmName("mvvhhmmoacaeciqt")
    public fun servicePackageActivationMode(`value`: ServicePackageActivationMode) {
        val toBeMapped = Either.ofRight<String, ServicePackageActivationMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.servicePackageActivationMode = mapped
    }

    /**
     * @param value A list that describes the correlation of the service with other services.
     */
    @JvmName("yhllkabrgbtaujnd")
    public suspend fun servicePlacementPolicies(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.servicePlacementPolicies = mapped
    }

    /**
     * @param values A list that describes the correlation of the service with other services.
     */
    @JvmName("xiocquttedwoslsa")
    public suspend fun servicePlacementPolicies(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.servicePlacementPolicies = mapped
    }

    /**
     * @param value The name of the service type
     */
    @JvmName("ikqgwqfbdfplecrt")
    public suspend fun serviceTypeName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serviceTypeName = mapped
    }

    internal fun build(): StatelessServicePropertiesArgs = StatelessServicePropertiesArgs(
        correlationScheme = correlationScheme,
        defaultMoveCost = defaultMoveCost,
        instanceCount = instanceCount ?: throw PulumiNullFieldException("instanceCount"),
        minInstanceCount = minInstanceCount,
        minInstancePercentage = minInstancePercentage,
        partitionDescription = partitionDescription ?: throw
            PulumiNullFieldException("partitionDescription"),
        placementConstraints = placementConstraints,
        scalingPolicies = scalingPolicies,
        serviceDnsName = serviceDnsName,
        serviceKind = serviceKind ?: throw PulumiNullFieldException("serviceKind"),
        serviceLoadMetrics = serviceLoadMetrics,
        servicePackageActivationMode = servicePackageActivationMode,
        servicePlacementPolicies = servicePlacementPolicies,
        serviceTypeName = serviceTypeName ?: throw PulumiNullFieldException("serviceTypeName"),
    )
}
