@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.inputs

import com.pulumi.azurenative.servicefabric.inputs.UniformInt64RangePartitionSchemeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes a partitioning scheme where an integer range is allocated evenly across a number of partitions.
 * @property count The number of partitions.
 * @property highKey The upper bound of the partition key range that
 * should be split between the partition ‘Count’
 * @property lowKey The lower bound of the partition key range that
 * should be split between the partition ‘Count’
 * @property partitionScheme Enumerates the ways that a service can be partitioned.
 * Expected value is 'UniformInt64Range'.
 */
public data class UniformInt64RangePartitionSchemeArgs(
    public val count: Output<Int>,
    public val highKey: Output<Double>,
    public val lowKey: Output<Double>,
    public val partitionScheme: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.servicefabric.inputs.UniformInt64RangePartitionSchemeArgs> {
    override fun toJava():
        com.pulumi.azurenative.servicefabric.inputs.UniformInt64RangePartitionSchemeArgs =
        com.pulumi.azurenative.servicefabric.inputs.UniformInt64RangePartitionSchemeArgs.builder()
            .count(count.applyValue({ args0 -> args0 }))
            .highKey(highKey.applyValue({ args0 -> args0 }))
            .lowKey(lowKey.applyValue({ args0 -> args0 }))
            .partitionScheme(partitionScheme.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UniformInt64RangePartitionSchemeArgs].
 */
@PulumiTagMarker
public class UniformInt64RangePartitionSchemeArgsBuilder internal constructor() {
    private var count: Output<Int>? = null

    private var highKey: Output<Double>? = null

    private var lowKey: Output<Double>? = null

    private var partitionScheme: Output<String>? = null

    /**
     * @param value The number of partitions.
     */
    @JvmName("hgisprrucjtccmvl")
    public suspend fun count(`value`: Output<Int>) {
        this.count = value
    }

    /**
     * @param value The upper bound of the partition key range that
     * should be split between the partition ‘Count’
     */
    @JvmName("morvmfhcjdkcyoqj")
    public suspend fun highKey(`value`: Output<Double>) {
        this.highKey = value
    }

    /**
     * @param value The lower bound of the partition key range that
     * should be split between the partition ‘Count’
     */
    @JvmName("axjsejrmkutselel")
    public suspend fun lowKey(`value`: Output<Double>) {
        this.lowKey = value
    }

    /**
     * @param value Enumerates the ways that a service can be partitioned.
     * Expected value is 'UniformInt64Range'.
     */
    @JvmName("ksyjvecyregjucxg")
    public suspend fun partitionScheme(`value`: Output<String>) {
        this.partitionScheme = value
    }

    /**
     * @param value The number of partitions.
     */
    @JvmName("uebrksyrxvkxjxep")
    public suspend fun count(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.count = mapped
    }

    /**
     * @param value The upper bound of the partition key range that
     * should be split between the partition ‘Count’
     */
    @JvmName("ueybodrgplruwjkh")
    public suspend fun highKey(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.highKey = mapped
    }

    /**
     * @param value The lower bound of the partition key range that
     * should be split between the partition ‘Count’
     */
    @JvmName("ctrucobfnowhhliw")
    public suspend fun lowKey(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.lowKey = mapped
    }

    /**
     * @param value Enumerates the ways that a service can be partitioned.
     * Expected value is 'UniformInt64Range'.
     */
    @JvmName("pcbiqyrvboqhfdhj")
    public suspend fun partitionScheme(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.partitionScheme = mapped
    }

    internal fun build(): UniformInt64RangePartitionSchemeArgs = UniformInt64RangePartitionSchemeArgs(
        count = count ?: throw PulumiNullFieldException("count"),
        highKey = highKey ?: throw PulumiNullFieldException("highKey"),
        lowKey = lowKey ?: throw PulumiNullFieldException("lowKey"),
        partitionScheme = partitionScheme ?: throw PulumiNullFieldException("partitionScheme"),
    )
}
