@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Describes a node type sku.
 * @property capacity The number of nodes in the node type.<br /><br />If present in request it will override properties.vmInstanceCount.
 * @property name The sku name. <br /><br />Name is internally generated and is used in auto-scale scenarios.<br /> Property does not allow to be changed to other values than generated.<br /> To avoid deployment errors please omit the property.
 * @property tier Specifies the tier of the node type. <br /><br /> Possible Values:<br /> **Standard**
 */
public data class NodeTypeSkuResponse(
    public val capacity: Int,
    public val name: String? = null,
    public val tier: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.servicefabric.outputs.NodeTypeSkuResponse):
            NodeTypeSkuResponse = NodeTypeSkuResponse(
            capacity = javaType.capacity(),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            tier = javaType.tier().map({ args0 -> args0 }).orElse(null),
        )
    }
}
