@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The policy used for monitoring the application upgrade
 * @property failureAction The compensating action to perform when a Monitored upgrade encounters monitoring policy or health policy violations. Invalid indicates the failure action is invalid. Rollback specifies that the upgrade will start rolling back automatically. Manual indicates that the upgrade will switch to UnmonitoredManual upgrade mode.
 * @property healthCheckRetryTimeout The amount of time to retry health evaluation when the application or cluster is unhealthy before FailureAction is executed. It is interpreted as a string representing an ISO 8601 duration with following format "hh:mm:ss.fff".
 * @property healthCheckStableDuration The amount of time that the application or cluster must remain healthy before the upgrade proceeds to the next upgrade domain. It is interpreted as a string representing an ISO 8601 duration with following format "hh:mm:ss.fff".
 * @property healthCheckWaitDuration The amount of time to wait after completing an upgrade domain before applying health policies. It is interpreted as a string representing an ISO 8601 duration with following format "hh:mm:ss.fff".
 * @property upgradeDomainTimeout The amount of time each upgrade domain has to complete before FailureAction is executed. Cannot be larger than 12 hours. It is interpreted as a string representing an ISO 8601 duration with following format "hh:mm:ss.fff".
 * @property upgradeTimeout The amount of time the overall upgrade has to complete before FailureAction is executed. Cannot be larger than 12 hours. It is interpreted as a string representing an ISO 8601 duration with following format "hh:mm:ss.fff".
 */
public data class RollingUpgradeMonitoringPolicyResponse(
    public val failureAction: String,
    public val healthCheckRetryTimeout: String,
    public val healthCheckStableDuration: String,
    public val healthCheckWaitDuration: String,
    public val upgradeDomainTimeout: String,
    public val upgradeTimeout: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.servicefabric.outputs.RollingUpgradeMonitoringPolicyResponse):
            RollingUpgradeMonitoringPolicyResponse = RollingUpgradeMonitoringPolicyResponse(
            failureAction = javaType.failureAction(),
            healthCheckRetryTimeout = javaType.healthCheckRetryTimeout(),
            healthCheckStableDuration = javaType.healthCheckStableDuration(),
            healthCheckWaitDuration = javaType.healthCheckWaitDuration(),
            upgradeDomainTimeout = javaType.upgradeDomainTimeout(),
            upgradeTimeout = javaType.upgradeTimeout(),
        )
    }
}
