@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The service endpoint properties.
 * @property locations A list of locations.
 * @property service The type of the endpoint service.
 */
public data class ServiceEndpointResponse(
    public val locations: List<String>? = null,
    public val service: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.servicefabric.outputs.ServiceEndpointResponse):
            ServiceEndpointResponse = ServiceEndpointResponse(
            locations = javaType.locations().map({ args0 -> args0 }),
            service = javaType.service(),
        )
    }
}
