@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.outputs

import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Describes a partitioning scheme where an integer range is allocated evenly across a number of partitions.
 * @property count The number of partitions.
 * @property highKey The upper bound of the partition key range that
 * should be split between the partition ‘Count’
 * @property lowKey The lower bound of the partition key range that
 * should be split between the partition ‘Count’
 * @property partitionScheme Enumerates the ways that a service can be partitioned.
 * Expected value is 'UniformInt64Range'.
 */
public data class UniformInt64RangePartitionSchemeResponse(
    public val count: Int,
    public val highKey: Double,
    public val lowKey: Double,
    public val partitionScheme: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.servicefabric.outputs.UniformInt64RangePartitionSchemeResponse):
            UniformInt64RangePartitionSchemeResponse = UniformInt64RangePartitionSchemeResponse(
            count = javaType.count(),
            highKey = javaType.highKey(),
            lowKey = javaType.lowKey(),
            partitionScheme = javaType.partitionScheme(),
        )
    }
}
