@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabric.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * Specifies set of certificates that should be installed onto the virtual machines.
 * @property sourceVault The relative URL of the Key Vault containing all of the certificates in VaultCertificates.
 * @property vaultCertificates The list of key vault references in SourceVault which contain certificates.
 */
public data class VaultSecretGroupResponse(
    public val sourceVault: SubResourceResponse,
    public val vaultCertificates: List<VaultCertificateResponse>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.servicefabric.outputs.VaultSecretGroupResponse):
            VaultSecretGroupResponse = VaultSecretGroupResponse(
            sourceVault = javaType.sourceVault().let({ args0 ->
                com.pulumi.azurenative.servicefabric.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
            }),
            vaultCertificates = javaType.vaultCertificates().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.servicefabric.kotlin.outputs.VaultCertificateResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
