@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabricmesh.kotlin

import com.pulumi.azurenative.servicefabricmesh.kotlin.outputs.HttpConfigResponse
import com.pulumi.azurenative.servicefabricmesh.kotlin.outputs.NetworkRefResponse
import com.pulumi.azurenative.servicefabricmesh.kotlin.outputs.TcpConfigResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.servicefabricmesh.kotlin.outputs.HttpConfigResponse.Companion.toKotlin as httpConfigResponseToKotlin
import com.pulumi.azurenative.servicefabricmesh.kotlin.outputs.NetworkRefResponse.Companion.toKotlin as networkRefResponseToKotlin
import com.pulumi.azurenative.servicefabricmesh.kotlin.outputs.TcpConfigResponse.Companion.toKotlin as tcpConfigResponseToKotlin

/**
 * Builder for [Gateway].
 */
@PulumiTagMarker
public class GatewayResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GatewayArgs = GatewayArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend GatewayArgsBuilder.() -> Unit) {
        val builder = GatewayArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Gateway {
        val builtJavaResource =
            com.pulumi.azurenative.servicefabricmesh.Gateway(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return Gateway(builtJavaResource)
    }
}

/**
 * This type describes a gateway resource.
 * Azure REST API version: 2018-09-01-preview. Prior API version in Azure Native 1.x: 2018-09-01-preview.
 * ## Example Usage
 * ### CreateOrUpdateGateway
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var gateway = new AzureNative.ServiceFabricMesh.Gateway("gateway", new()
 *     {
 *         Description = "Service Fabric Mesh sample gateway.",
 *         DestinationNetwork = new AzureNative.ServiceFabricMesh.Inputs.NetworkRefArgs
 *         {
 *             Name = "helloWorldNetwork",
 *         },
 *         GatewayResourceName = "sampleGateway",
 *         Http = new[]
 *         {
 *             new AzureNative.ServiceFabricMesh.Inputs.HttpConfigArgs
 *             {
 *                 Hosts = new[]
 *                 {
 *                     new AzureNative.ServiceFabricMesh.Inputs.HttpHostConfigArgs
 *                     {
 *                         Name = "contoso.com",
 *                         Routes = new[]
 *                         {
 *                             new AzureNative.ServiceFabricMesh.Inputs.HttpRouteConfigArgs
 *                             {
 *                                 Destination = new AzureNative.ServiceFabricMesh.Inputs.GatewayDestinationArgs
 *                                 {
 *                                     ApplicationName = "httpHelloWorldApp",
 *                                     EndpointName = "indexHttpEndpoint",
 *                                     ServiceName = "indexService",
 *                                 },
 *                                 Match = new AzureNative.ServiceFabricMesh.Inputs.HttpRouteMatchRuleArgs
 *                                 {
 *                                     Headers = new[]
 *                                     {
 *                                         new AzureNative.ServiceFabricMesh.Inputs.HttpRouteMatchHeaderArgs
 *                                         {
 *                                             Name = "accept",
 *                                             Type = AzureNative.ServiceFabricMesh.HeaderMatchType.Exact,
 *                                             Value = "application/json",
 *                                         },
 *                                     },
 *                                     Path = new AzureNative.ServiceFabricMesh.Inputs.HttpRouteMatchPathArgs
 *                                     {
 *                                         Rewrite = "/",
 *                                         Type = AzureNative.ServiceFabricMesh.PathMatchType.Prefix,
 *                                         Value = "/index",
 *                                     },
 *                                 },
 *                                 Name = "index",
 *                             },
 *                         },
 *                     },
 *                 },
 *                 Name = "contosoWebsite",
 *                 Port = 8081,
 *             },
 *         },
 *         Location = "EastUS",
 *         ResourceGroupName = "sbz_demo",
 *         SourceNetwork = new AzureNative.ServiceFabricMesh.Inputs.NetworkRefArgs
 *         {
 *             Name = "Open",
 *         },
 *         Tags = null,
 *         Tcp = new[]
 *         {
 *             new AzureNative.ServiceFabricMesh.Inputs.TcpConfigArgs
 *             {
 *                 Destination = new AzureNative.ServiceFabricMesh.Inputs.GatewayDestinationArgs
 *                 {
 *                     ApplicationName = "helloWorldApp",
 *                     EndpointName = "helloWorldListener",
 *                     ServiceName = "helloWorldService",
 *                 },
 *                 Name = "web",
 *                 Port = 80,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/servicefabricmesh/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := servicefabricmesh.NewGateway(ctx, "gateway", &servicefabricmesh.GatewayArgs{
 * 			Description: pulumi.String("Service Fabric Mesh sample gateway."),
 * 			DestinationNetwork: &servicefabricmesh.NetworkRefArgs{
 * 				Name: pulumi.String("helloWorldNetwork"),
 * 			},
 * 			GatewayResourceName: pulumi.String("sampleGateway"),
 * 			Http: servicefabricmesh.HttpConfigArray{
 * 				&servicefabricmesh.HttpConfigArgs{
 * 					Hosts: servicefabricmesh.HttpHostConfigArray{
 * 						&servicefabricmesh.HttpHostConfigArgs{
 * 							Name: pulumi.String("contoso.com"),
 * 							Routes: servicefabricmesh.HttpRouteConfigArray{
 * 								&servicefabricmesh.HttpRouteConfigArgs{
 * 									Destination: &servicefabricmesh.GatewayDestinationArgs{
 * 										ApplicationName: pulumi.String("httpHelloWorldApp"),
 * 										EndpointName:    pulumi.String("indexHttpEndpoint"),
 * 										ServiceName:     pulumi.String("indexService"),
 * 									},
 * 									Match: &servicefabricmesh.HttpRouteMatchRuleArgs{
 * 										Headers: servicefabricmesh.HttpRouteMatchHeaderArray{
 * 											&servicefabricmesh.HttpRouteMatchHeaderArgs{
 * 												Name:  pulumi.String("accept"),
 * 												Type:  pulumi.String(servicefabricmesh.HeaderMatchTypeExact),
 * 												Value: pulumi.String("application/json"),
 * 											},
 * 										},
 * 										Path: &servicefabricmesh.HttpRouteMatchPathArgs{
 * 											Rewrite: pulumi.String("/"),
 * 											Type:    pulumi.String(servicefabricmesh.PathMatchTypePrefix),
 * 											Value:   pulumi.String("/index"),
 * 										},
 * 									},
 * 									Name: pulumi.String("index"),
 * 								},
 * 							},
 * 						},
 * 					},
 * 					Name: pulumi.String("contosoWebsite"),
 * 					Port: pulumi.Int(8081),
 * 				},
 * 			},
 * 			Location:          pulumi.String("EastUS"),
 * 			ResourceGroupName: pulumi.String("sbz_demo"),
 * 			SourceNetwork: &servicefabricmesh.NetworkRefArgs{
 * 				Name: pulumi.String("Open"),
 * 			},
 * 			Tags: nil,
 * 			Tcp: servicefabricmesh.TcpConfigArray{
 * 				&servicefabricmesh.TcpConfigArgs{
 * 					Destination: &servicefabricmesh.GatewayDestinationArgs{
 * 						ApplicationName: pulumi.String("helloWorldApp"),
 * 						EndpointName:    pulumi.String("helloWorldListener"),
 * 						ServiceName:     pulumi.String("helloWorldService"),
 * 					},
 * 					Name: pulumi.String("web"),
 * 					Port: pulumi.Int(80),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.servicefabricmesh.Gateway;
 * import com.pulumi.azurenative.servicefabricmesh.GatewayArgs;
 * import com.pulumi.azurenative.servicefabricmesh.inputs.NetworkRefArgs;
 * import com.pulumi.azurenative.servicefabricmesh.inputs.HttpConfigArgs;
 * import com.pulumi.azurenative.servicefabricmesh.inputs.TcpConfigArgs;
 * import com.pulumi.azurenative.servicefabricmesh.inputs.GatewayDestinationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var gateway = new Gateway("gateway", GatewayArgs.builder()
 *             .description("Service Fabric Mesh sample gateway.")
 *             .destinationNetwork(NetworkRefArgs.builder()
 *                 .name("helloWorldNetwork")
 *                 .build())
 *             .gatewayResourceName("sampleGateway")
 *             .http(HttpConfigArgs.builder()
 *                 .hosts(HttpHostConfigArgs.builder()
 *                     .name("contoso.com")
 *                     .routes(HttpRouteConfigArgs.builder()
 *                         .destination(GatewayDestinationArgs.builder()
 *                             .applicationName("httpHelloWorldApp")
 *                             .endpointName("indexHttpEndpoint")
 *                             .serviceName("indexService")
 *                             .build())
 *                         .match(HttpRouteMatchRuleArgs.builder()
 *                             .headers(HttpRouteMatchHeaderArgs.builder()
 *                                 .name("accept")
 *                                 .type("exact")
 *                                 .value("application/json")
 *                                 .build())
 *                             .path(HttpRouteMatchPathArgs.builder()
 *                                 .rewrite("/")
 *                                 .type("prefix")
 *                                 .value("/index")
 *                                 .build())
 *                             .build())
 *                         .name("index")
 *                         .build())
 *                     .build())
 *                 .name("contosoWebsite")
 *                 .port(8081)
 *                 .build())
 *             .location("EastUS")
 *             .resourceGroupName("sbz_demo")
 *             .sourceNetwork(NetworkRefArgs.builder()
 *                 .name("Open")
 *                 .build())
 *             .tags()
 *             .tcp(TcpConfigArgs.builder()
 *                 .destination(GatewayDestinationArgs.builder()
 *                     .applicationName("helloWorldApp")
 *                     .endpointName("helloWorldListener")
 *                     .serviceName("helloWorldService")
 *                     .build())
 *                 .name("web")
 *                 .port(80)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:servicefabricmesh:Gateway sampleGateway /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceFabricMesh/gateways/{gatewayResourceName}
 * ```
 */
public class Gateway internal constructor(
    override val javaResource: com.pulumi.azurenative.servicefabricmesh.Gateway,
) : KotlinCustomResource(javaResource, GatewayMapper) {
    /**
     * User readable description of the gateway.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Network that the Application is using.
     */
    public val destinationNetwork: Output<NetworkRefResponse>
        get() = javaResource.destinationNetwork().applyValue({ args0 ->
            args0.let({ args0 ->
                networkRefResponseToKotlin(args0)
            })
        })

    /**
     * Configuration for http connectivity for this gateway.
     */
    public val http: Output<List<HttpConfigResponse>>?
        get() = javaResource.http().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> httpConfigResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * IP address of the gateway. This is populated in the response and is ignored for incoming requests.
     */
    public val ipAddress: Output<String>
        get() = javaResource.ipAddress().applyValue({ args0 -> args0 })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * State of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Network the gateway should listen on for requests.
     */
    public val sourceNetwork: Output<NetworkRefResponse>
        get() = javaResource.sourceNetwork().applyValue({ args0 ->
            args0.let({ args0 ->
                networkRefResponseToKotlin(args0)
            })
        })

    /**
     * Status of the resource.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Gives additional information about the current status of the gateway.
     */
    public val statusDetails: Output<String>
        get() = javaResource.statusDetails().applyValue({ args0 -> args0 })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Configuration for tcp connectivity for this gateway.
     */
    public val tcp: Output<List<TcpConfigResponse>>?
        get() = javaResource.tcp().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> tcpConfigResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object GatewayMapper : ResourceMapper<Gateway> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.servicefabricmesh.Gateway::class == javaResource::class

    override fun map(javaResource: Resource): Gateway = Gateway(
        javaResource as
            com.pulumi.azurenative.servicefabricmesh.Gateway,
    )
}

/**
 * @see [Gateway].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Gateway].
 */
public suspend fun gateway(name: String, block: suspend GatewayResourceBuilder.() -> Unit):
    Gateway {
    val builder = GatewayResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Gateway].
 * @param name The _unique_ name of the resulting resource.
 */
public fun gateway(name: String): Gateway {
    val builder = GatewayResourceBuilder()
    builder.name(name)
    return builder.build()
}
