@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabricmesh.kotlin

import com.pulumi.azurenative.servicefabricmesh.GatewayArgs.builder
import com.pulumi.azurenative.servicefabricmesh.kotlin.inputs.HttpConfigArgs
import com.pulumi.azurenative.servicefabricmesh.kotlin.inputs.HttpConfigArgsBuilder
import com.pulumi.azurenative.servicefabricmesh.kotlin.inputs.NetworkRefArgs
import com.pulumi.azurenative.servicefabricmesh.kotlin.inputs.NetworkRefArgsBuilder
import com.pulumi.azurenative.servicefabricmesh.kotlin.inputs.TcpConfigArgs
import com.pulumi.azurenative.servicefabricmesh.kotlin.inputs.TcpConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * This type describes a gateway resource.
 * Azure REST API version: 2018-09-01-preview. Prior API version in Azure Native 1.x: 2018-09-01-preview.
 * ## Example Usage
 * ### CreateOrUpdateGateway
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var gateway = new AzureNative.ServiceFabricMesh.Gateway("gateway", new()
 *     {
 *         Description = "Service Fabric Mesh sample gateway.",
 *         DestinationNetwork = new AzureNative.ServiceFabricMesh.Inputs.NetworkRefArgs
 *         {
 *             Name = "helloWorldNetwork",
 *         },
 *         GatewayResourceName = "sampleGateway",
 *         Http = new[]
 *         {
 *             new AzureNative.ServiceFabricMesh.Inputs.HttpConfigArgs
 *             {
 *                 Hosts = new[]
 *                 {
 *                     new AzureNative.ServiceFabricMesh.Inputs.HttpHostConfigArgs
 *                     {
 *                         Name = "contoso.com",
 *                         Routes = new[]
 *                         {
 *                             new AzureNative.ServiceFabricMesh.Inputs.HttpRouteConfigArgs
 *                             {
 *                                 Destination = new AzureNative.ServiceFabricMesh.Inputs.GatewayDestinationArgs
 *                                 {
 *                                     ApplicationName = "httpHelloWorldApp",
 *                                     EndpointName = "indexHttpEndpoint",
 *                                     ServiceName = "indexService",
 *                                 },
 *                                 Match = new AzureNative.ServiceFabricMesh.Inputs.HttpRouteMatchRuleArgs
 *                                 {
 *                                     Headers = new[]
 *                                     {
 *                                         new AzureNative.ServiceFabricMesh.Inputs.HttpRouteMatchHeaderArgs
 *                                         {
 *                                             Name = "accept",
 *                                             Type = AzureNative.ServiceFabricMesh.HeaderMatchType.Exact,
 *                                             Value = "application/json",
 *                                         },
 *                                     },
 *                                     Path = new AzureNative.ServiceFabricMesh.Inputs.HttpRouteMatchPathArgs
 *                                     {
 *                                         Rewrite = "/",
 *                                         Type = AzureNative.ServiceFabricMesh.PathMatchType.Prefix,
 *                                         Value = "/index",
 *                                     },
 *                                 },
 *                                 Name = "index",
 *                             },
 *                         },
 *                     },
 *                 },
 *                 Name = "contosoWebsite",
 *                 Port = 8081,
 *             },
 *         },
 *         Location = "EastUS",
 *         ResourceGroupName = "sbz_demo",
 *         SourceNetwork = new AzureNative.ServiceFabricMesh.Inputs.NetworkRefArgs
 *         {
 *             Name = "Open",
 *         },
 *         Tags = null,
 *         Tcp = new[]
 *         {
 *             new AzureNative.ServiceFabricMesh.Inputs.TcpConfigArgs
 *             {
 *                 Destination = new AzureNative.ServiceFabricMesh.Inputs.GatewayDestinationArgs
 *                 {
 *                     ApplicationName = "helloWorldApp",
 *                     EndpointName = "helloWorldListener",
 *                     ServiceName = "helloWorldService",
 *                 },
 *                 Name = "web",
 *                 Port = 80,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/servicefabricmesh/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := servicefabricmesh.NewGateway(ctx, "gateway", &servicefabricmesh.GatewayArgs{
 * 			Description: pulumi.String("Service Fabric Mesh sample gateway."),
 * 			DestinationNetwork: &servicefabricmesh.NetworkRefArgs{
 * 				Name: pulumi.String("helloWorldNetwork"),
 * 			},
 * 			GatewayResourceName: pulumi.String("sampleGateway"),
 * 			Http: servicefabricmesh.HttpConfigArray{
 * 				&servicefabricmesh.HttpConfigArgs{
 * 					Hosts: servicefabricmesh.HttpHostConfigArray{
 * 						&servicefabricmesh.HttpHostConfigArgs{
 * 							Name: pulumi.String("contoso.com"),
 * 							Routes: servicefabricmesh.HttpRouteConfigArray{
 * 								&servicefabricmesh.HttpRouteConfigArgs{
 * 									Destination: &servicefabricmesh.GatewayDestinationArgs{
 * 										ApplicationName: pulumi.String("httpHelloWorldApp"),
 * 										EndpointName:    pulumi.String("indexHttpEndpoint"),
 * 										ServiceName:     pulumi.String("indexService"),
 * 									},
 * 									Match: &servicefabricmesh.HttpRouteMatchRuleArgs{
 * 										Headers: servicefabricmesh.HttpRouteMatchHeaderArray{
 * 											&servicefabricmesh.HttpRouteMatchHeaderArgs{
 * 												Name:  pulumi.String("accept"),
 * 												Type:  pulumi.String(servicefabricmesh.HeaderMatchTypeExact),
 * 												Value: pulumi.String("application/json"),
 * 											},
 * 										},
 * 										Path: &servicefabricmesh.HttpRouteMatchPathArgs{
 * 											Rewrite: pulumi.String("/"),
 * 											Type:    pulumi.String(servicefabricmesh.PathMatchTypePrefix),
 * 											Value:   pulumi.String("/index"),
 * 										},
 * 									},
 * 									Name: pulumi.String("index"),
 * 								},
 * 							},
 * 						},
 * 					},
 * 					Name: pulumi.String("contosoWebsite"),
 * 					Port: pulumi.Int(8081),
 * 				},
 * 			},
 * 			Location:          pulumi.String("EastUS"),
 * 			ResourceGroupName: pulumi.String("sbz_demo"),
 * 			SourceNetwork: &servicefabricmesh.NetworkRefArgs{
 * 				Name: pulumi.String("Open"),
 * 			},
 * 			Tags: nil,
 * 			Tcp: servicefabricmesh.TcpConfigArray{
 * 				&servicefabricmesh.TcpConfigArgs{
 * 					Destination: &servicefabricmesh.GatewayDestinationArgs{
 * 						ApplicationName: pulumi.String("helloWorldApp"),
 * 						EndpointName:    pulumi.String("helloWorldListener"),
 * 						ServiceName:     pulumi.String("helloWorldService"),
 * 					},
 * 					Name: pulumi.String("web"),
 * 					Port: pulumi.Int(80),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.servicefabricmesh.Gateway;
 * import com.pulumi.azurenative.servicefabricmesh.GatewayArgs;
 * import com.pulumi.azurenative.servicefabricmesh.inputs.NetworkRefArgs;
 * import com.pulumi.azurenative.servicefabricmesh.inputs.HttpConfigArgs;
 * import com.pulumi.azurenative.servicefabricmesh.inputs.TcpConfigArgs;
 * import com.pulumi.azurenative.servicefabricmesh.inputs.GatewayDestinationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var gateway = new Gateway("gateway", GatewayArgs.builder()
 *             .description("Service Fabric Mesh sample gateway.")
 *             .destinationNetwork(NetworkRefArgs.builder()
 *                 .name("helloWorldNetwork")
 *                 .build())
 *             .gatewayResourceName("sampleGateway")
 *             .http(HttpConfigArgs.builder()
 *                 .hosts(HttpHostConfigArgs.builder()
 *                     .name("contoso.com")
 *                     .routes(HttpRouteConfigArgs.builder()
 *                         .destination(GatewayDestinationArgs.builder()
 *                             .applicationName("httpHelloWorldApp")
 *                             .endpointName("indexHttpEndpoint")
 *                             .serviceName("indexService")
 *                             .build())
 *                         .match(HttpRouteMatchRuleArgs.builder()
 *                             .headers(HttpRouteMatchHeaderArgs.builder()
 *                                 .name("accept")
 *                                 .type("exact")
 *                                 .value("application/json")
 *                                 .build())
 *                             .path(HttpRouteMatchPathArgs.builder()
 *                                 .rewrite("/")
 *                                 .type("prefix")
 *                                 .value("/index")
 *                                 .build())
 *                             .build())
 *                         .name("index")
 *                         .build())
 *                     .build())
 *                 .name("contosoWebsite")
 *                 .port(8081)
 *                 .build())
 *             .location("EastUS")
 *             .resourceGroupName("sbz_demo")
 *             .sourceNetwork(NetworkRefArgs.builder()
 *                 .name("Open")
 *                 .build())
 *             .tags()
 *             .tcp(TcpConfigArgs.builder()
 *                 .destination(GatewayDestinationArgs.builder()
 *                     .applicationName("helloWorldApp")
 *                     .endpointName("helloWorldListener")
 *                     .serviceName("helloWorldService")
 *                     .build())
 *                 .name("web")
 *                 .port(80)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:servicefabricmesh:Gateway sampleGateway /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceFabricMesh/gateways/{gatewayResourceName}
 * ```
 * @property description User readable description of the gateway.
 * @property destinationNetwork Network that the Application is using.
 * @property gatewayResourceName The identity of the gateway.
 * @property http Configuration for http connectivity for this gateway.
 * @property location The geo-location where the resource lives
 * @property resourceGroupName Azure resource group name
 * @property sourceNetwork Network the gateway should listen on for requests.
 * @property tags Resource tags.
 * @property tcp Configuration for tcp connectivity for this gateway.
 */
public data class GatewayArgs(
    public val description: Output<String>? = null,
    public val destinationNetwork: Output<NetworkRefArgs>? = null,
    public val gatewayResourceName: Output<String>? = null,
    public val http: Output<List<HttpConfigArgs>>? = null,
    public val location: Output<String>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sourceNetwork: Output<NetworkRefArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val tcp: Output<List<TcpConfigArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.servicefabricmesh.GatewayArgs> {
    override fun toJava(): com.pulumi.azurenative.servicefabricmesh.GatewayArgs =
        com.pulumi.azurenative.servicefabricmesh.GatewayArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .destinationNetwork(
                destinationNetwork?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .gatewayResourceName(gatewayResourceName?.applyValue({ args0 -> args0 }))
            .http(http?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .location(location?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .sourceNetwork(sourceNetwork?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .tcp(
                tcp?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [GatewayArgs].
 */
@PulumiTagMarker
public class GatewayArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var destinationNetwork: Output<NetworkRefArgs>? = null

    private var gatewayResourceName: Output<String>? = null

    private var http: Output<List<HttpConfigArgs>>? = null

    private var location: Output<String>? = null

    private var resourceGroupName: Output<String>? = null

    private var sourceNetwork: Output<NetworkRefArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var tcp: Output<List<TcpConfigArgs>>? = null

    /**
     * @param value User readable description of the gateway.
     */
    @JvmName("kcbywgboqqtkynya")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Network that the Application is using.
     */
    @JvmName("spgumljeqgswqvau")
    public suspend fun destinationNetwork(`value`: Output<NetworkRefArgs>) {
        this.destinationNetwork = value
    }

    /**
     * @param value The identity of the gateway.
     */
    @JvmName("lrdoimssendcpxqu")
    public suspend fun gatewayResourceName(`value`: Output<String>) {
        this.gatewayResourceName = value
    }

    /**
     * @param value Configuration for http connectivity for this gateway.
     */
    @JvmName("evxndhdcueodlogg")
    public suspend fun http(`value`: Output<List<HttpConfigArgs>>) {
        this.http = value
    }

    @JvmName("orrnsvapdjhtmswl")
    public suspend fun http(vararg values: Output<HttpConfigArgs>) {
        this.http = Output.all(values.asList())
    }

    /**
     * @param values Configuration for http connectivity for this gateway.
     */
    @JvmName("xqsscnyqwvcuyphi")
    public suspend fun http(values: List<Output<HttpConfigArgs>>) {
        this.http = Output.all(values)
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("paouhnspuhggxlxq")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Azure resource group name
     */
    @JvmName("fksityhqnlukeacy")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Network the gateway should listen on for requests.
     */
    @JvmName("icuafqhhgbpdsiok")
    public suspend fun sourceNetwork(`value`: Output<NetworkRefArgs>) {
        this.sourceNetwork = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("wvfrdcwveyquhpcm")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Configuration for tcp connectivity for this gateway.
     */
    @JvmName("dryqavcinlyxdmxu")
    public suspend fun tcp(`value`: Output<List<TcpConfigArgs>>) {
        this.tcp = value
    }

    @JvmName("fveebslmxvvvnnbc")
    public suspend fun tcp(vararg values: Output<TcpConfigArgs>) {
        this.tcp = Output.all(values.asList())
    }

    /**
     * @param values Configuration for tcp connectivity for this gateway.
     */
    @JvmName("mvsswdbewycxynee")
    public suspend fun tcp(values: List<Output<TcpConfigArgs>>) {
        this.tcp = Output.all(values)
    }

    /**
     * @param value User readable description of the gateway.
     */
    @JvmName("hafwddauunacblyd")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Network that the Application is using.
     */
    @JvmName("utgpxowvukrgetly")
    public suspend fun destinationNetwork(`value`: NetworkRefArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinationNetwork = mapped
    }

    /**
     * @param argument Network that the Application is using.
     */
    @JvmName("nmmjqddjmfaflwvb")
    public suspend fun destinationNetwork(argument: suspend NetworkRefArgsBuilder.() -> Unit) {
        val toBeMapped = NetworkRefArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.destinationNetwork = mapped
    }

    /**
     * @param value The identity of the gateway.
     */
    @JvmName("xtwnrckaoechykat")
    public suspend fun gatewayResourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gatewayResourceName = mapped
    }

    /**
     * @param value Configuration for http connectivity for this gateway.
     */
    @JvmName("kxnohqrvunwrvyeq")
    public suspend fun http(`value`: List<HttpConfigArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.http = mapped
    }

    /**
     * @param argument Configuration for http connectivity for this gateway.
     */
    @JvmName("lnfyarvajynfuney")
    public suspend fun http(argument: List<suspend HttpConfigArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { HttpConfigArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.http = mapped
    }

    /**
     * @param argument Configuration for http connectivity for this gateway.
     */
    @JvmName("vlfpapcuujyfpdfl")
    public suspend fun http(vararg argument: suspend HttpConfigArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { HttpConfigArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.http = mapped
    }

    /**
     * @param argument Configuration for http connectivity for this gateway.
     */
    @JvmName("wsfbkidcbexcyimh")
    public suspend fun http(argument: suspend HttpConfigArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(HttpConfigArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.http = mapped
    }

    /**
     * @param values Configuration for http connectivity for this gateway.
     */
    @JvmName("idhrndthfqkbksow")
    public suspend fun http(vararg values: HttpConfigArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.http = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("ihmmfijaytehhlci")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Azure resource group name
     */
    @JvmName("isarwjehmbdcoirk")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Network the gateway should listen on for requests.
     */
    @JvmName("qaygytvqgddiuokl")
    public suspend fun sourceNetwork(`value`: NetworkRefArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceNetwork = mapped
    }

    /**
     * @param argument Network the gateway should listen on for requests.
     */
    @JvmName("qdikhiuyenjwtrih")
    public suspend fun sourceNetwork(argument: suspend NetworkRefArgsBuilder.() -> Unit) {
        val toBeMapped = NetworkRefArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sourceNetwork = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("axbleqokdcyehmbi")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("wmgoyeialfgeuqiy")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Configuration for tcp connectivity for this gateway.
     */
    @JvmName("bjqordojtgqmthnv")
    public suspend fun tcp(`value`: List<TcpConfigArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tcp = mapped
    }

    /**
     * @param argument Configuration for tcp connectivity for this gateway.
     */
    @JvmName("ldcvkqqqoxtejkek")
    public suspend fun tcp(argument: List<suspend TcpConfigArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { TcpConfigArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.tcp = mapped
    }

    /**
     * @param argument Configuration for tcp connectivity for this gateway.
     */
    @JvmName("mijdekwyyydpbqyn")
    public suspend fun tcp(vararg argument: suspend TcpConfigArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { TcpConfigArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.tcp = mapped
    }

    /**
     * @param argument Configuration for tcp connectivity for this gateway.
     */
    @JvmName("cufidtcupinihogi")
    public suspend fun tcp(argument: suspend TcpConfigArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(TcpConfigArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.tcp = mapped
    }

    /**
     * @param values Configuration for tcp connectivity for this gateway.
     */
    @JvmName("kkcpctaidhwsxkmi")
    public suspend fun tcp(vararg values: TcpConfigArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tcp = mapped
    }

    internal fun build(): GatewayArgs = GatewayArgs(
        description = description,
        destinationNetwork = destinationNetwork,
        gatewayResourceName = gatewayResourceName,
        http = http,
        location = location,
        resourceGroupName = resourceGroupName,
        sourceNetwork = sourceNetwork,
        tags = tags,
        tcp = tcp,
    )
}
