@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabricmesh.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [SecretValue].
 */
@PulumiTagMarker
public class SecretValueResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SecretValueArgs = SecretValueArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SecretValueArgsBuilder.() -> Unit) {
        val builder = SecretValueArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SecretValue {
        val builtJavaResource =
            com.pulumi.azurenative.servicefabricmesh.SecretValue(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return SecretValue(builtJavaResource)
    }
}

/**
 * This type describes a value of a secret resource. The name of this resource is the version identifier corresponding to this secret value.
 * Azure REST API version: 2018-09-01-preview. Prior API version in Azure Native 1.x: 2018-09-01-preview.
 * ## Example Usage
 * ### CreateSecretValue
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var secretValue = new AzureNative.ServiceFabricMesh.SecretValue("secretValue", new()
 *     {
 *         Location = "West US",
 *         ResourceGroupName = "sbz_demo",
 *         SecretResourceName = "dbConnectionString",
 *         SecretValueResourceName = "v1",
 *         Value = "mongodb://contoso123:0Fc3IolnL12312asdfawejunASDF@asdfYXX2t8a97kghVcUzcDv98hawelufhawefafnoQRGwNj2nMPL1Y9qsIr9Srdw==@contoso123.documents.azure.com:10255/mydatabase?ssl=true",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/servicefabricmesh/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := servicefabricmesh.NewSecretValue(ctx, "secretValue", &servicefabricmesh.SecretValueArgs{
 * 			Location:                pulumi.String("West US"),
 * 			ResourceGroupName:       pulumi.String("sbz_demo"),
 * 			SecretResourceName:      pulumi.String("dbConnectionString"),
 * 			SecretValueResourceName: pulumi.String("v1"),
 * 			Value:                   pulumi.String("mongodb://contoso123:0Fc3IolnL12312asdfawejunASDF@asdfYXX2t8a97kghVcUzcDv98hawelufhawefafnoQRGwNj2nMPL1Y9qsIr9Srdw==@contoso123.documents.azure.com:10255/mydatabase?ssl=true"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.servicefabricmesh.SecretValue;
 * import com.pulumi.azurenative.servicefabricmesh.SecretValueArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var secretValue = new SecretValue("secretValue", SecretValueArgs.builder()
 *             .location("West US")
 *             .resourceGroupName("sbz_demo")
 *             .secretResourceName("dbConnectionString")
 *             .secretValueResourceName("v1")
 *             .value("mongodb://contoso123:0Fc3IolnL12312asdfawejunASDF@asdfYXX2t8a97kghVcUzcDv98hawelufhawefafnoQRGwNj2nMPL1Y9qsIr9Srdw==@contoso123.documents.azure.com:10255/mydatabase?ssl=true")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:servicefabricmesh:SecretValue v1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceFabricMesh/secrets/{secretResourceName}/values/{secretValueResourceName}
 * ```
 */
public class SecretValue internal constructor(
    override val javaResource: com.pulumi.azurenative.servicefabricmesh.SecretValue,
) : KotlinCustomResource(javaResource, SecretValueMapper) {
    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * State of the resource.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. Ex- Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The actual value of the secret.
     */
    public val `value`: Output<String>?
        get() = javaResource.`value`().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object SecretValueMapper : ResourceMapper<SecretValue> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.servicefabricmesh.SecretValue::class == javaResource::class

    override fun map(javaResource: Resource): SecretValue = SecretValue(
        javaResource as
            com.pulumi.azurenative.servicefabricmesh.SecretValue,
    )
}

/**
 * @see [SecretValue].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SecretValue].
 */
public suspend fun secretValue(name: String, block: suspend SecretValueResourceBuilder.() -> Unit):
    SecretValue {
    val builder = SecretValueResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SecretValue].
 * @param name The _unique_ name of the resulting resource.
 */
public fun secretValue(name: String): SecretValue {
    val builder = SecretValueResourceBuilder()
    builder.name(name)
    return builder.build()
}
