@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabricmesh.kotlin.inputs

import com.pulumi.azurenative.servicefabricmesh.inputs.AzureInternalMonitoringPipelineSinkDescriptionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Diagnostics settings for Geneva.
 * @property accountName Azure Internal monitoring pipeline account.
 * @property autoKeyConfigUrl Azure Internal monitoring pipeline autokey associated with the certificate.
 * @property description A description of the sink.
 * @property fluentdConfigUrl Azure Internal monitoring agent fluentd configuration.
 * @property kind The kind of DiagnosticsSink.
 * Expected value is 'AzureInternalMonitoringPipeline'.
 * @property maConfigUrl Azure Internal monitoring agent configuration.
 * @property name Name of the sink. This value is referenced by DiagnosticsReferenceDescription
 * @property namespace Azure Internal monitoring pipeline account namespace.
 */
public data class AzureInternalMonitoringPipelineSinkDescriptionArgs(
    public val accountName: Output<String>? = null,
    public val autoKeyConfigUrl: Output<String>? = null,
    public val description: Output<String>? = null,
    public val fluentdConfigUrl: Output<Any>? = null,
    public val kind: Output<String>,
    public val maConfigUrl: Output<String>? = null,
    public val name: Output<String>? = null,
    public val namespace: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.servicefabricmesh.inputs.AzureInternalMonitoringPipelineSinkDescriptionArgs> {
    override fun toJava():
        com.pulumi.azurenative.servicefabricmesh.inputs.AzureInternalMonitoringPipelineSinkDescriptionArgs =
        com.pulumi.azurenative.servicefabricmesh.inputs.AzureInternalMonitoringPipelineSinkDescriptionArgs.builder()
            .accountName(accountName?.applyValue({ args0 -> args0 }))
            .autoKeyConfigUrl(autoKeyConfigUrl?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .fluentdConfigUrl(fluentdConfigUrl?.applyValue({ args0 -> args0 }))
            .kind(kind.applyValue({ args0 -> args0 }))
            .maConfigUrl(maConfigUrl?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .namespace(namespace?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureInternalMonitoringPipelineSinkDescriptionArgs].
 */
@PulumiTagMarker
public class AzureInternalMonitoringPipelineSinkDescriptionArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var autoKeyConfigUrl: Output<String>? = null

    private var description: Output<String>? = null

    private var fluentdConfigUrl: Output<Any>? = null

    private var kind: Output<String>? = null

    private var maConfigUrl: Output<String>? = null

    private var name: Output<String>? = null

    private var namespace: Output<String>? = null

    /**
     * @param value Azure Internal monitoring pipeline account.
     */
    @JvmName("gkfptywsgcvmmfgx")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value Azure Internal monitoring pipeline autokey associated with the certificate.
     */
    @JvmName("gbmtqkuvlbpaqhlt")
    public suspend fun autoKeyConfigUrl(`value`: Output<String>) {
        this.autoKeyConfigUrl = value
    }

    /**
     * @param value A description of the sink.
     */
    @JvmName("aershxvsfomkfsex")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Azure Internal monitoring agent fluentd configuration.
     */
    @JvmName("bbbpewgnymyeugid")
    public suspend fun fluentdConfigUrl(`value`: Output<Any>) {
        this.fluentdConfigUrl = value
    }

    /**
     * @param value The kind of DiagnosticsSink.
     * Expected value is 'AzureInternalMonitoringPipeline'.
     */
    @JvmName("ydrdwykmpxejdoel")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Azure Internal monitoring agent configuration.
     */
    @JvmName("xlumsjwwsvofufah")
    public suspend fun maConfigUrl(`value`: Output<String>) {
        this.maConfigUrl = value
    }

    /**
     * @param value Name of the sink. This value is referenced by DiagnosticsReferenceDescription
     */
    @JvmName("gdelamkltsbuskdm")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Azure Internal monitoring pipeline account namespace.
     */
    @JvmName("manwjnqsubcljcyi")
    public suspend fun namespace(`value`: Output<String>) {
        this.namespace = value
    }

    /**
     * @param value Azure Internal monitoring pipeline account.
     */
    @JvmName("dyqgbxriknwmaadk")
    public suspend fun accountName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value Azure Internal monitoring pipeline autokey associated with the certificate.
     */
    @JvmName("abmwhqqhwxofvyxi")
    public suspend fun autoKeyConfigUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoKeyConfigUrl = mapped
    }

    /**
     * @param value A description of the sink.
     */
    @JvmName("qfgjydggfjultadi")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Azure Internal monitoring agent fluentd configuration.
     */
    @JvmName("bsfotgdnvfeprrno")
    public suspend fun fluentdConfigUrl(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fluentdConfigUrl = mapped
    }

    /**
     * @param value The kind of DiagnosticsSink.
     * Expected value is 'AzureInternalMonitoringPipeline'.
     */
    @JvmName("undcwlnmlysgfnwn")
    public suspend fun kind(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    /**
     * @param value Azure Internal monitoring agent configuration.
     */
    @JvmName("nwavpgexrnweinsk")
    public suspend fun maConfigUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maConfigUrl = mapped
    }

    /**
     * @param value Name of the sink. This value is referenced by DiagnosticsReferenceDescription
     */
    @JvmName("cwfqriuqmbceewyj")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Azure Internal monitoring pipeline account namespace.
     */
    @JvmName("phjfqjuxthrxpqiy")
    public suspend fun namespace(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespace = mapped
    }

    internal fun build(): AzureInternalMonitoringPipelineSinkDescriptionArgs =
        AzureInternalMonitoringPipelineSinkDescriptionArgs(
            accountName = accountName,
            autoKeyConfigUrl = autoKeyConfigUrl,
            description = description,
            fluentdConfigUrl = fluentdConfigUrl,
            kind = kind ?: throw PulumiNullFieldException("kind"),
            maConfigUrl = maConfigUrl,
            name = name,
            namespace = namespace,
        )
}
