@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabricmesh.kotlin.inputs

import com.pulumi.azurenative.servicefabricmesh.inputs.GetNetworkPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property networkResourceName The identity of the network.
 * @property resourceGroupName Azure resource group name
 */
public data class GetNetworkPlainArgs(
    public val networkResourceName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.servicefabricmesh.inputs.GetNetworkPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.servicefabricmesh.inputs.GetNetworkPlainArgs =
        com.pulumi.azurenative.servicefabricmesh.inputs.GetNetworkPlainArgs.builder()
            .networkResourceName(networkResourceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetNetworkPlainArgs].
 */
@PulumiTagMarker
public class GetNetworkPlainArgsBuilder internal constructor() {
    private var networkResourceName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The identity of the network.
     */
    @JvmName("nnpqtbntfqiyywex")
    public suspend fun networkResourceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.networkResourceName = mapped
    }

    /**
     * @param value Azure resource group name
     */
    @JvmName("viovofpsmhjncinf")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetNetworkPlainArgs = GetNetworkPlainArgs(
        networkResourceName = networkResourceName ?: throw PulumiNullFieldException("networkResourceName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
