@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabricmesh.kotlin.inputs

import com.pulumi.azurenative.servicefabricmesh.inputs.HttpHostConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Describes the hostname properties for http routing.
 * @property name http hostname config name.
 * @property routes Route information to use for routing. Routes are processed in the order they are specified. Specify routes that are more specific before routes that can handle general cases.
 */
public data class HttpHostConfigArgs(
    public val name: Output<String>,
    public val routes: Output<List<HttpRouteConfigArgs>>,
) : ConvertibleToJava<com.pulumi.azurenative.servicefabricmesh.inputs.HttpHostConfigArgs> {
    override fun toJava(): com.pulumi.azurenative.servicefabricmesh.inputs.HttpHostConfigArgs =
        com.pulumi.azurenative.servicefabricmesh.inputs.HttpHostConfigArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .routes(
                routes.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [HttpHostConfigArgs].
 */
@PulumiTagMarker
public class HttpHostConfigArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var routes: Output<List<HttpRouteConfigArgs>>? = null

    /**
     * @param value http hostname config name.
     */
    @JvmName("juhxsueisyjkidjx")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Route information to use for routing. Routes are processed in the order they are specified. Specify routes that are more specific before routes that can handle general cases.
     */
    @JvmName("wluconnlckbamaum")
    public suspend fun routes(`value`: Output<List<HttpRouteConfigArgs>>) {
        this.routes = value
    }

    @JvmName("upnahlsicbjwrokx")
    public suspend fun routes(vararg values: Output<HttpRouteConfigArgs>) {
        this.routes = Output.all(values.asList())
    }

    /**
     * @param values Route information to use for routing. Routes are processed in the order they are specified. Specify routes that are more specific before routes that can handle general cases.
     */
    @JvmName("acyqduydgvycigbe")
    public suspend fun routes(values: List<Output<HttpRouteConfigArgs>>) {
        this.routes = Output.all(values)
    }

    /**
     * @param value http hostname config name.
     */
    @JvmName("hubhvpiegcrjjvls")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Route information to use for routing. Routes are processed in the order they are specified. Specify routes that are more specific before routes that can handle general cases.
     */
    @JvmName("budfyagjtnfsndgo")
    public suspend fun routes(`value`: List<HttpRouteConfigArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.routes = mapped
    }

    /**
     * @param argument Route information to use for routing. Routes are processed in the order they are specified. Specify routes that are more specific before routes that can handle general cases.
     */
    @JvmName("pmpykxjwvakjrnkv")
    public suspend fun routes(argument: List<suspend HttpRouteConfigArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            HttpRouteConfigArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.routes = mapped
    }

    /**
     * @param argument Route information to use for routing. Routes are processed in the order they are specified. Specify routes that are more specific before routes that can handle general cases.
     */
    @JvmName("hfvesgsfnbiemwqj")
    public suspend fun routes(vararg argument: suspend HttpRouteConfigArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            HttpRouteConfigArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.routes = mapped
    }

    /**
     * @param argument Route information to use for routing. Routes are processed in the order they are specified. Specify routes that are more specific before routes that can handle general cases.
     */
    @JvmName("srcxdsmwiskydndm")
    public suspend fun routes(argument: suspend HttpRouteConfigArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(HttpRouteConfigArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.routes = mapped
    }

    /**
     * @param values Route information to use for routing. Routes are processed in the order they are specified. Specify routes that are more specific before routes that can handle general cases.
     */
    @JvmName("bcbnkakriqfwuimu")
    public suspend fun routes(vararg values: HttpRouteConfigArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.routes = mapped
    }

    internal fun build(): HttpHostConfigArgs = HttpHostConfigArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        routes = routes ?: throw PulumiNullFieldException("routes"),
    )
}
