@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabricmesh.kotlin.inputs

import com.pulumi.azurenative.servicefabricmesh.inputs.HttpRouteConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Describes the hostname properties for http routing.
 * @property destination Describes destination endpoint for routing traffic.
 * @property match Describes a rule for http route matching.
 * @property name http route name.
 */
public data class HttpRouteConfigArgs(
    public val destination: Output<GatewayDestinationArgs>,
    public val match: Output<HttpRouteMatchRuleArgs>,
    public val name: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.servicefabricmesh.inputs.HttpRouteConfigArgs> {
    override fun toJava(): com.pulumi.azurenative.servicefabricmesh.inputs.HttpRouteConfigArgs =
        com.pulumi.azurenative.servicefabricmesh.inputs.HttpRouteConfigArgs.builder()
            .destination(destination.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .match(match.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HttpRouteConfigArgs].
 */
@PulumiTagMarker
public class HttpRouteConfigArgsBuilder internal constructor() {
    private var destination: Output<GatewayDestinationArgs>? = null

    private var match: Output<HttpRouteMatchRuleArgs>? = null

    private var name: Output<String>? = null

    /**
     * @param value Describes destination endpoint for routing traffic.
     */
    @JvmName("htcqhbermwftfnuw")
    public suspend fun destination(`value`: Output<GatewayDestinationArgs>) {
        this.destination = value
    }

    /**
     * @param value Describes a rule for http route matching.
     */
    @JvmName("ttdyhdbanrfecuuo")
    public suspend fun match(`value`: Output<HttpRouteMatchRuleArgs>) {
        this.match = value
    }

    /**
     * @param value http route name.
     */
    @JvmName("jbnqargatfihyxub")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Describes destination endpoint for routing traffic.
     */
    @JvmName("rehjgndlbydlwgvb")
    public suspend fun destination(`value`: GatewayDestinationArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destination = mapped
    }

    /**
     * @param argument Describes destination endpoint for routing traffic.
     */
    @JvmName("insrtquxedpkcjag")
    public suspend fun destination(argument: suspend GatewayDestinationArgsBuilder.() -> Unit) {
        val toBeMapped = GatewayDestinationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.destination = mapped
    }

    /**
     * @param value Describes a rule for http route matching.
     */
    @JvmName("sjdnjksdvxiahtak")
    public suspend fun match(`value`: HttpRouteMatchRuleArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.match = mapped
    }

    /**
     * @param argument Describes a rule for http route matching.
     */
    @JvmName("psdvarfipohgybds")
    public suspend fun match(argument: suspend HttpRouteMatchRuleArgsBuilder.() -> Unit) {
        val toBeMapped = HttpRouteMatchRuleArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.match = mapped
    }

    /**
     * @param value http route name.
     */
    @JvmName("mkmbswrympywghlw")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): HttpRouteConfigArgs = HttpRouteConfigArgs(
        destination = destination ?: throw PulumiNullFieldException("destination"),
        match = match ?: throw PulumiNullFieldException("match"),
        name = name ?: throw PulumiNullFieldException("name"),
    )
}
