@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabricmesh.kotlin.inputs

import com.pulumi.azurenative.servicefabricmesh.inputs.HttpRouteMatchHeaderArgs.builder
import com.pulumi.azurenative.servicefabricmesh.kotlin.enums.HeaderMatchType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes header information for http route matching.
 * @property name Name of header to match in request.
 * @property type how to match header value
 * @property value Value of header to match in request.
 */
public data class HttpRouteMatchHeaderArgs(
    public val name: Output<String>,
    public val type: Output<Either<String, HeaderMatchType>>? = null,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.servicefabricmesh.inputs.HttpRouteMatchHeaderArgs> {
    override fun toJava(): com.pulumi.azurenative.servicefabricmesh.inputs.HttpRouteMatchHeaderArgs =
        com.pulumi.azurenative.servicefabricmesh.inputs.HttpRouteMatchHeaderArgs.builder()
            .name(name.applyValue({ args0 -> args0 }))
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HttpRouteMatchHeaderArgs].
 */
@PulumiTagMarker
public class HttpRouteMatchHeaderArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var type: Output<Either<String, HeaderMatchType>>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Name of header to match in request.
     */
    @JvmName("rnfqykilplfamorv")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value how to match header value
     */
    @JvmName("mbjwltbhetfklckx")
    public suspend fun type(`value`: Output<Either<String, HeaderMatchType>>) {
        this.type = value
    }

    /**
     * @param value Value of header to match in request.
     */
    @JvmName("yraelupaitgkggio")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Name of header to match in request.
     */
    @JvmName("qvwjwdaaegnrungj")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value how to match header value
     */
    @JvmName("mcielummttptiyyj")
    public suspend fun type(`value`: Either<String, HeaderMatchType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value how to match header value
     */
    @JvmName("ltnblfginktehnyo")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, HeaderMatchType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value how to match header value
     */
    @JvmName("ugdxltfvmnwwlfmk")
    public fun type(`value`: HeaderMatchType) {
        val toBeMapped = Either.ofRight<String, HeaderMatchType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Value of header to match in request.
     */
    @JvmName("inveqpfyqueqkxbc")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): HttpRouteMatchHeaderArgs = HttpRouteMatchHeaderArgs(
        name = name ?: throw PulumiNullFieldException("name"),
        type = type,
        `value` = `value`,
    )
}
