@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabricmesh.kotlin.inputs

import com.pulumi.azurenative.servicefabricmesh.inputs.HttpRouteMatchPathArgs.builder
import com.pulumi.azurenative.servicefabricmesh.kotlin.enums.PathMatchType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Path to match for routing.
 * @property rewrite replacement string for matched part of the Uri.
 * @property type how to match value in the Uri
 * @property value Uri path to match for request.
 */
public data class HttpRouteMatchPathArgs(
    public val rewrite: Output<String>? = null,
    public val type: Output<Either<String, PathMatchType>>,
    public val `value`: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.servicefabricmesh.inputs.HttpRouteMatchPathArgs> {
    override fun toJava(): com.pulumi.azurenative.servicefabricmesh.inputs.HttpRouteMatchPathArgs =
        com.pulumi.azurenative.servicefabricmesh.inputs.HttpRouteMatchPathArgs.builder()
            .rewrite(rewrite?.applyValue({ args0 -> args0 }))
            .type(
                type.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HttpRouteMatchPathArgs].
 */
@PulumiTagMarker
public class HttpRouteMatchPathArgsBuilder internal constructor() {
    private var rewrite: Output<String>? = null

    private var type: Output<Either<String, PathMatchType>>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value replacement string for matched part of the Uri.
     */
    @JvmName("gfluvtemxcrvchmy")
    public suspend fun rewrite(`value`: Output<String>) {
        this.rewrite = value
    }

    /**
     * @param value how to match value in the Uri
     */
    @JvmName("qjxbwuofxdtqnxqt")
    public suspend fun type(`value`: Output<Either<String, PathMatchType>>) {
        this.type = value
    }

    /**
     * @param value Uri path to match for request.
     */
    @JvmName("rnytxqwnhsjaicyi")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value replacement string for matched part of the Uri.
     */
    @JvmName("ftykydcpbkuludmv")
    public suspend fun rewrite(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rewrite = mapped
    }

    /**
     * @param value how to match value in the Uri
     */
    @JvmName("ykqbkahjvxfgrsgy")
    public suspend fun type(`value`: Either<String, PathMatchType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value how to match value in the Uri
     */
    @JvmName("kemrjylocbgfnuoe")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PathMatchType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value how to match value in the Uri
     */
    @JvmName("ypqywikmcvsfwmto")
    public fun type(`value`: PathMatchType) {
        val toBeMapped = Either.ofRight<String, PathMatchType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Uri path to match for request.
     */
    @JvmName("hhprlhfrmufoibai")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): HttpRouteMatchPathArgs = HttpRouteMatchPathArgs(
        rewrite = rewrite,
        type = type ?: throw PulumiNullFieldException("type"),
        `value` = `value` ?: throw PulumiNullFieldException("value"),
    )
}
