@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabricmesh.kotlin.inputs

import com.pulumi.azurenative.servicefabricmesh.inputs.ImageRegistryCredentialArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Image registry credential.
 * @property password The password for the private registry. The password is required for create or update operations, however it is not returned in the get or list operations.
 * @property server Docker image registry server, without protocol such as `http` and `https`.
 * @property username The username for the private registry.
 */
public data class ImageRegistryCredentialArgs(
    public val password: Output<String>? = null,
    public val server: Output<String>,
    public val username: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.servicefabricmesh.inputs.ImageRegistryCredentialArgs> {
    override fun toJava(): com.pulumi.azurenative.servicefabricmesh.inputs.ImageRegistryCredentialArgs =
        com.pulumi.azurenative.servicefabricmesh.inputs.ImageRegistryCredentialArgs.builder()
            .password(password?.applyValue({ args0 -> args0 }))
            .server(server.applyValue({ args0 -> args0 }))
            .username(username.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ImageRegistryCredentialArgs].
 */
@PulumiTagMarker
public class ImageRegistryCredentialArgsBuilder internal constructor() {
    private var password: Output<String>? = null

    private var server: Output<String>? = null

    private var username: Output<String>? = null

    /**
     * @param value The password for the private registry. The password is required for create or update operations, however it is not returned in the get or list operations.
     */
    @JvmName("jgojyathfnhxqabs")
    public suspend fun password(`value`: Output<String>) {
        this.password = value
    }

    /**
     * @param value Docker image registry server, without protocol such as `http` and `https`.
     */
    @JvmName("fcdtnhnnxhtchxto")
    public suspend fun server(`value`: Output<String>) {
        this.server = value
    }

    /**
     * @param value The username for the private registry.
     */
    @JvmName("ladwahubgsjdantu")
    public suspend fun username(`value`: Output<String>) {
        this.username = value
    }

    /**
     * @param value The password for the private registry. The password is required for create or update operations, however it is not returned in the get or list operations.
     */
    @JvmName("mkpcmwbsuvxoarha")
    public suspend fun password(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value Docker image registry server, without protocol such as `http` and `https`.
     */
    @JvmName("abqyqvddfmkjglev")
    public suspend fun server(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.server = mapped
    }

    /**
     * @param value The username for the private registry.
     */
    @JvmName("uevnrfnheanmityj")
    public suspend fun username(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.username = mapped
    }

    internal fun build(): ImageRegistryCredentialArgs = ImageRegistryCredentialArgs(
        password = password,
        server = server ?: throw PulumiNullFieldException("server"),
        username = username ?: throw PulumiNullFieldException("username"),
    )
}
