@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabricmesh.kotlin.inputs

import com.pulumi.azurenative.servicefabricmesh.inputs.SecretResourcePropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes the properties of a secret resource.
 * @property contentType The type of the content stored in the secret value. The value of this property is opaque to Service Fabric. Once set, the value of this property cannot be changed.
 * @property description User readable description of the secret.
 * @property kind Describes the kind of secret.
 * Expected value is 'SecretResourceProperties'.
 */
public data class SecretResourcePropertiesArgs(
    public val contentType: Output<String>? = null,
    public val description: Output<String>? = null,
    public val kind: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.servicefabricmesh.inputs.SecretResourcePropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.servicefabricmesh.inputs.SecretResourcePropertiesArgs =
        com.pulumi.azurenative.servicefabricmesh.inputs.SecretResourcePropertiesArgs.builder()
            .contentType(contentType?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .kind(kind.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SecretResourcePropertiesArgs].
 */
@PulumiTagMarker
public class SecretResourcePropertiesArgsBuilder internal constructor() {
    private var contentType: Output<String>? = null

    private var description: Output<String>? = null

    private var kind: Output<String>? = null

    /**
     * @param value The type of the content stored in the secret value. The value of this property is opaque to Service Fabric. Once set, the value of this property cannot be changed.
     */
    @JvmName("ipeekwdbschgkmsy")
    public suspend fun contentType(`value`: Output<String>) {
        this.contentType = value
    }

    /**
     * @param value User readable description of the secret.
     */
    @JvmName("cwfjmpeygfyxnqpn")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Describes the kind of secret.
     * Expected value is 'SecretResourceProperties'.
     */
    @JvmName("ansfjrybolvejwpb")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value The type of the content stored in the secret value. The value of this property is opaque to Service Fabric. Once set, the value of this property cannot be changed.
     */
    @JvmName("hnqpakahaxfixjki")
    public suspend fun contentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.contentType = mapped
    }

    /**
     * @param value User readable description of the secret.
     */
    @JvmName("hqetcfrthhggidag")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Describes the kind of secret.
     * Expected value is 'SecretResourceProperties'.
     */
    @JvmName("xhhpqkbgsgraspmr")
    public suspend fun kind(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    internal fun build(): SecretResourcePropertiesArgs = SecretResourcePropertiesArgs(
        contentType = contentType,
        description = description,
        kind = kind ?: throw PulumiNullFieldException("kind"),
    )
}
