@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabricmesh.kotlin.inputs

import com.pulumi.azurenative.servicefabricmesh.inputs.TcpConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Describes the tcp configuration for external connectivity for this network.
 * @property destination Describes destination endpoint for routing traffic.
 * @property name tcp gateway config name.
 * @property port Specifies the port at which the service endpoint below needs to be exposed.
 */
public data class TcpConfigArgs(
    public val destination: Output<GatewayDestinationArgs>,
    public val name: Output<String>,
    public val port: Output<Int>,
) : ConvertibleToJava<com.pulumi.azurenative.servicefabricmesh.inputs.TcpConfigArgs> {
    override fun toJava(): com.pulumi.azurenative.servicefabricmesh.inputs.TcpConfigArgs =
        com.pulumi.azurenative.servicefabricmesh.inputs.TcpConfigArgs.builder()
            .destination(destination.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name.applyValue({ args0 -> args0 }))
            .port(port.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TcpConfigArgs].
 */
@PulumiTagMarker
public class TcpConfigArgsBuilder internal constructor() {
    private var destination: Output<GatewayDestinationArgs>? = null

    private var name: Output<String>? = null

    private var port: Output<Int>? = null

    /**
     * @param value Describes destination endpoint for routing traffic.
     */
    @JvmName("eqscblbjvjrcqmlc")
    public suspend fun destination(`value`: Output<GatewayDestinationArgs>) {
        this.destination = value
    }

    /**
     * @param value tcp gateway config name.
     */
    @JvmName("fhnhatofkavcyefo")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Specifies the port at which the service endpoint below needs to be exposed.
     */
    @JvmName("oknxucqofjlpppne")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value Describes destination endpoint for routing traffic.
     */
    @JvmName("uyvafuowmddnvrjg")
    public suspend fun destination(`value`: GatewayDestinationArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destination = mapped
    }

    /**
     * @param argument Describes destination endpoint for routing traffic.
     */
    @JvmName("qyuvsnphxqpiohkk")
    public suspend fun destination(argument: suspend GatewayDestinationArgsBuilder.() -> Unit) {
        val toBeMapped = GatewayDestinationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.destination = mapped
    }

    /**
     * @param value tcp gateway config name.
     */
    @JvmName("wlsvukiehhpabyqy")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Specifies the port at which the service endpoint below needs to be exposed.
     */
    @JvmName("oebxgkigpkvrebbj")
    public suspend fun port(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.port = mapped
    }

    internal fun build(): TcpConfigArgs = TcpConfigArgs(
        destination = destination ?: throw PulumiNullFieldException("destination"),
        name = name ?: throw PulumiNullFieldException("name"),
        port = port ?: throw PulumiNullFieldException("port"),
    )
}
