@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabricmesh.kotlin.outputs

import kotlin.Int
import kotlin.Suppress
import kotlin.collections.List

/**
 * Runtime information of a container instance.
 * @property currentState Current container instance state.
 * @property events The events of this container instance.
 * @property previousState Previous container instance state.
 * @property restartCount The number of times the container has been restarted.
 */
public data class ContainerInstanceViewResponse(
    public val currentState: ContainerStateResponse? = null,
    public val events: List<ContainerEventResponse>? = null,
    public val previousState: ContainerStateResponse? = null,
    public val restartCount: Int? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.servicefabricmesh.outputs.ContainerInstanceViewResponse):
            ContainerInstanceViewResponse = ContainerInstanceViewResponse(
            currentState = javaType.currentState().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.servicefabricmesh.kotlin.outputs.ContainerStateResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            events = javaType.events().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.servicefabricmesh.kotlin.outputs.ContainerEventResponse.Companion.toKotlin(args0)
                })
            }),
            previousState = javaType.previousState().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.servicefabricmesh.kotlin.outputs.ContainerStateResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            restartCount = javaType.restartCount().map({ args0 -> args0 }).orElse(null),
        )
    }
}
