@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.servicefabricmesh.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Path to match for routing.
 * @property rewrite replacement string for matched part of the Uri.
 * @property type how to match value in the Uri
 * @property value Uri path to match for request.
 */
public data class HttpRouteMatchPathResponse(
    public val rewrite: String? = null,
    public val type: String,
    public val `value`: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.servicefabricmesh.outputs.HttpRouteMatchPathResponse):
            HttpRouteMatchPathResponse = HttpRouteMatchPathResponse(
            rewrite = javaType.rewrite().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            `value` = javaType.`value`(),
        )
    }
}
